/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.input.SAXBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private XMLUtils() {
    }

    public static List<Element> getElementList(Element dataRoot, String name) {
        NodeList list = dataRoot.getElementsByTagName(name);
        ArrayList<Element> listElements = new ArrayList<Element>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element item = (Element)list.item(i);
            if (!item.getParentNode().equals(dataRoot)) continue;
            listElements.add(item);
        }
        return listElements;
    }

    public static String getElementAttribute(Element dataRoot, String name, String attr) {
        Element element = XMLUtils.getSingleElement(dataRoot, name);
        String attrValue = null;
        if (element != null) {
            attrValue = element.getAttribute(attr);
            attrValue = StringUtils.isNotBlank((CharSequence)attrValue) ? attrValue.trim() : null;
        }
        return attrValue;
    }

    public static String getElementValue(Element dataRoot, String name) {
        Element element = XMLUtils.getSingleElement(dataRoot, name);
        String elementValue = null;
        if (element != null) {
            elementValue = element.getTextContent();
            elementValue = StringUtils.isNotBlank((CharSequence)elementValue) ? elementValue.trim() : null;
        }
        return elementValue;
    }

    public static Element getSingleElement(Element dataRoot, String name) {
        List<Element> nodeList = XMLUtils.getElementList(dataRoot, name);
        Element element = null;
        if (nodeList != null && nodeList.size() > 0) {
            element = nodeList.get(0);
        }
        return element;
    }

    public static List<String> getElementValueList(Element rootElement, String subElementName) {
        if (rootElement == null) {
            return null;
        }
        List<Element> subElements = XMLUtils.getElementList(rootElement, subElementName);
        if (subElements == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Element el : subElements) {
            if (!StringUtils.isNotBlank((CharSequence)el.getTextContent())) continue;
            result.add(el.getTextContent().trim());
        }
        return result;
    }

    public static List<String[]> getElementValueArrayList(Element rootElement, String subElementName, String ... fieldsName) {
        if (rootElement == null) {
            return null;
        }
        List<Element> subElements = XMLUtils.getElementList(rootElement, subElementName);
        if (subElements == null) {
            return null;
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Element el : subElements) {
            String[] tmp = new String[fieldsName.length];
            for (int idx = 0; idx < fieldsName.length; ++idx) {
                tmp[idx] = XMLUtils.getElementValue(el, fieldsName[idx]);
            }
            result.add(tmp);
        }
        return result;
    }

    public static DocumentBuilderFactory getTrustedDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return factory;
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setExpandEntityReferences(false);
        factory.setXIncludeAware(false);
        return factory;
    }

    public static DocumentBuilder getTrustedDocumentBuilder(String ... allowedPaths) throws ParserConfigurationException {
        DocumentBuilderFactory factory = XMLUtils.getTrustedDocumentBuilderFactory();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new PathRestrictedEntityResolver(allowedPaths));
        return factory.newDocumentBuilder();
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return XMLUtils.getDocumentBuilderFactory().newDocumentBuilder();
    }

    public static SAXBuilder getSAXBuilder() {
        return XMLUtils.getSAXBuilder(false);
    }

    public static SAXBuilder getSAXBuilder(boolean validate) {
        SAXBuilder saxBuilder = new SAXBuilder();
        if (validate) {
            saxBuilder.setValidation(true);
        }
        saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        saxBuilder.setExpandEntities(false);
        return saxBuilder;
    }

    public static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        return xmlInputFactory;
    }

    public static class PathRestrictedEntityResolver
    implements EntityResolver {
        private final List<String> allowedBasePaths;

        public PathRestrictedEntityResolver(String ... allowedBasePaths) {
            this.allowedBasePaths = Arrays.asList(allowedBasePaths);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            Path resolvedPath;
            String filePath;
            if (systemId == null) {
                return null;
            }
            if (systemId.startsWith("file://")) {
                filePath = systemId.substring(7);
            } else if (systemId.startsWith("file:")) {
                filePath = systemId.substring(5);
            } else if (!systemId.contains("://")) {
                filePath = systemId;
            } else {
                throw new SAXException("External resources not allowed: " + systemId + ". Only local file paths are permitted.");
            }
            try {
                resolvedPath = Paths.get(filePath, new String[0]).toAbsolutePath().normalize();
            }
            catch (Exception e) {
                throw new SAXException("Invalid path: " + systemId, e);
            }
            boolean isAllowed = false;
            for (String basePath : this.allowedBasePaths) {
                Path allowedPath = Paths.get(basePath, new String[0]).toAbsolutePath().normalize();
                if (!resolvedPath.startsWith(allowedPath)) continue;
                isAllowed = true;
                break;
            }
            if (!isAllowed) {
                throw new SAXException("Access denied to path: " + resolvedPath);
            }
            File file = resolvedPath.toFile();
            if (!file.exists() || !file.canRead()) {
                throw new SAXException("File not found or not readable: " + resolvedPath);
            }
            return new InputSource(new FileInputStream(file));
        }
    }
}

