/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.browse.ItemCountDAO;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ItemCounter {
    private static Logger log = LogManager.getLogger(ItemCounter.class);
    @Autowired
    protected ItemService itemService;
    @Autowired
    protected ConfigurationService configurationService;

    protected ItemCounter() {
    }

    public int getCount(Context context, DSpaceObject dso) {
        boolean showStrengths = this.configurationService.getBooleanProperty("webui.strengths.show", false);
        boolean useCache = this.configurationService.getBooleanProperty("webui.strengths.cache", true);
        if (!showStrengths) {
            return -1;
        }
        if (useCache) {
            ItemCountDAO dao = (ItemCountDAO)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("itemCountDAO", ItemCountDAO.class);
            return dao.getCount(context, dso);
        }
        if (dso instanceof Collection) {
            try {
                return this.itemService.countItems(context, (Collection)dso);
            }
            catch (SQLException e) {
                log.error("Error counting number of Items in Collection {} :", (Object)dso.getID(), (Object)e);
                return -1;
            }
        }
        if (dso instanceof Community) {
            try {
                return this.itemService.countItems(context, (Community)dso);
            }
            catch (SQLException e) {
                log.error("Error counting number of Items in Community {} :", (Object)dso.getID(), (Object)e);
                return -1;
            }
        }
        return 0;
    }
}

