/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.core.HibernateProxyHelper;
import org.dspace.core.ReloadableEntity;

@Entity
@Table(name="metadatavalue")
public class MetadataValue
implements ReloadableEntity<Integer> {
    @Id
    @Column(name="metadata_value_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="metadatavalue_seq")
    @SequenceGenerator(name="metadatavalue_seq", sequenceName="metadatavalue_seq", allocationSize=1)
    private final Integer id = 0;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="metadata_field_id")
    private MetadataField metadataField = null;
    @Column(name="text_value", length=0x7FFFFFFF)
    private String value;
    @Column(name="text_lang", length=24)
    private String language;
    @Column(name="place")
    private int place = 1;
    @Column(name="authority", length=100)
    private String authority = null;
    @Column(name="confidence")
    private int confidence = -1;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="dspace_object_id")
    protected DSpaceObject dSpaceObject;

    protected MetadataValue() {
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    public DSpaceObject getDSpaceObject() {
        return this.dSpaceObject;
    }

    public void setDSpaceObject(DSpaceObject dso) {
        this.dSpaceObject = dso;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (StringUtils.equals((CharSequence)language, (CharSequence)"*")) {
            language = null;
        }
        this.language = language;
    }

    public int getPlace() {
        return this.place;
    }

    public void setPlace(int place) {
        this.place = place;
    }

    public MetadataField getMetadataField() {
        return this.metadataField;
    }

    public void setMetadataField(MetadataField metadataField) {
        this.metadataField = metadataField;
    }

    @Transient
    protected Integer getMetadataFieldId() {
        return this.getMetadataField().getID();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String value) {
        this.authority = value;
    }

    public int getConfidence() {
        return this.confidence;
    }

    public void setConfidence(int value) {
        this.confidence = value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy(obj);
        if (!this.getClass().equals(objClass)) {
            return false;
        }
        MetadataValue other = (MetadataValue)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.getID().equals(other.getID())) {
            return false;
        }
        return this.getDSpaceObject().getID().equals(other.getDSpaceObject().getID());
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this.id;
        hash = 47 * hash + this.getID();
        hash = 47 * hash + this.getDSpaceObject().getID().hashCode();
        return hash;
    }
}

