/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class CrosswalkMetadataValidator {
    protected MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private String schemaChoice;
    private String fieldChoice;
    private final Map<Triple<String, String, String>, MetadataField> validatedMetadataFields;

    public CrosswalkMetadataValidator() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.validatedMetadataFields = new HashMap<Triple<String, String, String>, MetadataField>();
        this.schemaChoice = configurationService.getProperty("oai.harvester.unknownSchema");
        if (this.schemaChoice == null) {
            this.schemaChoice = "fail";
        }
        this.fieldChoice = configurationService.getProperty("oai.harvester.unknownField");
        if (this.fieldChoice == null) {
            this.fieldChoice = "fail";
        }
    }

    public MetadataField checkMetadata(Context context, String schema, String element, String qualifier, boolean forceCreate) throws SQLException, AuthorizeException, CrosswalkException {
        if (!this.validatedBefore(schema, element, qualifier)) {
            MetadataSchema mdSchema = this.metadataSchemaService.find(context, schema);
            MetadataField mdField = null;
            if (mdSchema == null) {
                if (forceCreate && this.schemaChoice.equals("add")) {
                    try {
                        mdSchema = this.metadataSchemaService.create(context, schema, String.valueOf(Instant.now().toEpochMilli()));
                        mdSchema.setNamespace("unknown" + mdSchema.getID());
                        this.metadataSchemaService.update(context, mdSchema);
                    }
                    catch (NonUniqueMetadataException e) {
                        e.printStackTrace();
                    }
                } else if (!this.schemaChoice.equals("ignore")) {
                    throw new CrosswalkException("The '" + schema + "' schema has not been defined in this DSpace instance. ");
                }
            }
            if (mdSchema != null && (mdField = this.metadataFieldService.findByElement(context, mdSchema, element, qualifier)) == null) {
                if (forceCreate && this.fieldChoice.equals("add")) {
                    try {
                        this.metadataFieldService.create(context, mdSchema, element, qualifier, null);
                    }
                    catch (NonUniqueMetadataException e) {
                        e.printStackTrace();
                    }
                } else if (!this.fieldChoice.equals("ignore")) {
                    throw new CrosswalkException("The '" + element + "." + qualifier + "' element has not been defined in this DSpace instance. ");
                }
            }
            this.validatedMetadataFields.put((Triple<String, String, String>)this.createKey(schema, element, qualifier), mdField);
        }
        return this.validatedMetadataFields.get(this.createKey(schema, element, qualifier));
    }

    private boolean validatedBefore(String schema, String element, String qualifier) {
        return this.validatedMetadataFields.containsKey(this.createKey(schema, element, qualifier));
    }

    private ImmutableTriple<String, String, String> createKey(String schema, String element, String qualifier) {
        return new ImmutableTriple((Object)schema, (Object)element, (Object)qualifier);
    }
}

