/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import com.coverity.security.Escape;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.rmi.dgc.VMID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public final class Utils {
    private static final Logger log = LogManager.getLogger(Utils.class);
    private static final Pattern DURATION_PATTERN = Pattern.compile("(\\d+)([smhdwy])");
    private static final long MS_IN_SECOND = 1000L;
    private static final long MS_IN_MINUTE = 60000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_DAY = 86400000L;
    private static final long MS_IN_WEEK = 604800000L;
    private static final long MS_IN_YEAR = 31536000000L;
    private static int counter = 0;
    private static final Random random = new Random();
    private static final VMID vmid = new VMID();
    private static final DateTimeFormatter[] parseFmt = new DateTimeFormatter[]{DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ofPattern("yyyy'-'MM'-'dd'T'HH':'mm':'ss.SSSz"), DateTimeFormatter.ofPattern("yyyy'-'MM'-'dd'T'HH':'mm':'ssz"), DateTimeFormatter.ofPattern("yyyy'-'MM'-'dd'T'HH':'mm':'ss.SSS"), DateTimeFormatter.ofPattern("yyyy'-'MM'-'dd'T'HH':'mm':'ss"), DateTimeFormatter.ofPattern("yyyy'-'MM'-'dd")};
    private static final DateTimeFormatter outFmt = DateTimeFormatter.ISO_INSTANT;

    private Utils() {
    }

    public static String getMD5(String data) {
        return Utils.getMD5(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String getMD5(byte[] data) {
        return Utils.toHex(Utils.getMD5Bytes(data));
    }

    public static byte[] getMD5Bytes(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String toHex(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (byte datum : data) {
            int low = datum & 0xF;
            int high = datum & 0xF0;
            result.append(Integer.toHexString(high).charAt(0));
            result.append(Integer.toHexString(low));
        }
        return result.toString();
    }

    public static String generateKey() {
        return new BigInteger(Utils.generateBytesKey()).abs().toString();
    }

    public static String generateHexKey() {
        return Utils.toHex(Utils.generateBytesKey());
    }

    public static synchronized byte[] generateBytesKey() {
        byte[] junk = new byte[16];
        random.nextBytes(junk);
        String input = String.valueOf(vmid) + Instant.now().toEpochMilli() + Arrays.toString(junk) + counter++;
        return Utils.getMD5Bytes(input.getBytes(StandardCharsets.UTF_8));
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int count;
        int BUFFER_SIZE = 4096;
        byte[] buffer = new byte[4096];
        while (-1 != (count = input.read(buffer, 0, 4096))) {
            output.write(buffer, 0, count);
        }
    }

    public static void bufferedCopy(InputStream source, OutputStream destination) throws IOException {
        BufferedInputStream input = new BufferedInputStream(source);
        BufferedOutputStream output = new BufferedOutputStream(destination);
        Utils.copy(input, output);
        output.flush();
    }

    public static String addEntities(String value) {
        return Escape.html((String)value);
    }

    public static long parseDuration(String duration) throws ParseException {
        long multiplier;
        Matcher m = DURATION_PATTERN.matcher(duration.trim());
        if (!m.matches()) {
            throw new ParseException("'" + duration + "' is not a valid duration definition", 0);
        }
        String units = m.group(2);
        if ("s".equals(units)) {
            multiplier = 1000L;
        } else if ("m".equals(units)) {
            multiplier = 60000L;
        } else if ("h".equals(units)) {
            multiplier = 3600000L;
        } else if ("d".equals(units)) {
            multiplier = 86400000L;
        } else if ("w".equals(units)) {
            multiplier = 604800000L;
        } else if ("y".equals(units)) {
            multiplier = 31536000000L;
        } else {
            throw new ParseException(units + " is not a valid time unit (must be 'y', 'w', 'd', 'h', 'm' or 's')", duration.indexOf(units));
        }
        long qint = Long.parseLong(m.group(1));
        return qint * multiplier;
    }

    public static Instant parseISO8601Date(String s) {
        DateTimeParseException lastError = null;
        for (DateTimeFormatter formatter : parseFmt) {
            try {
                return formatter.parse((CharSequence)s, Instant::from);
            }
            catch (DateTimeParseException e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            log.error("Error parsing date:", lastError);
        }
        return null;
    }

    public static String formatISO8601Date(TemporalAccessor date) {
        return outFmt.format(date);
    }

    public static <E> Collection<E> emptyIfNull(Collection<E> collection) {
        return collection == null ? Collections.emptyList() : collection;
    }

    public static String[] tokenize(String metadata) {
        String separator = metadata.contains("_") ? "_" : ".";
        StringTokenizer dcf = new StringTokenizer(metadata, separator);
        String[] tokens = new String[]{"", "", ""};
        int i = 0;
        while (dcf.hasMoreTokens()) {
            tokens[i] = dcf.nextToken().trim();
            ++i;
        }
        return tokens;
    }

    public static String standardize(String schema, String element, String qualifier, String separator) {
        if (StringUtils.isBlank((CharSequence)element)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)qualifier)) {
            return schema + separator + element;
        }
        return schema + separator + element + separator + qualifier;
    }

    public static String getBaseUrl(String urlString) {
        try {
            URL url = new URL(urlString);
            String baseUrl = url.getProtocol() + "://" + url.getHost();
            if (url.getPort() != -1) {
                baseUrl = baseUrl + ":" + url.getPort();
            }
            return baseUrl;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getHostName(String uriString) {
        try {
            URL url = new URL(uriString);
            String hostname = url.getHost();
            if (hostname != null) {
                return hostname.startsWith("www.") ? hostname.substring(4) : hostname;
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String[] getIPAddresses(String uriString) {
        String[] ipAddresses = null;
        String hostname = Utils.getHostName(uriString);
        if (StringUtils.isNotEmpty((CharSequence)hostname)) {
            try {
                InetAddress[] inetAddresses = InetAddress.getAllByName(hostname);
                ipAddresses = (String[])Arrays.stream(inetAddresses).filter(address -> address instanceof Inet4Address).map(address -> ((Inet4Address)address).getHostAddress()).toArray(String[]::new);
            }
            catch (UnknownHostException ex) {
                return null;
            }
        }
        return ipAddresses;
    }

    public static String interpolateConfigsInString(String string) {
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        return StringSubstitutor.replace((Object)string, (Properties)config.getProperties());
    }

    public static Instant getMaxTimestamp() {
        return LocalDateTime.of(294276, 12, 31, 23, 59, 59).toInstant(ZoneOffset.UTC);
    }

    public static Instant getMinTimestamp() {
        return LocalDateTime.of(-4713, 11, 12, 0, 0, 0).toInstant(ZoneOffset.UTC);
    }
}

