/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;

public class DiscoverResultIterator<T extends ReloadableEntity, PK extends Serializable>
implements Iterator<T> {
    private final SearchService searchService;
    private final Context context;
    private final IndexableObject<?, ?> scopeObject;
    private final DiscoverQuery discoverQuery;
    private final boolean uncacheEntitites;
    private final int maxResults;
    private int iteratorCounter;
    private DiscoverResult currentDiscoverResult;
    private Iterator<IndexableObject> currentSlotIterator;

    public DiscoverResultIterator(Context context, DiscoverQuery discoverQuery) {
        this(context, null, discoverQuery, true, -1);
    }

    public DiscoverResultIterator(Context context, DiscoverQuery discoverQuery, boolean uncacheEntities) {
        this(context, null, discoverQuery, uncacheEntities, -1);
    }

    public DiscoverResultIterator(Context context, IndexableObject<?, ?> scopeObject, DiscoverQuery discoverQuery) {
        this(context, scopeObject, discoverQuery, true, -1);
    }

    public DiscoverResultIterator(Context context, IndexableObject<?, ?> scopeObject, DiscoverQuery discoverQuery, boolean uncacheEntities, int maxResults) {
        this.context = context;
        this.scopeObject = scopeObject;
        this.discoverQuery = discoverQuery;
        this.iteratorCounter = discoverQuery.getStart();
        this.searchService = SearchUtils.getSearchService();
        this.uncacheEntitites = uncacheEntities;
        this.maxResults = maxResults;
        this.updateCurrentSlotIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.maxResults > 0 && this.iteratorCounter >= this.maxResults) {
            return false;
        }
        if (this.currentSlotIterator.hasNext()) {
            return true;
        }
        this.discoverQuery.setStart(this.iteratorCounter);
        if (this.uncacheEntitites) {
            this.uncacheEntitites();
        }
        this.updateCurrentSlotIterator();
        return this.currentSlotIterator.hasNext();
    }

    @Override
    public T next() {
        return this.getNextIndexableObject().getIndexedObject();
    }

    public long getTotalSearchResults() {
        if (this.currentSlotIterator == null) {
            this.updateCurrentSlotIterator();
        }
        return this.currentDiscoverResult.getTotalSearchResults();
    }

    protected IndexableObject getNextIndexableObject() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.iteratorCounter;
        return this.currentSlotIterator.next();
    }

    private void uncacheEntitites() {
        List<IndexableObject> indexableObjects = this.currentDiscoverResult.getIndexableObjects();
        for (IndexableObject indexableObj : indexableObjects) {
            try {
                this.context.uncacheEntity(indexableObj.getIndexedObject());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateCurrentSlotIterator() {
        this.currentDiscoverResult = this.search();
        this.currentSlotIterator = this.currentDiscoverResult.getIndexableObjects().iterator();
    }

    private DiscoverResult search() {
        try {
            if (this.scopeObject == null) {
                return this.searchService.search(this.context, this.discoverQuery);
            }
            return this.searchService.search(this.context, this.scopeObject, this.discoverQuery);
        }
        catch (SearchServiceException e) {
            throw new RuntimeException(e);
        }
    }
}

