/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.SubscriptionParameter;
import org.dspace.eperson.dao.SubscriptionDAO;
import org.dspace.eperson.service.SubscribeService;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscribeServiceImpl
implements SubscribeService {
    private Logger log = LogManager.getLogger(SubscribeServiceImpl.class);
    @Autowired(required=true)
    private SubscriptionDAO subscriptionDAO;
    @Autowired(required=true)
    private AuthorizeService authorizeService;
    @Autowired(required=true)
    private CollectionService collectionService;

    @Override
    public List<Subscription> findAll(Context context, String resourceType, Integer limit, Integer offset) throws Exception {
        if (StringUtils.isBlank((CharSequence)resourceType)) {
            return this.subscriptionDAO.findAllOrderedByDSO(context, limit, offset);
        }
        if (resourceType.equals(Collection.class.getSimpleName()) || resourceType.equals(Community.class.getSimpleName())) {
            return this.subscriptionDAO.findAllOrderedByIDAndResourceType(context, resourceType, limit, offset);
        }
        this.log.error("Resource type must be Collection or Community");
        throw new Exception("Resource type must be Collection or Community");
    }

    @Override
    public Subscription subscribe(Context context, EPerson eperson, DSpaceObject dSpaceObject, List<SubscriptionParameter> subscriptionParameterList, String type) throws SQLException, AuthorizeException {
        if (this.authorizeService.isAdmin(context) || context.getCurrentUser() != null && context.getCurrentUser().getID().equals(eperson.getID())) {
            Subscription newSubscription = this.subscriptionDAO.create(context, new Subscription());
            subscriptionParameterList.forEach(subscriptionParameter -> newSubscription.addParameter((SubscriptionParameter)subscriptionParameter));
            newSubscription.setEPerson(eperson);
            newSubscription.setDSpaceObject(dSpaceObject);
            newSubscription.setSubscriptionType(type);
            return newSubscription;
        }
        throw new AuthorizeException("Only admin or e-person themselves can subscribe");
    }

    @Override
    public void unsubscribe(Context context, EPerson eperson, DSpaceObject dSpaceObject) throws SQLException, AuthorizeException {
        if (this.authorizeService.isAdmin(context) || context.getCurrentUser() != null && context.getCurrentUser().getID().equals(eperson.getID())) {
            if (dSpaceObject == null) {
                this.subscriptionDAO.deleteByEPerson(context, eperson);
            } else {
                this.subscriptionDAO.deleteByDSOAndEPerson(context, dSpaceObject, eperson);
                this.log.info(LogHelper.getHeader(context, "unsubscribe", "eperson_id=" + eperson.getID() + ",collection_id=" + dSpaceObject.getID()));
            }
        } else {
            throw new AuthorizeException("Only admin or e-person themselves can unsubscribe");
        }
    }

    @Override
    public List<Subscription> findSubscriptionsByEPerson(Context context, EPerson eperson, Integer limit, Integer offset) throws SQLException {
        return this.subscriptionDAO.findByEPerson(context, eperson, limit, offset);
    }

    @Override
    public List<Subscription> findSubscriptionsByEPersonAndDso(Context context, EPerson eperson, DSpaceObject dSpaceObject, Integer limit, Integer offset) throws SQLException {
        return this.subscriptionDAO.findByEPersonAndDso(context, eperson, dSpaceObject, limit, offset);
    }

    @Override
    public List<Collection> findAvailableSubscriptions(Context context) throws SQLException {
        return this.findAvailableSubscriptions(context, null);
    }

    @Override
    public List<Collection> findAvailableSubscriptions(Context context, EPerson eperson) throws SQLException {
        if (Objects.nonNull(eperson)) {
            context.setCurrentUser(eperson);
        }
        return this.collectionService.findAuthorized(context, null, 3);
    }

    @Override
    public boolean isSubscribed(Context context, EPerson eperson, DSpaceObject dSpaceObject) throws SQLException {
        List<Subscription> subscriptions = this.subscriptionDAO.findByEPersonAndDso(context, eperson, dSpaceObject, -1, -1);
        return subscriptions != null && !subscriptions.isEmpty();
    }

    @Override
    public void deleteByDspaceObject(Context context, DSpaceObject dSpaceObject) throws SQLException {
        this.subscriptionDAO.deleteByDspaceObject(context, dSpaceObject);
    }

    @Override
    public void deleteByEPerson(Context context, EPerson ePerson) throws SQLException {
        this.subscriptionDAO.deleteByEPerson(context, ePerson);
    }

    @Override
    public Subscription findById(Context context, int id) throws SQLException {
        return (Subscription)this.subscriptionDAO.findByID(context, Subscription.class, id);
    }

    @Override
    public Subscription updateSubscription(Context context, Integer id, String subscriptionType, List<SubscriptionParameter> subscriptionParameterList) throws SQLException {
        Subscription subscriptionDB = (Subscription)this.subscriptionDAO.findByID(context, Subscription.class, id);
        subscriptionDB.removeParameterList();
        subscriptionDB.setSubscriptionType(subscriptionType);
        subscriptionParameterList.forEach(x -> subscriptionDB.addParameter((SubscriptionParameter)x));
        this.subscriptionDAO.save(context, subscriptionDB);
        return subscriptionDB;
    }

    @Override
    public Subscription addSubscriptionParameter(Context context, Integer id, SubscriptionParameter subscriptionParam) throws SQLException {
        Subscription subscriptionDB = (Subscription)this.subscriptionDAO.findByID(context, Subscription.class, id);
        subscriptionDB.addParameter(subscriptionParam);
        this.subscriptionDAO.save(context, subscriptionDB);
        return subscriptionDB;
    }

    @Override
    public Subscription removeSubscriptionParameter(Context context, Integer id, SubscriptionParameter subscriptionParam) throws SQLException {
        Subscription subscriptionDB = (Subscription)this.subscriptionDAO.findByID(context, Subscription.class, id);
        subscriptionDB.removeParameter(subscriptionParam);
        this.subscriptionDAO.save(context, subscriptionDB);
        return subscriptionDB;
    }

    @Override
    public void deleteSubscription(Context context, Subscription subscription) throws SQLException {
        this.subscriptionDAO.delete(context, subscription);
    }

    @Override
    public List<Subscription> findAllSubscriptionsBySubscriptionTypeAndFrequency(Context context, String subscriptionType, String frequencyValue) throws SQLException {
        return this.subscriptionDAO.findAllSubscriptionsBySubscriptionTypeAndFrequency(context, subscriptionType, frequencyValue);
    }

    @Override
    public Long countAll(Context context) throws SQLException {
        return this.subscriptionDAO.countAll(context);
    }

    @Override
    public Long countSubscriptionsByEPerson(Context context, EPerson ePerson) throws SQLException {
        return this.subscriptionDAO.countAllByEPerson(context, ePerson);
    }

    @Override
    public Long countByEPersonAndDSO(Context context, EPerson ePerson, DSpaceObject dSpaceObject) throws SQLException {
        return this.subscriptionDAO.countAllByEPersonAndDso(context, ePerson, dSpaceObject);
    }
}

