/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson.dto;

import org.dspace.eperson.RegistrationTypeEnum;

public class RegistrationDataChanges {
    private static final String EMAIL_PATTERN = "^[a-zA-Z0-9.!#$%&'*+\\\\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$";
    private final String email;
    private final RegistrationTypeEnum registrationType;

    public RegistrationDataChanges(String email, RegistrationTypeEnum type) {
        if (email == null || email.trim().isBlank()) {
            throw new IllegalArgumentException("Cannot update with an empty email address");
        }
        if (type == null) {
            throw new IllegalArgumentException("Cannot update with a null registration type");
        }
        this.email = email;
        if (!this.isValidEmail()) {
            throw new IllegalArgumentException("Invalid email address provided!");
        }
        this.registrationType = type;
    }

    public boolean isValidEmail() {
        return this.email.matches(EMAIL_PATTERN);
    }

    public String getEmail() {
        return this.email;
    }

    public RegistrationTypeEnum getRegistrationType() {
        return this.registrationType;
    }
}

