/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.external.OrcidRestConnector;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.AbstractExternalDataProvider;
import org.dspace.external.provider.orcid.xml.XMLtoBio;
import org.dspace.orcid.model.factory.OrcidFactoryUtils;
import org.orcid.jaxb.model.v3.release.common.OrcidIdentifier;
import org.orcid.jaxb.model.v3.release.record.Email;
import org.orcid.jaxb.model.v3.release.record.Person;
import org.orcid.jaxb.model.v3.release.search.Result;
import org.springframework.beans.factory.annotation.Autowired;

public class OrcidV3AuthorDataProvider
extends AbstractExternalDataProvider {
    private static final Logger log = LogManager.getLogger(OrcidV3AuthorDataProvider.class);
    private OrcidRestConnector orcidRestConnector;
    private String OAUTHUrl;
    private String clientId;
    private String clientSecret;
    private String accessToken;
    private String sourceIdentifier;
    private String orcidUrl;
    private XMLtoBio converter = new XMLtoBio();
    private int maxClientRetries = 3;
    public static final String ORCID_ID_SYNTAX = "\\d{4}-\\d{4}-\\d{4}-(\\d{3}X|\\d{4})";
    private static final int MAX_INDEX = 10000;

    @Override
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void init() throws IOException {
        this.initializeAccessToken();
    }

    public void initializeAccessToken() {
        if (this.maxClientRetries <= 0 || StringUtils.isNotBlank((CharSequence)this.accessToken)) {
            return;
        }
        try {
            this.accessToken = OrcidFactoryUtils.retrieveAccessToken(this.clientId, this.clientSecret, this.OAUTHUrl).orElse(null);
        }
        catch (IOException e) {
            log.error("Error retrieving ORCID access token, {} retries left", (Object)(--this.maxClientRetries));
        }
    }

    @Override
    public Optional<ExternalDataObject> getExternalDataObject(String id) {
        this.initializeAccessToken();
        Person person = this.getBio(id);
        ExternalDataObject externalDataObject = this.convertToExternalDataObject(person);
        return Optional.of(externalDataObject);
    }

    protected ExternalDataObject convertToExternalDataObject(Person person) {
        this.initializeAccessToken();
        ExternalDataObject externalDataObject = new ExternalDataObject(this.sourceIdentifier);
        if (person.getName() != null) {
            String lastName = "";
            String firstName = "";
            if (person.getName().getFamilyName() != null) {
                lastName = person.getName().getFamilyName().getContent();
                externalDataObject.addMetadata(new MetadataValueDTO("person", "familyName", null, null, lastName));
            }
            if (person.getName().getGivenNames() != null) {
                firstName = person.getName().getGivenNames().getContent();
                externalDataObject.addMetadata(new MetadataValueDTO("person", "givenName", null, null, firstName));
            }
            if (person.getEmails().getEmails() != null && !person.getEmails().getEmails().isEmpty()) {
                Email email = (Email)person.getEmails().getEmails().get(0);
                if (person.getEmails().getEmails().size() > 1) {
                    email = person.getEmails().getEmails().stream().filter(Email::isPrimary).findFirst().orElse(email);
                }
                externalDataObject.addMetadata(new MetadataValueDTO("person", "email", null, null, email.getEmail()));
            }
            externalDataObject.setId(person.getName().getPath());
            externalDataObject.addMetadata(new MetadataValueDTO("person", "identifier", "orcid", null, person.getName().getPath()));
            externalDataObject.addMetadata(new MetadataValueDTO("dc", "identifier", "uri", null, this.orcidUrl + "/" + person.getName().getPath()));
            if (!StringUtils.isBlank((CharSequence)lastName) && !StringUtils.isBlank((CharSequence)firstName)) {
                externalDataObject.setDisplayValue(lastName + ", " + firstName);
                externalDataObject.setValue(lastName + ", " + firstName);
            } else if (StringUtils.isBlank((CharSequence)firstName)) {
                externalDataObject.setDisplayValue(lastName);
                externalDataObject.setValue(lastName);
            } else if (StringUtils.isBlank((CharSequence)lastName)) {
                externalDataObject.setDisplayValue(firstName);
                externalDataObject.setValue(firstName);
            }
        } else if (person.getPath() != null) {
            externalDataObject.setId(StringUtils.substringBetween((String)person.getPath(), (String)"/", (String)"/person"));
        }
        return externalDataObject;
    }

    public Person getBio(String id) {
        log.debug("getBio called with ID=" + id);
        if (!this.isValid(id)) {
            return null;
        }
        if (this.orcidRestConnector == null) {
            log.error("ORCID REST connector is null, returning null ORCID Person Bio");
            return null;
        }
        this.initializeAccessToken();
        InputStream bioDocument = this.orcidRestConnector.get(id + (id.endsWith("/person") ? "" : "/person"), this.accessToken);
        return this.converter.convertSinglePerson(bioDocument);
    }

    private boolean isValid(String text) {
        return StringUtils.isNotBlank((CharSequence)text) && text.matches(ORCID_ID_SYNTAX);
    }

    @Override
    public List<ExternalDataObject> searchExternalDataObjects(String query, int start, int limit) {
        this.initializeAccessToken();
        if (limit > 100) {
            throw new IllegalArgumentException("The maximum number of results to retrieve cannot exceed 100.");
        }
        if (start > 10000) {
            throw new IllegalArgumentException("The starting number of results to retrieve cannot exceed 10000.");
        }
        if (this.orcidRestConnector == null) {
            log.error("ORCID REST connector is not initialized, returning empty list");
            return Collections.emptyList();
        }
        String searchPath = "search?q=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&start=" + start + "&rows=" + limit;
        log.debug("queryBio searchPath=" + searchPath + " accessToken=" + this.accessToken);
        InputStream bioDocument = this.orcidRestConnector.get(searchPath, this.accessToken);
        Object results = this.converter.convert(bioDocument);
        LinkedList<Person> bios = new LinkedList<Person>();
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            Result result = (Result)iterator.next();
            OrcidIdentifier orcidIdentifier = result.getOrcidIdentifier();
            if (orcidIdentifier == null) continue;
            log.debug("Found OrcidId=" + orcidIdentifier.getPath());
            String orcid = orcidIdentifier.getPath();
            Person bio2 = this.getBio(orcid);
            if (bio2 == null) continue;
            bios.add(bio2);
        }
        return bios.stream().map(bio -> this.convertToExternalDataObject((Person)bio)).collect(Collectors.toList());
    }

    @Override
    public boolean supports(String source) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.sourceIdentifier, (CharSequence)source);
    }

    @Override
    public int getNumberOfResults(String query) {
        if (this.orcidRestConnector == null) {
            log.error("ORCID REST connector is null, returning 0");
            return 0;
        }
        this.initializeAccessToken();
        String searchPath = "search?q=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&start=0&rows=0";
        log.debug("queryBio searchPath=" + searchPath + " accessToken=" + this.accessToken);
        InputStream bioDocument = this.orcidRestConnector.get(searchPath, this.accessToken);
        return Math.min(this.converter.getNumberOfResultsFromXml(bioDocument), 10000);
    }

    @Autowired(required=true)
    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public String getOrcidUrl() {
        return this.orcidUrl;
    }

    @Autowired(required=true)
    public void setOrcidUrl(String orcidUrl) {
        this.orcidUrl = orcidUrl;
    }

    public void setOAUTHUrl(String OAUTHUrl) {
        this.OAUTHUrl = OAUTHUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OrcidRestConnector getOrcidRestConnector() {
        return this.orcidRestConnector;
    }

    public void setOrcidRestConnector(OrcidRestConnector orcidRestConnector) {
        this.orcidRestConnector = orcidRestConnector;
    }
}

