/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.arxiv.service;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.util.XMLUtils;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.components.QuerySource;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class ArXivImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<Element>
implements QuerySource {
    private WebTarget webTarget;
    private String baseAddress;

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query, count, start));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByIdCallable(id));
        return records == null || records.isEmpty() ? null : records.get(0);
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByIdCallable(query));
        return records == null || records.isEmpty() ? null : records.get(0);
    }

    @Override
    public void init() throws Exception {
        Client client = ClientBuilder.newClient();
        this.webTarget = client.target(this.baseAddress);
    }

    @Override
    public String getImportSource() {
        return "arxiv";
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for ArXiv");
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        return this.retry(new FindMatchingRecordCallable(query));
    }

    private List<Element> splitToRecords(String recordsSrc) {
        try {
            SAXBuilder saxBuilder = XMLUtils.getSAXBuilder();
            Document document = saxBuilder.build((Reader)new StringReader(recordsSrc));
            Element root = document.getRootElement();
            List<Namespace> namespaces = Arrays.asList(Namespace.getNamespace((String)"ns", (String)"http://www.w3.org/2005/Atom"));
            XPathExpression xpath = XPathFactory.instance().compile("ns:entry", Filters.element(), null, namespaces);
            List recordsList = xpath.evaluate((Object)root);
            return recordsList;
        }
        catch (IOException | JDOMException e) {
            return null;
        }
    }

    public String getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress;
    }

    private class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByQueryCallable(String queryString, Integer maxResult, Integer start) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
            this.query.addParameter("start", start);
            this.query.addParameter("count", maxResult);
        }

        private SearchByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            Invocation.Builder invocationBuilder;
            Response response;
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            String queryString = this.query.getParameterAsClass("query", String.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            Integer maxResult = this.query.getParameterAsClass("count", Integer.class);
            WebTarget local = ArXivImportMetadataSourceServiceImpl.this.webTarget.queryParam("search_query", new Object[]{queryString});
            if (maxResult != null) {
                local = local.queryParam("max_results", new Object[]{String.valueOf(maxResult)});
            }
            if (start != null) {
                local = local.queryParam("start", new Object[]{String.valueOf(start)});
            }
            if ((response = (invocationBuilder = local.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE})).get()).getStatus() == 200) {
                String responseString = (String)response.readEntity(String.class);
                List<Element> elements = ArXivImportMetadataSourceServiceImpl.this.splitToRecords(responseString);
                for (Element record : elements) {
                    results.add(ArXivImportMetadataSourceServiceImpl.this.transformSourceRecords(record));
                }
                return results;
            }
            return null;
        }
    }

    private class CountByQueryCallable
    implements Callable<Integer> {
        private Query query;

        private CountByQueryCallable(String queryString) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
        }

        private CountByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public Integer call() throws Exception {
            Invocation.Builder invocationBuilder;
            Response response;
            String queryString = this.query.getParameterAsClass("query", String.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            Integer maxResult = this.query.getParameterAsClass("count", Integer.class);
            WebTarget local = ArXivImportMetadataSourceServiceImpl.this.webTarget.queryParam("search_query", new Object[]{queryString});
            if (maxResult != null) {
                local = local.queryParam("max_results", new Object[]{String.valueOf(maxResult)});
            }
            if (start != null) {
                local = local.queryParam("start", new Object[]{String.valueOf(start)});
            }
            if ((response = (invocationBuilder = local.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE})).get()).getStatus() == 200) {
                String responseString = (String)response.readEntity(String.class);
                SAXBuilder saxBuilder = XMLUtils.getSAXBuilder();
                Document document = saxBuilder.build((Reader)new StringReader(responseString));
                Element root = document.getRootElement();
                List<Namespace> namespaces = Arrays.asList(Namespace.getNamespace((String)"opensearch", (String)"http://a9.com/-/spec/opensearch/1.1/"));
                XPathExpression xpath = XPathFactory.instance().compile("opensearch:totalResults", Filters.element(), null, namespaces);
                Element count = (Element)xpath.evaluateFirst((Object)root);
                try {
                    return Integer.parseInt(count.getText());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }
    }

    private class SearchByIdCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByIdCallable(Query query) {
            this.query = query;
        }

        private SearchByIdCallable(String id) {
            this.query = new Query();
            this.query.addParameter("id", id);
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            String arxivid = this.query.getParameterAsClass("id", String.class);
            if (StringUtils.isNotBlank((CharSequence)arxivid)) {
                if ((arxivid = arxivid.trim()).startsWith("http://arxiv.org/abs/")) {
                    arxivid = arxivid.substring("http://arxiv.org/abs/".length());
                } else if (arxivid.toLowerCase().startsWith("arxiv:")) {
                    arxivid = arxivid.substring("arxiv:".length());
                }
            }
            WebTarget local = ArXivImportMetadataSourceServiceImpl.this.webTarget.queryParam("id_list", new Object[]{arxivid});
            Invocation.Builder invocationBuilder = local.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE});
            Response response = invocationBuilder.get();
            if (response.getStatus() == 200) {
                String responseString = (String)response.readEntity(String.class);
                List<Element> elements = ArXivImportMetadataSourceServiceImpl.this.splitToRecords(responseString);
                for (Element record : elements) {
                    results.add(ArXivImportMetadataSourceServiceImpl.this.transformSourceRecords(record));
                }
                return results;
            }
            return null;
        }
    }

    private class FindMatchingRecordCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private FindMatchingRecordCallable(Query q) {
            this.query = q;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            String queryString = this.getQuery(this.query);
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            WebTarget local = ArXivImportMetadataSourceServiceImpl.this.webTarget.queryParam("search_query", new Object[]{queryString});
            Invocation.Builder invocationBuilder = local.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE});
            Response response = invocationBuilder.get();
            if (response.getStatus() == 200) {
                String responseString = (String)response.readEntity(String.class);
                List<Element> elements = ArXivImportMetadataSourceServiceImpl.this.splitToRecords(responseString);
                for (Element record : elements) {
                    results.add(ArXivImportMetadataSourceServiceImpl.this.transformSourceRecords(record));
                }
                return results;
            }
            return null;
        }

        private String getQuery(Query query) {
            String title = query.getParameterAsClass("title", String.class);
            String author = query.getParameterAsClass("author", String.class);
            StringBuffer queryString = new StringBuffer();
            if (StringUtils.isNotBlank((CharSequence)title)) {
                queryString.append("ti:\"").append(title).append("\"");
            }
            if (StringUtils.isNotBlank((CharSequence)author)) {
                if (queryString.length() > 0) {
                    queryString.append(" AND ");
                }
                queryString.append("au:\"").append(author).append("\"");
            }
            return queryString.toString();
        }
    }
}

