/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.bibtex.service;

import jakarta.annotation.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dspace.importer.external.exception.FileSourceException;
import org.dspace.importer.external.service.components.AbstractPlainMetadataSource;
import org.dspace.importer.external.service.components.dto.PlainMetadataKeyValueItem;
import org.dspace.importer.external.service.components.dto.PlainMetadataSourceDto;
import org.jbibtex.BibTeXDatabase;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.BibTeXParser;
import org.jbibtex.Key;
import org.jbibtex.LaTeXParser;
import org.jbibtex.LaTeXPrinter;
import org.jbibtex.ParseException;
import org.jbibtex.Value;

public class BibtexImportMetadataSourceServiceImpl
extends AbstractPlainMetadataSource {
    @Override
    public String getImportSource() {
        return "BibTeXMetadataSource";
    }

    @Override
    protected List<PlainMetadataSourceDto> readData(InputStream inputStream) throws FileSourceException {
        BibTeXDatabase database;
        ArrayList<PlainMetadataSourceDto> list = new ArrayList<PlainMetadataSourceDto>();
        try {
            database = this.parseBibTex(inputStream);
        }
        catch (IOException | ParseException e) {
            throw new FileSourceException("Unable to parse file with BibTeX parser");
        }
        if (database == null || database.getEntries() == null) {
            throw new FileSourceException("File results in an empty list of metadata");
        }
        if (database.getEntries() != null) {
            for (Map.Entry entry : database.getEntries().entrySet()) {
                PlainMetadataSourceDto item = new PlainMetadataSourceDto();
                ArrayList<PlainMetadataKeyValueItem> keyValues = new ArrayList<PlainMetadataKeyValueItem>();
                item.setMetadata(keyValues);
                PlainMetadataKeyValueItem keyValueItem = new PlainMetadataKeyValueItem();
                keyValueItem.setKey(((BibTeXEntry)entry.getValue()).getType().getValue());
                keyValueItem.setValue(((Key)entry.getKey()).getValue());
                keyValues.add(keyValueItem);
                PlainMetadataKeyValueItem typeItem = new PlainMetadataKeyValueItem();
                typeItem.setKey("type");
                typeItem.setValue(((BibTeXEntry)entry.getValue()).getType().getValue());
                keyValues.add(typeItem);
                if (((BibTeXEntry)entry.getValue()).getFields() != null) {
                    for (Map.Entry subentry : ((BibTeXEntry)entry.getValue()).getFields().entrySet()) {
                        PlainMetadataKeyValueItem innerItem = new PlainMetadataKeyValueItem();
                        innerItem.setKey(((Key)subentry.getKey()).getValue().toLowerCase());
                        String latexString = ((Value)subentry.getValue()).toUserString();
                        try {
                            LaTeXParser laTeXParser = new LaTeXParser();
                            List latexObjects = laTeXParser.parse(latexString);
                            LaTeXPrinter laTeXPrinter = new LaTeXPrinter();
                            String plainTextString = laTeXPrinter.print(latexObjects);
                            innerItem.setValue(plainTextString.replaceAll("\n", " "));
                        }
                        catch (ParseException e) {
                            innerItem.setValue(latexString);
                        }
                        keyValues.add(innerItem);
                    }
                }
                list.add(item);
            }
        }
        return list;
    }

    private BibTeXDatabase parseBibTex(InputStream inputStream) throws IOException, ParseException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        BibTeXParser bibtexParser = new BibTeXParser();
        return bibtexParser.parse((Reader)reader);
    }

    @Override
    @Resource(name="bibtexMetadataFieldMap")
    public void setMetadataFieldMap(Map metadataFieldMap) {
        super.setMetadataFieldMap(metadataFieldMap);
    }
}

