/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.crossref;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.contributor.JsonPathMetadataProcessor;

public class CrossRefAuthorMetadataProcessor
implements JsonPathMetadataProcessor {
    private static final Logger log = LogManager.getLogger();
    private String pathToArray;

    @Override
    public Collection<String> processMetadata(String json) {
        JsonNode rootNode = this.convertStringJsonToJsonNode(json);
        Iterator authors = rootNode.at(this.pathToArray).iterator();
        ArrayList<String> values = new ArrayList<String>();
        while (authors.hasNext()) {
            JsonNode author = (JsonNode)authors.next();
            String givenName = author.at("/given").textValue();
            String familyName = author.at("/family").textValue();
            if (!StringUtils.isNotBlank((CharSequence)givenName) || !StringUtils.isNotBlank((CharSequence)familyName)) continue;
            values.add(familyName.trim() + ", " + givenName.trim());
        }
        return values;
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
        }
        return body;
    }

    public void setPathToArray(String pathToArray) {
        this.pathToArray = pathToArray;
    }
}

