/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;

public class ArrayJsonPathMetadataContributor
implements MetadataContributor<String> {
    private static final Logger log = LogManager.getLogger();
    private MetadataContributor<String> contributor;
    private String pathToArray;

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<String, MetadataContributor<String>> rt) {
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(String fullJson) {
        ArrayList<MetadatumDTO> values = new ArrayList<MetadatumDTO>();
        JsonNode jsonNode = this.convertStringJsonToJsonNode(fullJson);
        JsonNode node = jsonNode.at(this.pathToArray);
        if (node.isArray()) {
            for (JsonNode value : node) {
                values.addAll(this.contributor.contributeMetadata(value.toString()));
            }
        }
        return values;
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
        }
        return body;
    }

    public void setContributor(MetadataContributor<String> contributor) {
        this.contributor = contributor;
    }

    public void setPathToArray(String pathToArray) {
        this.pathToArray = pathToArray;
    }
}

