/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.openalex.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.openalex.service.OpenAlexImportMetadataSourceService;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.DoiCheck;
import org.springframework.beans.factory.annotation.Autowired;

public class OpenAlexImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<String>
implements OpenAlexImportMetadataSourceService {
    private static final Logger log = LogManager.getLogger();
    private static final String URL_FILTER_AUTHORSHIPS_AUTHOR_ID = "?filter=authorships.author.id:";
    private static final String PARAM_FILTER_AUTHORSHIPS_AUTHOR_ID = "authorships.author.id:";
    private static final String URL_FILTER_DOI = "?filter=doi:";
    private static final String PARAM_FILTER_DOI = "doi:";
    private final int timeout = 1000;
    private String url;
    @Autowired
    private LiveImportClient liveImportClient;

    @Override
    public String getImportSource() {
        return "openalex";
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        if (id == null) {
            throw new MetadataSourceException("ID cannot be null");
        }
        List<ImportRecord> records = this.retry(new SearchByIdCallable(id));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        if (query == null) {
            throw new MetadataSourceException("Query cannot be null");
        }
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        if (query == null) {
            throw new MetadataSourceException("Query cannot be null");
        }
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        if (query == null) {
            throw new MetadataSourceException("Query cannot be null");
        }
        return this.retry(new SearchByQueryCallable(query, start, count));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for OpenAlex");
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        if (query == null) {
            throw new MetadataSourceException("Query cannot be null");
        }
        List<ImportRecord> records = this.retry(new SearchByIdCallable(query));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for OpenAlex");
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for OpenAlex");
    }

    @Override
    public void init() throws Exception {
        if (this.liveImportClient == null) {
            throw new IllegalStateException("LiveImportClient not properly initialized");
        }
        if (StringUtils.isBlank((CharSequence)this.url)) {
            throw new IllegalStateException("URL not properly configured");
        }
    }

    private Integer count(String query) throws MetadataSourceException {
        if (query == null) {
            throw new MetadataSourceException("Query cannot be null");
        }
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        HashMap<String, Object> uriParams = new HashMap<String, Object>();
        params.put("uriParameters", uriParams);
        String queryUrl = this.url;
        try {
            if (queryUrl.contains(URL_FILTER_AUTHORSHIPS_AUTHOR_ID)) {
                queryUrl = queryUrl.replace(URL_FILTER_AUTHORSHIPS_AUTHOR_ID, "");
                uriParams.put("filter", PARAM_FILTER_AUTHORSHIPS_AUTHOR_ID + query);
            } else if (queryUrl.contains(URL_FILTER_DOI)) {
                queryUrl = queryUrl.replace(URL_FILTER_DOI, "");
                if (DoiCheck.isDoi(query)) {
                    uriParams.put("filter", PARAM_FILTER_DOI + DoiCheck.purgeDoiValue(query));
                }
            } else if (queryUrl.contains("sources")) {
                uriParams.put("filter", "type:journal,default.search:" + query);
            } else {
                uriParams.put("search", query);
            }
            String resp = this.liveImportClient.executeHttpGetRequest(1000, queryUrl, params);
            if (StringUtils.isEmpty((CharSequence)resp)) {
                log.error("Got an empty response from LiveImportClient for query: {}", (Object)query);
                return 0;
            }
            JsonNode jsonNode = this.convertStringJsonToJsonNode(resp);
            if (jsonNode != null && jsonNode.hasNonNull("meta") && jsonNode.at("/meta/count").isNumber()) {
                return jsonNode.at("/meta/count").asInt();
            }
        }
        catch (Exception e) {
            log.error("Error executing count query", (Throwable)e);
        }
        return 0;
    }

    private List<ImportRecord> searchById(String id) {
        ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
        try {
            ImportRecord record;
            String queryUrl = this.url;
            if (queryUrl.contains(URL_FILTER_AUTHORSHIPS_AUTHOR_ID)) {
                queryUrl = queryUrl.replace(URL_FILTER_AUTHORSHIPS_AUTHOR_ID, "");
            } else if (queryUrl.contains(URL_FILTER_DOI)) {
                queryUrl = queryUrl.replace(URL_FILTER_DOI, "");
            }
            String resp = this.liveImportClient.executeHttpGetRequest(1000, queryUrl + "/" + id, new HashMap<String, Map<String, String>>());
            if (StringUtils.isEmpty((CharSequence)resp)) {
                return results;
            }
            JsonNode jsonNode = this.convertStringJsonToJsonNode(resp);
            if (jsonNode != null && (record = this.transformSourceRecords(jsonNode.toString())) != null) {
                results.add(record);
            }
        }
        catch (Exception e) {
            log.error("Error searching by ID: {}", (Object)id, (Object)e);
        }
        return results;
    }

    private List<ImportRecord> search(String query, Integer page, Integer pageSize) {
        ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        HashMap<String, Object> uriParams = new HashMap<String, Object>();
        params.put("uriParameters", uriParams);
        String queryUrl = this.url;
        try {
            JsonNode docs;
            String resp;
            if (queryUrl.contains(URL_FILTER_AUTHORSHIPS_AUTHOR_ID)) {
                queryUrl = queryUrl.replace(URL_FILTER_AUTHORSHIPS_AUTHOR_ID, "");
                uriParams.put("filter", PARAM_FILTER_AUTHORSHIPS_AUTHOR_ID + query);
            } else if (queryUrl.contains(URL_FILTER_DOI)) {
                queryUrl = queryUrl.replace(URL_FILTER_DOI, "");
                if (DoiCheck.isDoi(query)) {
                    uriParams.put("filter", PARAM_FILTER_DOI + DoiCheck.purgeDoiValue(query));
                }
            } else if (queryUrl.contains("sources")) {
                uriParams.put("filter", "type:journal,default.search:" + query);
            } else {
                uriParams.put("search", query);
            }
            if (page != null) {
                uriParams.put("page", String.valueOf(page + 1));
            }
            if (pageSize != null) {
                uriParams.put("per_page", String.valueOf(pageSize));
            }
            if (StringUtils.isEmpty((CharSequence)(resp = this.liveImportClient.executeHttpGetRequest(1000, queryUrl, params)))) {
                return results;
            }
            JsonNode jsonNode = this.convertStringJsonToJsonNode(resp);
            if (jsonNode != null && (docs = jsonNode.at("/results")) != null && docs.isArray()) {
                for (JsonNode node : docs) {
                    ImportRecord record;
                    if (node == null || (record = this.transformSourceRecords(node.toString())) == null) continue;
                    results.add(record);
                }
            }
        }
        catch (Exception e) {
            log.error("Error executing search query", (Throwable)e);
        }
        return results;
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return new ObjectMapper().readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process JSON response", (Throwable)e);
            return null;
        }
    }

    public void setUrl(String url) {
        this.url = StringUtils.trimToNull((String)url);
    }

    private class SearchByIdCallable
    implements Callable<List<ImportRecord>> {
        private final Query query;

        private SearchByIdCallable(String id) {
            this.query = new Query();
            this.query.addParameter("id", id);
        }

        private SearchByIdCallable(Query query) {
            this.query = query;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            String id = this.query.getParameterAsClass("id", String.class);
            if (id == null) {
                throw new MetadataSourceException("Id cannot be null");
            }
            return OpenAlexImportMetadataSourceServiceImpl.this.searchById(id);
        }
    }

    private class CountByQueryCallable
    implements Callable<Integer> {
        private final Query query;

        private CountByQueryCallable(String queryString) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
        }

        private CountByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public Integer call() throws Exception {
            String queryString = this.query.getParameterAsClass("query", String.class);
            if (queryString == null) {
                throw new MetadataSourceException("Query cannot be null");
            }
            return OpenAlexImportMetadataSourceServiceImpl.this.count(queryString);
        }
    }

    private class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        private final Query query = new Query();

        private SearchByQueryCallable(String queryString, int start, int count) {
            this.query.addParameter("query", queryString);
            this.query.addParameter("page", start / count);
            this.query.addParameter("count", count);
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            String queryString = this.query.getParameterAsClass("query", String.class);
            if (queryString == null) {
                throw new MetadataSourceException("Query cannot be null");
            }
            return OpenAlexImportMetadataSourceServiceImpl.this.search(queryString, this.query.getParameterAsClass("page", Integer.class), this.query.getParameterAsClass("count", Integer.class));
        }
    }
}

