/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.orcid.model.OrcidProfileSectionType;
import org.dspace.orcid.model.factory.OrcidProfileSectionFactory;
import org.dspace.orcid.service.OrcidProfileSectionFactoryService;
import org.dspace.profile.OrcidProfileSyncPreference;

public class OrcidProfileSectionFactoryServiceImpl
implements OrcidProfileSectionFactoryService {
    private final Map<OrcidProfileSectionType, OrcidProfileSectionFactory> sectionFactories;

    private OrcidProfileSectionFactoryServiceImpl(List<OrcidProfileSectionFactory> sectionFactories) {
        this.sectionFactories = sectionFactories.stream().collect(Collectors.toMap(OrcidProfileSectionFactory::getProfileSectionType, Function.identity()));
    }

    @Override
    public Optional<OrcidProfileSectionFactory> findBySectionType(OrcidProfileSectionType type) {
        return Optional.ofNullable(this.sectionFactories.get((Object)type));
    }

    @Override
    public List<OrcidProfileSectionFactory> findByPreferences(List<OrcidProfileSyncPreference> preferences) {
        return this.filterBy(configuration -> preferences.contains((Object)configuration.getSynchronizationPreference()));
    }

    @Override
    public Object createOrcidObject(Context context, List<MetadataValue> metadataValues, OrcidProfileSectionType type) {
        OrcidProfileSectionFactory profileSectionFactory = this.findBySectionType(type).orElseThrow(() -> new IllegalArgumentException("No ORCID profile section factory configured for " + type));
        return profileSectionFactory.create(context, metadataValues);
    }

    private List<OrcidProfileSectionFactory> filterBy(Predicate<OrcidProfileSectionFactory> predicate) {
        return this.sectionFactories.values().stream().filter(predicate).collect(Collectors.toList());
    }
}

