/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.profile;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.content.Item;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.orcid.OrcidToken;
import org.dspace.orcid.service.OrcidTokenService;
import org.dspace.profile.ResearcherProfile;
import org.dspace.profile.service.AfterResearcherProfileCreationAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class OrcidMetadataCopyingAction
implements AfterResearcherProfileCreationAction {
    @Autowired
    private ItemService itemService;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private OrcidTokenService orcidTokenService;

    @Override
    public void perform(Context context, ResearcherProfile researcherProfile, EPerson owner) throws SQLException {
        Item item = researcherProfile.getItem();
        this.copyMetadataValues(context, owner, "eperson.orcid", item, "person.identifier.orcid");
        this.copyMetadataValues(context, owner, "eperson.orcid.scope", item, "dspace.orcid.scope");
        OrcidToken orcidToken = this.orcidTokenService.findByEPerson(context, owner);
        if (orcidToken != null) {
            orcidToken.setProfileItem(item);
        }
        if (this.isLinkedToOrcid(owner, orcidToken)) {
            String currentDate = DateTimeFormatter.ISO_DATE_TIME.format(LocalDateTime.now());
            this.itemService.setMetadataSingleValue(context, item, "dspace", "orcid", "authenticated", null, currentDate);
        }
    }

    private void copyMetadataValues(Context context, EPerson ePerson, String ePersonMetadataField, Item item, String itemMetadataField) throws SQLException {
        List<String> values = this.getMetadataValues(ePerson, ePersonMetadataField);
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        MetadataFieldName metadata = new MetadataFieldName(itemMetadataField);
        this.itemService.clearMetadata(context, item, metadata.schema, metadata.element, metadata.qualifier, "*");
        this.itemService.addMetadata(context, item, metadata.schema, metadata.element, metadata.qualifier, null, values);
    }

    private boolean isLinkedToOrcid(EPerson ePerson, OrcidToken orcidToken) {
        return CollectionUtils.isNotEmpty(this.getMetadataValues(ePerson, "eperson.orcid")) && orcidToken != null;
    }

    private List<String> getMetadataValues(EPerson ePerson, String metadataField) {
        return this.ePersonService.getMetadataByMetadataString(ePerson, metadataField).stream().map(MetadataValue::getValue).collect(Collectors.toList());
    }
}

