/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.conversion;

import java.sql.SQLException;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.rdf.conversion.ConverterPlugin;
import org.dspace.rdf.conversion.RDFConverter;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class RDFConverterImpl
implements RDFConverter {
    private static final Logger log = LogManager.getLogger(RDFConverterImpl.class);
    protected ConfigurationService configurationService;
    protected List<ConverterPlugin> plugins;

    @Autowired(required=true)
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Autowired(required=true)
    public void setPlugins(List<ConverterPlugin> plugins) {
        this.plugins = plugins;
        if (log.isDebugEnabled()) {
            StringBuilder pluginNames = new StringBuilder();
            for (ConverterPlugin plugin : plugins) {
                if (pluginNames.length() > 0) {
                    pluginNames.append(", ");
                }
                pluginNames.append(plugin.getClass().getCanonicalName());
            }
            log.debug("Loaded the following plugins: " + pluginNames.toString());
        }
    }

    public List<ConverterPlugin> getConverterPlugins() {
        return this.plugins;
    }

    @Override
    public Model convert(Context context, DSpaceObject dso) throws SQLException, AuthorizeException {
        if (this.plugins.isEmpty()) {
            log.warn("No RDFConverterPlugins were loaded, cannot convert any data!");
            return null;
        }
        Model model = ModelFactory.createDefaultModel();
        for (ConverterPlugin plugin : this.plugins) {
            Model convertedData;
            if (!plugin.supports(dso.getType()) || (convertedData = plugin.convert(context, dso)) == null) continue;
            model.setNsPrefixes((PrefixMapping)convertedData);
            model.add(convertedData);
            convertedData.close();
        }
        if (model.isEmpty()) {
            model.close();
            return null;
        }
        return model;
    }
}

