/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;

public class BitstreamByteSource
extends ByteSource {
    private static final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private final Bitstream bitstream;

    public BitstreamByteSource(Bitstream bitstream) {
        this.bitstream = bitstream;
    }

    public Bitstream getBitstream() {
        return this.bitstream;
    }

    public InputStream openStream() throws IOException {
        try {
            return bitstreamService.retrieve(new Context(), this.bitstream);
        }
        catch (SQLException | AuthorizeException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public long size() throws IOException {
        return this.bitstream.getSizeBytes();
    }
}

