/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrDocument;
import org.dspace.app.xmlui.aspect.discovery.AbstractFiltersTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.SearchUtils;
import org.xml.sax.SAXException;

public class CollectionRecentSubmissions
extends AbstractFiltersTransformer {
    private static final Logger log = Logger.getLogger(CollectionRecentSubmissions.class);
    private static final Message T_head_recent_submissions = CollectionRecentSubmissions.message((String)"xmlui.ArtifactBrowser.CollectionViewer.head_recent_submissions");

    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        Collection collection = (Collection)dso;
        this.performSearch((DSpaceObject)collection);
        if (this.queryResults == null) {
            return;
        }
        Division home = body.addDivision("collection-home", "primary repository collection");
        Division lastSubmittedDiv = home.addDivision("collection-recent-submission", "secondary recent-submission");
        lastSubmittedDiv.setHead(T_head_recent_submissions);
        ReferenceSet lastSubmitted = lastSubmittedDiv.addReferenceSet("collection-last-submitted", "summaryList", null, "recent-submissions");
        for (SolrDocument doc : this.queryResults.getResults()) {
            lastSubmitted.addReference((Object)SearchUtils.findDSpaceObject((Context)this.context, (SolrDocument)doc));
        }
    }

    @Override
    public void performSearch(DSpaceObject scope) {
        if (this.queryResults != null) {
            return;
        }
        this.queryArgs = this.prepareDefaultFilters(this.getView(), new String[0]);
        this.queryArgs.setQuery("search.resourcetype:2");
        this.queryArgs.setRows(Integer.valueOf(SearchUtils.getConfig().getInt("solr.recent-submissions.size", 5)));
        String sortField = SearchUtils.getConfig().getString("recent.submissions.sort-option");
        if (sortField != null) {
            this.queryArgs.setSortField(sortField, SolrQuery.ORDER.desc);
        }
        this.queryArgs.setFilterQueries(new String[]{"location:l" + scope.getID()});
        try {
            this.queryResults = this.getSearchService().search(this.queryArgs);
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getView() {
        return "collection";
    }
}

