/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.discovery.AbstractSearch;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.Option;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.SolrServiceImpl;
import org.xml.sax.SAXException;

public class SimpleSearch
extends AbstractSearch
implements CacheableProcessingComponent {
    private static final Message T_title = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.title");
    private static final Message T_dspace_home = SimpleSearch.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.trail");
    private static final Message T_head = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.head");
    private static final Message T_full_text_search = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.full_text_search");
    private static final Message T_go = SimpleSearch.message((String)"xmlui.general.go");
    private static final Message T_FILTER_HELP = SimpleSearch.message((String)"xmlui.Discovery.SimpleSearch.filter_help");
    private static final Message T_FILTER_HEAD = SimpleSearch.message((String)"xmlui.Discovery.SimpleSearch.filter_head");
    private static final Message T_FILTERS_SELECTED = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.filter.selected");

    public void addPageMeta(PageMeta pageMeta) throws WingException, SQLException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso instanceof Collection || dso instanceof Community) {
            HandleUtil.buildHandleTrail((DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath);
        }
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        List filterFields;
        String queryString = this.getQuery();
        Division search = body.addDivision("search", "primary");
        search.setHead(T_head);
        String searchUrl = ConfigurationManager.getProperty((String)"dspace.url") + "/JSON/discovery/searchSolr";
        search.addHidden("solr-search-url").setValue(searchUrl);
        search.addHidden("contextpath").setValue(this.contextPath);
        String[] fqs = this.getParameterFilterQueries();
        Division query = search.addInteractiveDivision("general-query", "discover", "get", "secondary search");
        org.dspace.app.xmlui.wing.element.List queryList = query.addList("search-query", "form");
        Text text = queryList.addItem().addText("query");
        text.setLabel(T_full_text_search);
        text.setValue(queryString);
        if (fqs.length > 0) {
            Composite composite = queryList.addItem().addComposite("facet-controls");
            composite.setLabel(T_FILTERS_SELECTED);
            CheckBox box = composite.addCheckBox("fq");
            String[] arr$ = fqs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Pattern pattern;
                Matcher matcher;
                boolean hasPattern;
                String name;
                String field = name = arr$[i$];
                String value = name;
                if (name.contains(":")) {
                    field = name.split(":")[0];
                    value = name.split(":")[1];
                } else {
                    field = "*";
                }
                value = value.replace("\\", "");
                if ("*".equals(field)) {
                    field = "all";
                }
                if (name.startsWith("*:")) {
                    name = name.substring(name.indexOf(":") + 1, name.length());
                }
                Option option = box.addOption(true, name);
                option.addContent(SimpleSearch.message((String)("xmlui.ArtifactBrowser.SimpleSearch.filter." + field)));
                if (field.equals("location.comm") || field.equals("location.coll")) {
                    value = SolrServiceImpl.locationToName((Context)this.context, (String)field, (String)value);
                }
                if (hasPattern = (matcher = (pattern = Pattern.compile("\\[(.*? TO .*?)\\]")).matcher(value)).find()) {
                    String[] years = matcher.group(0).replace("[", "").replace("]", "").split(" TO ");
                    option.addContent(": " + years[0] + " - " + years[1]);
                    continue;
                }
                option.addContent(": " + value);
            }
        }
        if (0 < (filterFields = SearchUtils.getSearchFilters()).size()) {
            Item item = queryList.addItem("search-filter-list", "search-filter-list");
            Composite filterComp = item.addComposite("search-filter-controls");
            filterComp.setLabel(T_FILTER_HEAD);
            filterComp.setHelp(T_FILTER_HELP);
            Select select = filterComp.addSelect("filtertype");
            select.addOption("*", SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.filter.all"));
            for (String field : filterFields) {
                select.addOption(field, SimpleSearch.message((String)("xmlui.ArtifactBrowser.SimpleSearch.filter." + field)));
            }
            filterComp.addText("filter");
            filterComp.enableAddOperation();
        }
        this.buildSearchControls(query);
        query.addPara(null, "button-list").addButton("submit").setValue(T_go);
        try {
            this.buildSearchResultsDivision(search);
        }
        catch (SearchServiceException e) {
            throw new UIException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected String[] getParameterFilterQueries() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ArrayList<String> fqs = new ArrayList<String>();
        if (request.getParameterValues("fq") != null) {
            fqs.addAll(Arrays.asList(request.getParameterValues("fq")));
        }
        if (request.getParameter("filter") != null && !"".equals(request.getParameter("filter")) && request.getParameter("submit_search-filter-controls_add") != null) {
            fqs.add((request.getParameter("filtertype").equals("*") ? "" : request.getParameter("filtertype") + ":") + request.getParameter("filter"));
        }
        return fqs.toArray(new String[fqs.size()]);
    }

    @Override
    protected String[] getSolrFilterQueries() {
        try {
            ArrayList<String> allFilterQueries = new ArrayList<String>();
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            ArrayList<String> fqs = new ArrayList<String>();
            if (request.getParameterValues("fq") != null) {
                fqs.addAll(Arrays.asList(request.getParameterValues("fq")));
            }
            String type = request.getParameter("filtertype");
            String value = request.getParameter("filter");
            if (value != null && !value.equals("") && request.getParameter("submit_search-filter-controls_add") != null) {
                String exactFq = (type.equals("*") ? "" : type + ":") + value;
                fqs.add(exactFq + " OR " + exactFq + "*");
            }
            for (String fq : fqs) {
                if (fq.matches(".*\\:\\[.* TO .*\\](?![a-z 0-9]).*")) {
                    allFilterQueries.add(fq);
                    continue;
                }
                allFilterQueries.add(fq.endsWith("*") ? fq : fq + " OR " + fq + "*");
            }
            return allFilterQueries.toArray(new String[allFilterQueries.size()]);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected String getQuery() throws UIException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String query = SimpleSearch.decodeFromURL((String)request.getParameter("query"));
        if (query == null) {
            return "";
        }
        return query.trim();
    }

    @Override
    protected String generateURL(Map<String, String> parameters) throws UIException {
        String query = this.getQuery();
        if (!"".equals(query)) {
            parameters.put("query", SimpleSearch.encodeForURL((String)query));
        }
        if (parameters.get("page") == null) {
            parameters.put("page", String.valueOf(this.getParameterPage()));
        }
        if (parameters.get("rpp") == null) {
            parameters.put("rpp", String.valueOf(this.getParameterRpp()));
        }
        if (parameters.get("group_by") == null) {
            parameters.put("group_by", String.valueOf(this.getParameterGroup()));
        }
        if (parameters.get("sort_by") == null) {
            parameters.put("sort_by", String.valueOf(this.getParameterSortBy()));
        }
        if (parameters.get("order") == null) {
            parameters.put("order", this.getParameterOrder());
        }
        if (parameters.get("etal") == null) {
            parameters.put("etal", String.valueOf(this.getParameterEtAl()));
        }
        return AbstractSearch.generateURL((String)"discover", parameters);
    }

    @Override
    public String getView() {
        return "search";
    }
}

