/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery.json;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.core.ConfigurationManager;
import org.dspace.discovery.SolrServiceImpl;
import org.xml.sax.SAXException;

public class JSONSolrSearcher
extends AbstractReader
implements Recyclable {
    private static Logger log = Logger.getLogger(JSONSolrSearcher.class);
    private String query;
    private String[] filterQueries;
    private String[] facetFields;
    private int facetLimit;
    private String facetSort;
    private int facetMinCount;
    private String solrServerUrl;
    private String jsonWrf;
    protected Response response;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        this.response = ObjectModelHelper.getResponse((Map)objectModel);
        this.query = request.getParameter("q");
        if (this.query == null) {
            this.query = "*:*";
        }
        this.filterQueries = request.getParameterValues("fq");
        this.facetFields = request.getParameterValues("facet.field");
        if (request.getParameter("facet.limit") != null) {
            try {
                this.facetLimit = Integer.parseInt(request.getParameter("facet.limit"));
            }
            catch (Exception e) {
                this.facetLimit = -1;
            }
        } else {
            this.facetLimit = -1;
        }
        this.facetSort = request.getParameter("facet.sort");
        if (!"index".equals(this.facetSort) && !"count".equals(this.facetSort)) {
            this.facetSort = null;
        }
        this.facetMinCount = 1;
        try {
            this.facetMinCount = Integer.parseInt(request.getParameter("facet.mincount"));
        }
        catch (Exception e) {
            this.facetMinCount = 1;
        }
        this.jsonWrf = request.getParameter("json.wrf");
        ExtendedProperties props = null;
        props = ExtendedProperties.convertProperties((Properties)ConfigurationManager.getProperties());
        InputStream is = null;
        try {
            File config = new File(props.getProperty("dspace.dir") + "/config/dspace-solr-search.cfg");
            if (config.exists()) {
                props.combine(new ExtendedProperties(config.getAbsolutePath()));
            } else {
                is = SolrServiceImpl.class.getResourceAsStream("dspace-solr-search.cfg");
                ExtendedProperties defaults = new ExtendedProperties();
                defaults.load(is);
                props.combine(defaults);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving solr url", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (props.getProperty("solr.search.server") != null) {
            this.solrServerUrl = props.getProperty("solr.search.server").toString();
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.solrServerUrl == null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String solrRequestUrl = this.solrServerUrl + "/select";
        params.put("rows", "0");
        params.put("wt", "json");
        params.put("json.nl", "map");
        params.put("json.wrf", this.jsonWrf);
        params.put("facet", Boolean.TRUE.toString());
        try {
            params.put("q", URLEncoder.encode(this.query, "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            return;
        }
        params.put("facet.limit", String.valueOf(this.facetLimit));
        if (this.facetSort != null) {
            params.put("facet.sort", this.facetSort);
        }
        params.put("facet.mincount", String.valueOf(this.facetMinCount));
        solrRequestUrl = AbstractDSpaceTransformer.generateURL((String)solrRequestUrl, params);
        if (this.facetFields != null || this.filterQueries != null) {
            StringBuilder urlBuilder = new StringBuilder(solrRequestUrl);
            if (this.facetFields != null) {
                for (String facetField : this.facetFields) {
                    urlBuilder.append("&").append("facet.field").append("=");
                    if (!facetField.endsWith(".year") && !facetField.endsWith("_ac")) {
                        urlBuilder.append(URLEncoder.encode(facetField + "_ac", "UTF-8"));
                        continue;
                    }
                    urlBuilder.append(URLEncoder.encode(facetField, "UTF-8"));
                }
            }
            if (this.filterQueries != null) {
                for (String filterQuery : this.filterQueries) {
                    urlBuilder.append("&").append("fq").append("=").append(URLEncoder.encode(filterQuery, "UTF-8"));
                }
            }
            solrRequestUrl = urlBuilder.toString();
        }
        try {
            GetMethod get = new GetMethod(solrRequestUrl);
            new HttpClient().executeMethod((HttpMethod)get);
            String result = get.getResponseBodyAsString();
            if (result != null) {
                int length;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(result.getBytes("UTF-8"));
                byte[] buffer = new byte[8192];
                this.response.setHeader("Content-Length", String.valueOf(result.length()));
                while ((length = inputStream.read(buffer)) > -1) {
                    this.out.write(buffer, 0, length);
                }
                this.out.flush();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while getting json solr result for discovery search recommendation", (Throwable)e);
            e.printStackTrace();
        }
    }
}

