/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.dspace.app.xmlui.aspect.discovery.AbstractFiltersTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.xml.sax.SAXException;

public abstract class AbstractSearch
extends AbstractFiltersTransformer {
    private static final Logger log = Logger.getLogger(AbstractSearch.class);
    private static final Message T_result_query = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.result_query");
    private static final Message T_head1_community = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head1_community");
    private static final Message T_head1_collection = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head1_collection");
    private static final Message T_head1_none = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head1_none");
    private static final Message T_head2 = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head2");
    private static final Message T_no_results = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.no_results");
    private static final Message T_all_of_dspace = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.all_of_dspace");
    private static final Message T_sort_by_relevance = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.sort_by.relevance");
    private static final Message T_sort_by = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.sort_by");
    private static final Message T_order = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.order");
    private static final Message T_order_asc = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.order.asc");
    private static final Message T_order_desc = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.order.desc");
    private static final Message T_rpp = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.rpp");
    private static final int[] RESULTS_PER_PAGE_PROGRESSION = new int[]{5, 10, 20, 40, 60, 80, 100};
    private SourceValidity validity;

    @Override
    public Serializable getKey() {
        try {
            String key = "";
            key = key + "-" + this.getParameterPage();
            key = key + "-" + this.getParameterRpp();
            key = key + "-" + this.getParameterSortBy();
            key = key + "-" + this.getParameterOrder();
            key = key + "-" + this.getParameterEtAl();
            DSpaceObject scope = this.getScope();
            if (scope != null) {
                key = key + "-" + scope.getHandle();
            }
            key = key + "-" + this.getQuery();
            return Long.valueOf(HashUtil.hash((String)key));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            return "0";
        }
    }

    @Override
    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceValidity validity = new DSpaceValidity();
                DSpaceObject scope = this.getScope();
                validity.add(scope);
                this.performSearch(scope);
                SolrDocumentList results = this.queryResults.getResults();
                if (results != null) {
                    validity.add("size:" + results.size());
                    for (SolrDocument result : results) {
                        validity.add(result.toString());
                    }
                }
                this.validity = validity.complete();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                this.validity = null;
            }
            this.logSearch();
        }
        return this.validity;
    }

    public abstract void addBody(Body var1) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException;

    protected void buildSearchResultsDivision(Division search) throws IOException, SQLException, WingException, SearchServiceException {
        try {
            if (this.queryResults == null || this.queryResults.getResults() == null) {
                DSpaceObject scope = this.getScope();
                this.performSearch(scope);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.queryResults = null;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.queryResults = null;
        }
        if (this.queryResults != null) {
            search.addPara("result-query", "result-query").addContent(T_result_query.parameterize(new Object[]{this.getQuery(), this.queryResults.getResults().getNumFound()}));
        }
        Division results = search.addDivision("search-results", "primary");
        DSpaceObject searchScope = this.getScope();
        if (searchScope instanceof Community) {
            Community community = (Community)searchScope;
            String communityName = community.getMetadata("name");
            results.setHead(T_head1_community.parameterize(new Object[]{communityName}));
        } else if (searchScope instanceof Collection) {
            Collection collection = (Collection)searchScope;
            String collectionName = collection.getMetadata("name");
            results.setHead(T_head1_collection.parameterize(new Object[]{collectionName}));
        } else {
            results.setHead(T_head1_none);
        }
        if (this.queryResults != null && this.queryResults.getResults().getNumFound() > 0L) {
            SolrDocumentList solrResults = this.queryResults.getResults();
            int itemsTotal = (int)solrResults.getNumFound();
            int firstItemIndex = (int)solrResults.getStart() + 1;
            int lastItemIndex = (int)solrResults.getStart() + solrResults.size();
            int currentPage = (int)(solrResults.getStart() / (long)this.queryArgs.getRows().intValue()) + 1;
            int pagesTotal = (int)((solrResults.getNumFound() - 1L) / (long)this.queryArgs.getRows().intValue()) + 1;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("page", "{pageNum}");
            String pageURLMask = this.generateURL(parameters);
            String[] fqs = this.getParameterFilterQueries();
            if (fqs != null) {
                StringBuilder maskBuilder = new StringBuilder(pageURLMask);
                for (String fq : fqs) {
                    maskBuilder.append("&fq=").append(fq);
                }
                pageURLMask = maskBuilder.toString();
            }
            results.setMaskedPagination(itemsTotal, firstItemIndex, lastItemIndex, currentPage, pagesTotal, pageURLMask);
            ReferenceSet referenceSet = null;
            for (SolrDocument doc : solrResults) {
                DSpaceObject resultDSO = SearchUtils.findDSpaceObject((Context)this.context, (SolrDocument)doc);
                if (!(resultDSO instanceof Community) && !(resultDSO instanceof Collection)) continue;
                if (referenceSet == null) {
                    referenceSet = results.addReferenceSet("search-results-repository", "summaryList", null, "repository-search-results");
                    referenceSet.setHead(T_head2);
                }
                referenceSet.addReference((Object)resultDSO);
            }
            referenceSet = results.addReferenceSet("search-results-repository", "summaryList", null, "repository-search-results");
            for (SolrDocument doc : solrResults) {
                DSpaceObject resultDSO = SearchUtils.findDSpaceObject((Context)this.context, (SolrDocument)doc);
                if (!(resultDSO instanceof Item)) continue;
                referenceSet.addReference((Object)resultDSO);
            }
        } else {
            results.addPara(T_no_results);
        }
    }

    protected void buildScopeList(Select scope) throws SQLException, WingException {
        block4: {
            Community[] communities;
            DSpaceObject scopeDSO;
            block5: {
                block3: {
                    scopeDSO = this.getScope();
                    if (scopeDSO != null) break block3;
                    scope.addOption("/", T_all_of_dspace);
                    scope.setOptionSelected("/");
                    for (Community community : Community.findAllTop((Context)this.context)) {
                        scope.addOption(community.getHandle(), community.getMetadata("name"));
                    }
                    break block4;
                }
                if (!(scopeDSO instanceof Community)) break block5;
                Community community = (Community)scopeDSO;
                scope.addOption("/", T_all_of_dspace);
                scope.addOption(community.getHandle(), community.getMetadata("name"));
                scope.setOptionSelected(community.getHandle());
                for (Collection collection : community.getCollections()) {
                    scope.addOption(collection.getHandle(), collection.getMetadata("name"));
                }
                break block4;
            }
            if (!(scopeDSO instanceof Collection)) break block4;
            Collection collection = (Collection)scopeDSO;
            scope.addOption("/", T_all_of_dspace);
            scope.addOption(collection.getHandle(), collection.getMetadata("name"));
            scope.setOptionSelected(collection.getHandle());
            for (Community community : communities = collection.getCommunities()[0].getAllParents()) {
                scope.addOption(community.getHandle(), community.getMetadata("name"));
            }
        }
    }

    @Override
    public void performSearch(DSpaceObject scope) throws UIException, SearchServiceException {
        if (this.queryResults != null) {
            return;
        }
        String query = this.getQuery();
        int page = this.getParameterPage();
        ArrayList<String> filterQueries = new ArrayList<String>();
        if (scope instanceof Community) {
            filterQueries.add("location:m" + scope.getID());
        } else if (scope instanceof Collection) {
            filterQueries.add("location:l" + scope.getID());
        }
        String[] fqs = this.getSolrFilterQueries();
        if (fqs != null) {
            filterQueries.addAll(Arrays.asList(fqs));
        }
        this.queryArgs = this.prepareDefaultFilters("search", filterQueries.toArray(new String[filterQueries.size()]));
        if (filterQueries.size() > 0) {
            this.queryArgs.addFilterQuery(filterQueries.toArray(new String[filterQueries.size()]));
        }
        this.queryArgs.setRows(Integer.valueOf(this.getParameterRpp()));
        String sortBy = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("sort_by");
        String sortOrder = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("order");
        if (sortBy != null) {
            if (sortOrder == null || sortOrder.equals("DESC")) {
                this.queryArgs.addSortField(sortBy, SolrQuery.ORDER.desc);
            } else {
                this.queryArgs.addSortField(sortBy, SolrQuery.ORDER.asc);
            }
        } else {
            this.queryArgs.addSortField("score", SolrQuery.ORDER.asc);
        }
        String groupBy = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("group_by");
        if (groupBy != null && !groupBy.equalsIgnoreCase("none")) {
            this.queryArgs.add("collapse.field", new String[]{groupBy});
            this.queryArgs.add("collapse.threshold", new String[]{"1"});
            this.queryArgs.add("collapse.includeCollapsedDocs.fl", new String[]{"handle"});
            this.queryArgs.add("collapse.facet", new String[]{"before"});
            this.queryArgs.addSortField("dc.type", SolrQuery.ORDER.asc);
        }
        this.queryArgs.setQuery(query != null && !query.trim().equals("") ? query : "*:*");
        if (page > 1) {
            this.queryArgs.setStart(Integer.valueOf((page - 1) * this.queryArgs.getRows()));
        } else {
            this.queryArgs.setStart(Integer.valueOf(0));
        }
        this.queryResults = this.getSearchService().search(this.queryArgs);
    }

    protected String[] getParameterFilterQueries() {
        try {
            return ObjectModelHelper.getRequest((Map)this.objectModel).getParameterValues("fq");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String[] getSolrFilterQueries() {
        try {
            return ObjectModelHelper.getRequest((Map)this.objectModel).getParameterValues("fq");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String[] getFacetsList() {
        try {
            return ObjectModelHelper.getRequest((Map)this.objectModel).getParameterValues("fl");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected int getParameterPage() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("page"));
        }
        catch (Exception e) {
            return 1;
        }
    }

    protected int getParameterRpp() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("rpp"));
        }
        catch (Exception e) {
            return 10;
        }
    }

    protected String getParameterSortBy() {
        String s = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("sort_by");
        return s != null ? s : "score";
    }

    protected String getParameterGroup() {
        String s = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("group_by");
        return s != null ? s : "none";
    }

    protected String getParameterOrder() {
        String s = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("order");
        return s != null ? s : "DESC";
    }

    protected int getParameterEtAl() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("etal"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected boolean variableScope() throws SQLException {
        return HandleUtil.obtainHandle((Map)this.objectModel) == null;
    }

    protected abstract String getQuery() throws UIException;

    protected abstract String generateURL(Map<String, String> var1) throws UIException;

    @Override
    public void recycle() {
        this.validity = null;
        super.recycle();
    }

    protected void buildSearchControls(Division div) throws WingException {
        Table controlsTable = div.addTable("search-controls", 1, 3);
        Row controlsRow = controlsTable.addRow("data");
        Cell rppCell = controlsRow.addCell();
        rppCell.addContent(T_rpp);
        Select rppSelect = rppCell.addSelect("rpp");
        for (int i : RESULTS_PER_PAGE_PROGRESSION) {
            rppSelect.addOption(i == this.getParameterRpp(), i, Integer.toString(i));
        }
        Cell sortCell = controlsRow.addCell();
        sortCell.addContent(T_sort_by);
        Select sortSelect = sortCell.addSelect("sort_by");
        sortSelect.addOption(false, "score", T_sort_by_relevance);
        for (String sortField : SearchUtils.getSortFields()) {
            sortField = sortField + "_sort";
            sortSelect.addOption(sortField.equals(this.getParameterSortBy()), sortField, AbstractSearch.message((String)("xmlui.ArtifactBrowser.AbstractSearch.sort_by." + sortField)));
        }
        Cell orderCell = controlsRow.addCell();
        orderCell.addContent(T_order);
        Select orderSelect = orderCell.addSelect("order");
        orderSelect.addOption("ASC".equals(this.getParameterOrder()), "ASC", T_order_asc);
        orderSelect.addOption("DESC".equals(this.getParameterOrder()), "DESC", T_order_desc);
    }

    protected void logSearch() {
        int countCommunities = 0;
        int countCollections = 0;
        int countItems = 0;
        String logInfo = "";
        try {
            DSpaceObject dsoScope = this.getScope();
            if (dsoScope instanceof Collection) {
                logInfo = "collection_id=" + dsoScope.getID() + ",";
            } else if (dsoScope instanceof Community) {
                logInfo = "community_id=" + dsoScope.getID() + ",";
            }
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        log.info((Object)LogManager.getHeader((Context)this.context, (String)"search", (String)(logInfo + "query=\"" + this.queryArgs.getQuery() + "\",results=(" + countCommunities + "," + countCollections + "," + countItems + ")")));
    }
}

