/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.RequestUtils;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.SolrServiceImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.xml.sax.SAXException;

public class BrowseFacet
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(BrowseFacet.class);
    private static final Message T_dspace_home = BrowseFacet.message((String)"xmlui.general.dspace_home");
    protected QueryResponse queryResults;
    protected SourceValidity validity;
    protected SolrQuery queryArgs;
    private int DEFAULT_PAGE_SIZE = 10;
    public static final String OFFSET = "offset";
    public static final String FACET_FIELD = "field";
    private ConfigurationService config = null;
    private SearchService searchService = null;

    public BrowseFacet() {
        DSpace dspace = new DSpace();
        this.config = dspace.getConfigurationService();
        this.searchService = (SearchService)dspace.getServiceManager().getServiceByName(SearchService.class.getName(), SearchService.class);
    }

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceValidity validity = new DSpaceValidity();
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (dso != null) {
                    validity.add(dso);
                }
                QueryResponse response = this.getQueryResponse(dso);
                validity.add("numFound:" + response.getResults().getNumFound());
                for (SolrDocument doc : response.getResults()) {
                    validity.add(doc.toString());
                }
                for (SolrDocument doc : response.getResults()) {
                    validity.add(doc.toString());
                }
                for (FacetField field : response.getFacetFields()) {
                    validity.add(field.getName());
                    for (FacetField.Count count : field.getValues()) {
                        validity.add(count.getName() + count.getCount());
                    }
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    protected QueryResponse getQueryResponse(DSpaceObject scope) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (this.queryResults != null) {
            return this.queryResults;
        }
        this.queryArgs = new SolrQuery();
        this.queryArgs.addFilterQuery(SearchUtils.getDefaultFilters((String)"browse"));
        this.queryArgs.setQuery("search.resourcetype: 2" + (request.getParameter("query") != null && !"".equals(request.getParameter("query")) ? " AND (" + request.getParameter("query") + ")" : ""));
        this.queryArgs.setRows(Integer.valueOf(0));
        this.queryArgs.setSortField(ConfigurationManager.getProperty((String)"recent.submissions.sort-option"), SolrQuery.ORDER.asc);
        this.queryArgs.addFilterQuery(this.getParameterFacetQueries());
        this.queryArgs.setFacetMinCount(1);
        this.queryArgs.setFacetSort((String)this.config.getPropertyAsType("solr.browse.sort", (Object)"lex"));
        this.queryArgs.setFacet(true);
        int offset = RequestUtils.getIntParameter((Request)request, (String)OFFSET);
        if (offset == -1) {
            offset = 0;
        }
        this.queryArgs.setParam("facet.offset", new String[]{String.valueOf(offset)});
        this.queryArgs.setParam("facet.limit", new String[]{String.valueOf(this.DEFAULT_PAGE_SIZE + 1)});
        if (scope != null) {
            if (scope instanceof Community) {
                this.queryArgs.setFilterQueries(new String[]{"location:m" + scope.getID()});
            } else if (scope instanceof Collection) {
                this.queryArgs.setFilterQueries(new String[]{"location:l" + scope.getID()});
            }
        }
        String facetField = request.getParameter(FACET_FIELD);
        boolean isDate = false;
        if (facetField.endsWith("_dt")) {
            facetField = facetField.split("_")[0];
            isDate = true;
        }
        if (isDate) {
            this.queryArgs.setParam("facet.date", new String[]{facetField});
            this.queryArgs.setParam("facet.date.gap", new String[]{"+1YEAR"});
            Date lowestDate = this.getLowestDateValue(this.queryArgs.getQuery(), facetField, this.queryArgs.getFilterQueries());
            int thisYear = Calendar.getInstance().get(1);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
            int maxEndYear = Integer.parseInt(formatter.format(lowestDate));
            String startDate = "NOW/YEAR-" + SearchUtils.getConfig().getString("solr.date.gap", "10") + "YEARS";
            String endDate = "NOW";
            int startYear = thisYear - (offset + this.DEFAULT_PAGE_SIZE);
            if (startYear < maxEndYear) {
                startYear = maxEndYear - 1;
            }
            if (0 < offset) {
                int endYear = thisYear - offset + 1;
                endDate = "NOW/YEAR-" + (thisYear - endYear) + "YEARS";
            }
            startDate = "NOW/YEAR-" + (thisYear - startYear) + "YEARS";
            this.queryArgs.setParam("facet.date.start", new String[]{startDate});
            this.queryArgs.setParam("facet.date.end", new String[]{endDate});
            System.out.println(startDate);
            System.out.println(endDate);
        } else {
            this.queryArgs.addFacetField(new String[]{facetField});
        }
        try {
            this.queryResults = this.searchService.search(this.queryArgs);
        }
        catch (SearchServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.queryResults;
    }

    private Date getLowestDateValue(String query, String dateField, String ... filterquery) {
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(query);
            solrQuery.setFields(new String[]{dateField});
            solrQuery.setRows(Integer.valueOf(1));
            solrQuery.setSortField(dateField, SolrQuery.ORDER.asc);
            solrQuery.setFilterQueries(filterquery);
            QueryResponse rsp = this.searchService.search(solrQuery);
            if (0L < rsp.getResults().getNumFound()) {
                return (Date)((SolrDocument)rsp.getResults().get(0)).getFieldValue(dateField);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to get lowest date", (Throwable)e);
        }
        return null;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String facetField = request.getParameter(FACET_FIELD);
        pageMeta.addMetadata("title").addContent(BrowseFacet.message((String)("xmlui.ArtifactBrowser.AbstractSearch.type_" + facetField + "_browse")));
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso instanceof Collection || dso instanceof Community) {
            HandleUtil.buildHandleTrail((DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath);
        }
        pageMeta.addTrail().addContent(BrowseFacet.message((String)("xmlui.ArtifactBrowser.AbstractSearch.type_" + facetField + "_browse")));
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        this.queryResults = this.getQueryResponse(dso);
        if (this.queryResults != null) {
            ArrayList facetFields = this.queryResults.getFacetFields();
            if (facetFields == null) {
                facetFields = new ArrayList();
            }
            facetFields.addAll(this.queryResults.getFacetDates());
            if (facetFields.size() > 0) {
                FacetField field = (FacetField)facetFields.get(0);
                List values = field.getValues();
                if (field.getGap() != null) {
                    Collections.reverse(values);
                }
                if (values != null && 0 < values.size()) {
                    Division results = body.addDivision("browse-by-" + field + "-results", "primary");
                    results.setHead(BrowseFacet.message((String)("xmlui.ArtifactBrowser.AbstractSearch.type_" + request.getParameter(FACET_FIELD) + "_browse")));
                    int offSet = 0;
                    try {
                        offSet = Integer.parseInt(this.queryArgs.get("facet.offset"));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    String nextPageUrl = null;
                    if (values.size() == this.DEFAULT_PAGE_SIZE + 1) {
                        nextPageUrl = this.getNextPageURL(request);
                    }
                    results.setSimplePagination((int)this.queryResults.getResults().getNumFound(), offSet + 1, offSet + (values.size() - 1), this.getPreviousPageURL(request), nextPageUrl);
                    Table singleTable = results.addTable("browse-by-" + field + "-results", (int)(this.queryResults.getResults().getNumFound() + 1L), 1);
                    List<Object> filterQueries = new ArrayList();
                    if (request.getParameterValues("fq") != null) {
                        filterQueries = Arrays.asList(request.getParameterValues("fq"));
                    }
                    for (int i = 0; i < values.size(); ++i) {
                        FacetField.Count value = (FacetField.Count)values.get(i);
                        String displayedValue = value.getName();
                        String filterQuery = value.getAsFilterQuery();
                        if (field.getName().equals("location.comm") || field.getName().equals("location.coll")) {
                            displayedValue = SolrServiceImpl.locationToName((Context)this.context, (String)field.getName(), (String)displayedValue);
                        }
                        if (field.getGap() != null) {
                            SimpleDateFormat simpleDateformat = new SimpleDateFormat("yyyy");
                            displayedValue = simpleDateformat.format(SolrServiceImpl.toDate((String)displayedValue));
                            filterQuery = ClientUtils.escapeQueryChars((String)value.getFacetField().getName()) + ":" + displayedValue + "*";
                        }
                        Cell cell = singleTable.addRow().addCell();
                        if (filterQueries.contains(filterQuery)) {
                            cell.addContent(displayedValue + " (" + value.getCount() + ")");
                            continue;
                        }
                        cell.addXref(this.contextPath + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/discover?" + "&fq=" + URLEncoder.encode(filterQuery, "UTF-8") + (request.getQueryString() != null ? "&" + request.getQueryString() : ""), displayedValue + " (" + value.getCount() + ")");
                    }
                }
            }
        }
    }

    private String getNextPageURL(Request request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(FACET_FIELD, request.getParameter(FACET_FIELD));
        if (this.queryArgs.get("facet.offset") != null) {
            parameters.put(OFFSET, String.valueOf(Integer.parseInt(this.queryArgs.get("facet.offset")) + this.DEFAULT_PAGE_SIZE));
        }
        String url = BrowseFacet.generateURL((String)"browse-discovery", parameters);
        String[] fqs = this.getParameterFacetQueries();
        if (fqs != null) {
            StringBuilder urlBuilder = new StringBuilder(url);
            for (String fq : fqs) {
                urlBuilder.append("&fq=").append(fq);
            }
            url = urlBuilder.toString();
        }
        return url;
    }

    private String getPreviousPageURL(Request request) {
        if ("0".equals(this.queryArgs.get("facet.offset"))) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(FACET_FIELD, request.getParameter(FACET_FIELD));
        if (this.queryArgs.get("facet.offset") != null) {
            parameters.put(OFFSET, String.valueOf(Integer.parseInt(this.queryArgs.get("facet.offset")) - this.DEFAULT_PAGE_SIZE));
        }
        String url = BrowseFacet.generateURL((String)"browse-discovery", parameters);
        String[] fqs = this.getParameterFacetQueries();
        if (fqs != null) {
            StringBuilder urlBuilder = new StringBuilder(url);
            for (String fq : fqs) {
                urlBuilder.append("&fq=").append(fq);
            }
            url = urlBuilder.toString();
        }
        return url;
    }

    public void recycle() {
        this.queryResults = null;
        this.validity = null;
        super.recycle();
    }

    public String[] getParameterFacetQueries() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        return request.getParameterValues("fq") != null ? request.getParameterValues("fq") : new String[]{};
    }
}

