/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.aspect.discovery.BrowseFacet;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.RequestUtils;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.SolrServiceImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.xml.sax.SAXException;

public class SearchFacetFilter
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(BrowseFacet.class);
    private static final Message T_dspace_home = SearchFacetFilter.message((String)"xmlui.general.dspace_home");
    private static final Message T_starts_with = SearchFacetFilter.message((String)"xmlui.Discovery.AbstractSearch.startswith");
    private static final Message T_starts_with_help = SearchFacetFilter.message((String)"xmlui.Discovery.AbstractSearch.startswith.help");
    protected QueryResponse queryResults;
    protected SourceValidity validity;
    protected SolrQuery queryArgs;
    private int DEFAULT_PAGE_SIZE = 10;
    private ConfigurationService config = null;
    private SearchService searchService = null;
    private static final Message T_go = SearchFacetFilter.message((String)"xmlui.general.go");

    public SearchFacetFilter() {
        DSpace dspace = new DSpace();
        this.config = dspace.getConfigurationService();
        this.searchService = (SearchService)dspace.getServiceManager().getServiceByName(SearchService.class.getName(), SearchService.class);
    }

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceValidity validity = new DSpaceValidity();
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (dso != null) {
                    validity.add(dso);
                }
                QueryResponse response = this.getQueryResponse(dso);
                validity.add("numFound:" + response.getResults().getNumFound());
                for (SolrDocument doc : response.getResults()) {
                    validity.add(doc.toString());
                }
                for (SolrDocument doc : response.getResults()) {
                    validity.add(doc.toString());
                }
                for (FacetField field : response.getFacetFields()) {
                    validity.add(field.getName());
                    for (FacetField.Count count : field.getValues()) {
                        validity.add(count.getName() + count.getCount());
                    }
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    protected QueryResponse getQueryResponse(DSpaceObject scope) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (this.queryResults != null) {
            return this.queryResults;
        }
        this.queryArgs = new SolrQuery();
        this.queryArgs.addFilterQuery(SearchUtils.getDefaultFilters((String)"search"));
        this.queryArgs.setQuery("search.resourcetype: 2" + (request.getParameter("query") != null && !"".equals(request.getParameter("query")) ? " AND (" + request.getParameter("query") + ")" : ""));
        this.queryArgs.setRows(Integer.valueOf(0));
        this.queryArgs.addFilterQuery(this.getParameterFilterQueries());
        this.queryArgs.setFacetMinCount(1);
        this.queryArgs.setFacetSort((String)this.config.getPropertyAsType("solr.browse.sort", (Object)"lex"));
        this.queryArgs.setFacet(true);
        String facetField = request.getParameter("field");
        int offset = RequestUtils.getIntParameter((Request)request, (String)"offset");
        if (offset == -1) {
            offset = 0;
        }
        if (facetField.endsWith(".year")) {
            this.queryArgs.setParam("facet.offset", new String[]{"0"});
            this.queryArgs.setParam("facet.limit", new String[]{"1000000"});
        } else {
            this.queryArgs.setParam("facet.offset", new String[]{String.valueOf(offset)});
            this.queryArgs.setParam("facet.limit", new String[]{String.valueOf(this.DEFAULT_PAGE_SIZE + 1)});
        }
        if (scope != null) {
            if (scope instanceof Community) {
                this.queryArgs.setFilterQueries(new String[]{"location:m" + scope.getID()});
            } else if (scope instanceof Collection) {
                this.queryArgs.setFilterQueries(new String[]{"location:l" + scope.getID()});
            }
        }
        boolean isDate = false;
        if (facetField.endsWith("_dt")) {
            facetField = facetField.split("_")[0];
            isDate = true;
        }
        if (isDate) {
            this.queryArgs.setParam("facet.date", new String[]{facetField});
            this.queryArgs.setParam("facet.date.gap", new String[]{"+1YEAR"});
            Date lowestDate = this.getLowestDateValue(this.queryArgs.getQuery(), facetField, this.queryArgs.getFilterQueries());
            int thisYear = Calendar.getInstance().get(1);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
            int maxEndYear = Integer.parseInt(formatter.format(lowestDate));
            String startDate = "NOW/YEAR-" + SearchUtils.getConfig().getString("solr.date.gap", "10") + "YEARS";
            String endDate = "NOW";
            int startYear = thisYear - (offset + this.DEFAULT_PAGE_SIZE);
            if (startYear < maxEndYear) {
                startYear = maxEndYear - 1;
            }
            if (0 < offset) {
                int endYear = thisYear - offset + 1;
                endDate = "NOW/YEAR-" + (thisYear - endYear) + "YEARS";
            }
            startDate = "NOW/YEAR-" + (thisYear - startYear) + "YEARS";
            this.queryArgs.setParam("facet.date.start", new String[]{startDate});
            this.queryArgs.setParam("facet.date.end", new String[]{endDate});
            System.out.println(startDate);
            System.out.println(endDate);
        } else {
            if (request.getParameter("starts_with") != null) {
                this.queryArgs.setFacetPrefix(facetField, request.getParameter("starts_with").toLowerCase());
            }
            this.queryArgs.addFacetField(new String[]{facetField});
        }
        try {
            this.queryResults = this.searchService.search(this.queryArgs);
        }
        catch (SearchServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.queryResults;
    }

    private Date getLowestDateValue(String query, String dateField, String ... filterquery) {
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(query);
            solrQuery.setFields(new String[]{dateField});
            solrQuery.setRows(Integer.valueOf(1));
            solrQuery.setSortField(dateField, SolrQuery.ORDER.asc);
            solrQuery.setFilterQueries(filterquery);
            QueryResponse rsp = this.searchService.search(solrQuery);
            if (0L < rsp.getResults().getNumFound()) {
                return (Date)((SolrDocument)rsp.getResults().get(0)).getFieldValue(dateField);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String facetField = request.getParameter("field");
        pageMeta.addMetadata("title").addContent(SearchFacetFilter.message((String)("xmlui.Discovery.AbstractSearch.type_" + facetField)));
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso instanceof Collection || dso instanceof Community) {
            HandleUtil.buildHandleTrail((DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath);
        }
        pageMeta.addTrail().addContent(SearchFacetFilter.message((String)("xmlui.Discovery.AbstractSearch.type_" + facetField)));
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        SearchFilterParam browseParams = new SearchFilterParam(request);
        Division div = body.addDivision("browse-by-" + request.getParameter("field"), "primary");
        this.addBrowseJumpNavigation(div, browseParams, request);
        this.queryResults = this.getQueryResponse(dso);
        if (this.queryResults != null) {
            ArrayList facetFields = this.queryResults.getFacetFields();
            if (facetFields == null) {
                facetFields = new ArrayList();
            }
            facetFields.addAll(this.queryResults.getFacetDates());
            if (facetFields.size() > 0) {
                FacetField field = (FacetField)facetFields.get(0);
                List values = field.getValues();
                if (field.getGap() != null) {
                    Collections.reverse(values);
                }
                Division results = body.addDivision("browse-by-" + field + "-results", "primary");
                results.setHead(SearchFacetFilter.message((String)("xmlui.Discovery.AbstractSearch.type_" + browseParams.getFacetField())));
                if (values != null && 0 < values.size()) {
                    int offSet = 0;
                    try {
                        offSet = Integer.parseInt(this.queryArgs.get("facet.offset"));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    String nextPageUrl = null;
                    if (field.getName().endsWith(".year")) {
                        offSet = Util.getIntParameter((HttpServletRequest)request, (String)"offset");
                        int n = offSet = offSet == -1 ? 0 : offSet;
                        if (offSet + this.DEFAULT_PAGE_SIZE < values.size()) {
                            nextPageUrl = this.getNextPageURL(browseParams, request);
                        }
                    } else if (values.size() == this.DEFAULT_PAGE_SIZE + 1) {
                        nextPageUrl = this.getNextPageURL(browseParams, request);
                    }
                    int shownItemsMax = field.getName().endsWith(".year") ? (values.size() - offSet < this.DEFAULT_PAGE_SIZE ? values.size() : this.DEFAULT_PAGE_SIZE) : offSet + (this.DEFAULT_PAGE_SIZE < values.size() ? values.size() - 1 : values.size());
                    results.setSimplePagination(-1, offSet + 1, shownItemsMax, this.getPreviousPageURL(browseParams, request), nextPageUrl);
                    Table singleTable = results.addTable("browse-by-" + field + "-results", (int)(this.queryResults.getResults().getNumFound() + 1L), 1);
                    ArrayList<String> filterQueries = new ArrayList();
                    if (request.getParameterValues("fq") != null) {
                        filterQueries = Arrays.asList(request.getParameterValues("fq"));
                    }
                    if (field.getName().endsWith(".year")) {
                        int start = values.size() - 1 - offSet;
                        int end = start - this.DEFAULT_PAGE_SIZE;
                        end = end < 0 ? 0 : ++end;
                        for (int i = start; end <= i; --i) {
                            FacetField.Count value = (FacetField.Count)values.get(i);
                            this.renderFacetField(browseParams, dso, field, singleTable, filterQueries, value);
                        }
                    } else {
                        int end = values.size();
                        if (this.DEFAULT_PAGE_SIZE < end) {
                            end = this.DEFAULT_PAGE_SIZE;
                        }
                        for (int i = 0; i < end; ++i) {
                            FacetField.Count value = (FacetField.Count)values.get(i);
                            this.renderFacetField(browseParams, dso, field, singleTable, filterQueries, value);
                        }
                    }
                } else {
                    results.addPara(SearchFacetFilter.message((String)"xmlui.discovery.SearchFacetFilter.no-results"));
                }
            }
        }
    }

    private void addBrowseJumpNavigation(Division div, SearchFilterParam browseParams, Request request) throws WingException {
        String[] filterQueries;
        Division jump = div.addInteractiveDivision("filter-navigation", this.contextPath + "/search-filter", "post", "secondary navigation");
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(browseParams.getCommonBrowseParams());
        for (Map.Entry param : params.entrySet()) {
            jump.addHidden((String)param.getKey()).setValue((String)param.getValue());
        }
        for (String filterQuery : filterQueries = this.getParameterFilterQueries()) {
            jump.addHidden("fq").setValue(filterQuery);
        }
        if (!browseParams.getFacetField().endsWith(".year")) {
            org.dspace.app.xmlui.wing.element.List jumpList = jump.addList("jump-list", "simple", "alphabet");
            String basicUrl = SearchFacetFilter.generateURL((String)"search-filter", params);
            basicUrl = this.addFilterQueriesToUrl(basicUrl);
            for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                String linkUrl = basicUrl + "&" + "starts_with" + "=" + Character.toString(c).toLowerCase();
                jumpList.addItemXref(linkUrl, Character.toString(c));
            }
            Para jumpForm = jump.addPara();
            jumpForm.addContent(T_starts_with);
            jumpForm.addText("starts_with").setHelp(T_starts_with_help);
            jumpForm.addButton("submit").setValue(T_go);
        }
    }

    private void renderFacetField(SearchFilterParam browseParams, DSpaceObject dso, FacetField field, Table singleTable, List<String> filterQueries, FacetField.Count value) throws SQLException, WingException, UnsupportedEncodingException {
        String displayedValue = value.getName();
        String filterQuery = value.getAsFilterQuery();
        if (field.getName().equals("location.comm") || field.getName().equals("location.coll")) {
            displayedValue = SolrServiceImpl.locationToName((Context)this.context, (String)field.getName(), (String)displayedValue);
        }
        if (field.getGap() != null) {
            SimpleDateFormat simpleDateformat = new SimpleDateFormat("yyyy");
            displayedValue = simpleDateformat.format(SolrServiceImpl.toDate((String)displayedValue));
            filterQuery = ClientUtils.escapeQueryChars((String)value.getFacetField().getName()) + ":" + displayedValue + "*";
        }
        Cell cell = singleTable.addRow().addCell();
        if (filterQueries.contains(filterQuery)) {
            cell.addContent(SearchUtils.getFilterQueryDisplay((String)displayedValue) + " (" + value.getCount() + ")");
        } else {
            HashMap<String, String> urlParams = new HashMap<String, String>();
            urlParams.putAll(browseParams.getCommonBrowseParams());
            String url = SearchFacetFilter.generateURL((String)(this.contextPath + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/discover"), urlParams);
            url = this.addFilterQueriesToUrl(url);
            url = url + "&fq=" + filterQuery;
            cell.addXref(url, SearchUtils.getFilterQueryDisplay((String)displayedValue) + " (" + value.getCount() + ")");
        }
    }

    private String getNextPageURL(SearchFilterParam browseParams, Request request) {
        int offSet = Util.getIntParameter((HttpServletRequest)request, (String)"offset");
        if (offSet == -1) {
            offSet = 0;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(browseParams.getCommonBrowseParams());
        parameters.putAll(browseParams.getControlParameters());
        parameters.put("offset", String.valueOf(offSet + this.DEFAULT_PAGE_SIZE));
        String url = SearchFacetFilter.generateURL((String)"search-filter", parameters);
        url = this.addFilterQueriesToUrl(url);
        return url;
    }

    private String getPreviousPageURL(SearchFilterParam browseParams, Request request) {
        if ("0".equals(this.queryArgs.get("facet.offset")) && Util.getIntParameter((HttpServletRequest)request, (String)"offset") == -1) {
            return null;
        }
        int offset = Util.getIntParameter((HttpServletRequest)request, (String)"offset");
        if (offset == -1 || offset == 0) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(browseParams.getCommonBrowseParams());
        parameters.putAll(browseParams.getControlParameters());
        parameters.put("offset", String.valueOf(offset - this.DEFAULT_PAGE_SIZE));
        String url = SearchFacetFilter.generateURL((String)"search-filter", parameters);
        url = this.addFilterQueriesToUrl(url);
        return url;
    }

    public void recycle() {
        this.queryResults = null;
        this.validity = null;
        super.recycle();
    }

    public String addFilterQueriesToUrl(String url) {
        String[] fqs = this.getParameterFilterQueries();
        if (fqs != null) {
            StringBuilder urlBuilder = new StringBuilder(url);
            for (String fq : fqs) {
                urlBuilder.append("&fq=").append(fq);
            }
            return urlBuilder.toString();
        }
        return url;
    }

    private String[] getParameterFilterQueries() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        return request.getParameterValues("fq") != null ? request.getParameterValues("fq") : new String[]{};
    }

    private static class SearchFilterParam {
        private Request request;
        public static final String FACET_FIELD = "field";
        public static final String OFFSET = "offset";
        public static final String STARTS_WITH = "starts_with";

        private SearchFilterParam(Request request) {
            this.request = request;
        }

        public String getFacetField() {
            return this.request.getParameter(FACET_FIELD);
        }

        public Map<String, String> getCommonBrowseParams() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(FACET_FIELD, this.request.getParameter(FACET_FIELD));
            return result;
        }

        public Map<String, String> getControlParameters() {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put(OFFSET, this.request.getParameter(OFFSET));
            if (this.request.getParameter(STARTS_WITH) != null) {
                paramMap.put(STARTS_WITH, this.request.getParameter(STARTS_WITH));
            }
            return paramMap;
        }
    }
}

