/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.SolrServiceImpl;
import org.dspace.handle.HandleManager;
import org.dspace.kernel.ServiceManager;
import org.dspace.utils.DSpace;
import org.xml.sax.SAXException;

public abstract class AbstractFiltersTransformer
extends AbstractDSpaceTransformer {
    private static final Logger log = Logger.getLogger(AbstractFiltersTransformer.class);
    protected QueryResponse queryResults;
    protected SolrQuery queryArgs;
    protected SourceValidity validity;
    private static final Message T_FILTER_HEAD = AbstractFiltersTransformer.message((String)"xmlui.discovery.AbstractFiltersTransformer.filters.head");
    private static final Message T_VIEW_MORE = AbstractFiltersTransformer.message((String)"xmlui.discovery.AbstractFiltersTransformer.filters.view-more");

    public abstract String getView();

    protected SearchService getSearchService() {
        DSpace dspace = new DSpace();
        ServiceManager manager = dspace.getServiceManager();
        return (SearchService)manager.getServiceByName(SearchService.class.getName(), SearchService.class);
    }

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                DSpaceValidity val = new DSpaceValidity();
                this.performSearch(dso);
                if (dso != null) {
                    val.add(dso);
                }
                val.add("numFound:" + this.queryResults.getResults().getNumFound());
                for (SolrDocument doc : this.queryResults.getResults()) {
                    val.add(doc.toString());
                }
                for (SolrDocument doc : this.queryResults.getResults()) {
                    val.add(doc.toString());
                }
                for (FacetField field : this.queryResults.getFacetFields()) {
                    val.add(field.getName());
                    for (FacetField.Count count : field.getValues()) {
                        val.add(count.getName() + count.getCount());
                    }
                }
                this.validity = val.complete();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.validity;
    }

    public abstract void performSearch(DSpaceObject var1) throws SearchServiceException, UIException;

    protected DSpaceObject getScope() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String scopeString = request.getParameter("scope");
        DSpaceObject dso = scopeString == null || "".equals(scopeString) ? HandleUtil.obtainHandle((Map)this.objectModel) : HandleManager.resolveToObject((Context)this.context, (String)scopeString);
        return dso;
    }

    protected SolrQuery prepareDefaultFilters(String scope, String ... filterQueries) {
        this.queryArgs = new SolrQuery();
        SearchUtils.SolrFacetConfig[] facets = SearchUtils.getFacetsForType((String)scope);
        log.info((Object)("facets for scope, " + scope + ": " + (facets != null ? Integer.valueOf(facets.length) : null)));
        int max = 10;
        try {
            max = SearchUtils.getConfig().getInteger("search.facet.max");
        }
        catch (Exception e) {
            // empty catch block
        }
        ++max;
        if (facets != null) {
            this.queryArgs.setFacetLimit(max);
            this.queryArgs.setFacetMinCount(1);
            this.queryArgs.setFacet(true);
        }
        if (facets != null) {
            for (SearchUtils.SolrFacetConfig facet : facets) {
                if (facet.isDate()) {
                    String dateFacet = facet.getFacetField();
                    try {
                        int oldestYear = -1;
                        int newestYear = -1;
                        for (String filterQuery : filterQueries) {
                            if (!filterQuery.startsWith(facet.getFacetField() + ":")) continue;
                            Pattern pattern = Pattern.compile("\\[(.*? TO .*?)\\]");
                            Matcher matcher = pattern.matcher(filterQuery);
                            boolean hasPattern = matcher.find();
                            if (hasPattern) {
                                filterQuery = matcher.group(0);
                                int tempOldYear = Integer.parseInt(filterQuery.split(" TO ")[0].replace("[", "").trim());
                                int tempNewYear = Integer.parseInt(filterQuery.split(" TO ")[1].replace("]", "").trim());
                                if (tempNewYear >= newestYear && oldestYear >= tempOldYear && newestYear != -1) continue;
                                oldestYear = tempOldYear;
                                newestYear = tempNewYear;
                                continue;
                            }
                            if (filterQuery.indexOf(" OR ") != -1) {
                                filterQuery = filterQuery.split(" OR ")[0];
                            }
                            newestYear = oldestYear = Integer.parseInt(filterQuery.split(":")[1].trim());
                            break;
                        }
                        if (oldestYear == -1 && newestYear == -1) {
                            SolrQuery yearRangeQuery = new SolrQuery();
                            yearRangeQuery.setRows(Integer.valueOf(1));
                            yearRangeQuery.setQuery(facet.getFacetField() + ":[* TO *]");
                            yearRangeQuery.setSortField(dateFacet, SolrQuery.ORDER.asc);
                            yearRangeQuery.addFilterQuery(filterQueries);
                            QueryResponse lastYearResult = this.getSearchService().search(yearRangeQuery);
                            if (lastYearResult.getResults() != null && 0 < lastYearResult.getResults().size() && ((SolrDocument)lastYearResult.getResults().get(0)).getFieldValue(dateFacet) != null) {
                                oldestYear = (Integer)((SolrDocument)lastYearResult.getResults().get(0)).get((Object)dateFacet);
                            }
                            yearRangeQuery.setSortField(dateFacet, SolrQuery.ORDER.desc);
                            QueryResponse firstYearResult = this.getSearchService().search(yearRangeQuery);
                            if (firstYearResult.getResults() != null && 0 < firstYearResult.getResults().size() && ((SolrDocument)firstYearResult.getResults().get(0)).getFieldValue(dateFacet) != null) {
                                newestYear = (Integer)((SolrDocument)firstYearResult.getResults().get(0)).get((Object)dateFacet);
                            }
                            if (newestYear == -1 || oldestYear == -1) continue;
                        }
                        int gap = 1;
                        int yearDifference = newestYear - oldestYear;
                        if (yearDifference != 0) {
                            while (10.0 < (double)yearDifference / (double)gap) {
                                gap *= 10;
                            }
                        }
                        int topYear = (int)(Math.ceil((float)newestYear / (float)gap) * (double)gap);
                        if (gap == 1) {
                            this.queryArgs.addFacetField(new String[]{facet.getFacetField()});
                            continue;
                        }
                        ArrayList<String> facetQueries = new ArrayList<String>();
                        for (int year = topYear; year > oldestYear && facetQueries.size() < max; year -= gap) {
                            int bottomYear = year - gap;
                            if (bottomYear < oldestYear) {
                                bottomYear = oldestYear;
                            }
                            int currentTop = year;
                            currentTop = year == topYear ? newestYear : --currentTop;
                            facetQueries.add(dateFacet + ":[" + bottomYear + " TO " + currentTop + "]");
                        }
                        for (String facetQuery : facetQueries) {
                            this.queryArgs.addFacetQuery(facetQuery);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)LogManager.getHeader((Context)this.context, (String)"Error in discovery while setting up date facet range", (String)("date facet: " + dateFacet)), (Throwable)e);
                        continue;
                    }
                }
                this.queryArgs.addFacetField(new String[]{facet.getFacetField()});
            }
        }
        this.queryArgs.addFilterQuery(SearchUtils.getDefaultFilters((String)scope));
        return this.queryArgs;
    }

    /*
     * Could not resolve type clashes
     */
    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        SearchUtils.SolrFacetConfig[] facets;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        List<String> fqs = Arrays.asList(request.getParameterValues("fq") != null ? request.getParameterValues("fq") : new String[]{});
        if (this.queryResults != null && (facets = SearchUtils.getFacetsForType((String)this.getView())) != null && 0 < facets.length) {
            org.dspace.app.xmlui.wing.element.List browse = options.addList("discovery");
            browse.setHead(T_FILTER_HEAD);
            for (SearchUtils.SolrFacetConfig field : facets) {
                List<Object> values = new ArrayList<FilterDisplayValue>();
                int shownFacets = this.queryArgs.getFacetLimit();
                FacetField facet = this.queryResults.getFacetField(field.getFacetField());
                if (facet != null) {
                    List facetVals = facet.getValues();
                    if (facetVals == null) continue;
                    for (FacetField.Count count : facetVals) {
                        values.add(new FilterDisplayValue(SearchUtils.getFilterQueryDisplay((String)count.getName()), count.getCount(), count.getAsFilterQuery()));
                    }
                }
                if (field.isDate()) {
                    if (0 < values.size()) {
                        TreeMap sortedVals = new TreeMap(Collections.reverseOrder());
                        for (FilterDisplayValue filterDisplayValue : values) {
                            if (0L >= filterDisplayValue.getCount()) continue;
                            sortedVals.put(filterDisplayValue.getDisplayedVal(), filterDisplayValue);
                        }
                        values = Arrays.asList(sortedVals.values().toArray(new FilterDisplayValue[sortedVals.size()]));
                    } else {
                        TreeMap sortedFacetQueries = new TreeMap(this.queryResults.getFacetQuery());
                        for (String facetQuery : sortedFacetQueries.descendingKeySet()) {
                            if (facetQuery == null || !facetQuery.startsWith(field.getFacetField())) continue;
                            String name = facetQuery.substring(facetQuery.indexOf(91) + 1);
                            name = name.substring(0, name.lastIndexOf(93)).replaceAll("TO", "-");
                            Integer count = (Integer)sortedFacetQueries.get(facetQuery);
                            if (0 >= count) continue;
                            values.add(new FilterDisplayValue(name, count.intValue(), facetQuery));
                        }
                    }
                }
                if (0 >= values.size()) continue;
                Iterator iter = values.iterator();
                org.dspace.app.xmlui.wing.element.List filterValsList = browse.addList(field.getFacetField());
                filterValsList.setHead(AbstractFiltersTransformer.message((String)("xmlui.ArtifactBrowser.AdvancedSearch.type_" + field.getFacetField().replace("_lc", ""))));
                for (int i = 0; i < shownFacets && iter.hasNext(); ++i) {
                    FilterDisplayValue value = (FilterDisplayValue)iter.next();
                    if (i < shownFacets - 1) {
                        String displayedValue = value.getDisplayedVal();
                        String filterQuery = value.getAsFilterQuery();
                        if (field.getFacetField().equals("location.comm") || field.getFacetField().equals("location.coll")) {
                            displayedValue = SolrServiceImpl.locationToName((Context)this.context, (String)field.getFacetField(), (String)displayedValue);
                        }
                        if (fqs.contains(filterQuery)) {
                            filterValsList.addItem(Math.random() + "", "selected").addContent(displayedValue + " (" + value.getCount() + ")");
                        } else {
                            String paramsQuery = "";
                            Enumeration keys = request.getParameterNames();
                            if (keys != null) {
                                while (keys.hasMoreElements()) {
                                    String[] vals;
                                    String key = (String)keys.nextElement();
                                    if (key == null || "page".equals(key)) continue;
                                    for (String paramValue : vals = request.getParameterValues(key)) {
                                        paramsQuery = paramsQuery + key + "=" + paramValue;
                                        paramsQuery = paramsQuery + "&";
                                    }
                                }
                            }
                            filterValsList.addItem().addXref(this.contextPath + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/discover?" + paramsQuery + "fq=" + filterQuery, displayedValue + " (" + value.getCount() + ")");
                        }
                    }
                    if (i != shownFacets - 1 || field.isDate()) continue;
                    this.addViewMoreUrl(filterValsList, dso, request, field.getFacetField());
                }
            }
        }
    }

    private void addViewMoreUrl(org.dspace.app.xmlui.wing.element.List facet, DSpaceObject dso, Request request, String fieldName) throws WingException {
        facet.addItem().addXref(this.contextPath + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/search-filter?" + "field" + "=" + fieldName + (request.getQueryString() != null ? "&" + request.getQueryString() : ""), T_VIEW_MORE);
    }

    public void recycle() {
        this.queryResults = null;
        this.queryArgs = null;
    }

    private static final class FilterDisplayValue {
        private String asFilterQuery;
        private String displayedVal;
        private long count;

        private FilterDisplayValue(String displayedVal, long count, String asFilterQuery) {
            this.asFilterQuery = asFilterQuery;
            this.displayedVal = displayedVal;
            this.count = count;
        }

        public String getDisplayedVal() {
            return this.displayedVal;
        }

        public long getCount() {
            return this.count;
        }

        public String getAsFilterQuery() {
            return this.asFilterQuery;
        }
    }
}

