/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.dspace.app.xmlui.aspect.discovery.AbstractFiltersTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.xml.sax.SAXException;

public class RelatedItems
extends AbstractFiltersTransformer {
    private static final Logger log = Logger.getLogger(RelatedItems.class);

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        NamedList nList;
        SimpleOrderedMap mlt;
        DSpaceObject dspaceObject = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dspaceObject instanceof Item)) {
            return;
        }
        Item item = (Item)dspaceObject;
        try {
            this.performSearch((DSpaceObject)item);
        }
        catch (SearchServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.queryResults != null && (mlt = (SimpleOrderedMap)(nList = this.queryResults.getResponse()).get("moreLikeThis")) != null && 0 < mlt.size()) {
            ArrayList<DSpaceObject> dsos = new ArrayList<DSpaceObject>();
            for (Map.Entry entry : mlt) {
                for (SolrDocument doc : (SolrDocumentList)entry.getValue()) {
                    try {
                        dsos.add(SearchUtils.findDSpaceObject((Context)this.context, (SolrDocument)doc));
                    }
                    catch (Exception e) {
                        log.error((Object)LogManager.getHeader((Context)this.context, (String)"Error while resolving related item doc to dso", (String)("Main item: " + item.getID())));
                    }
                }
            }
            if (0 < dsos.size()) {
                Division home = body.addDivision("test", "secondary related");
                String name = "Related Items";
                home.setHead(name);
                Division mltDiv = home.addDivision("item-related", "secondary related");
                mltDiv.setHead("Items By Author:");
                ReferenceSet set = mltDiv.addReferenceSet("item-related-items", "summaryList", null, "related-items");
                for (DSpaceObject dso : dsos) {
                    set.addReference((Object)dso);
                }
            }
        }
    }

    @Override
    public void performSearch(DSpaceObject dso) throws SearchServiceException {
        if (this.queryResults != null) {
            return;
        }
        this.queryArgs = this.prepareDefaultFilters(this.getView(), new String[0]);
        this.queryArgs.setRows(Integer.valueOf(1));
        this.queryArgs.add("fl", new String[]{"dc.contributor,dc.contributor.author,handle"});
        this.queryArgs.add("mlt", new String[]{"true"});
        this.queryArgs.add("mlt.fl", new String[]{"dc.contributor,dc.contributor.author,handle"});
        this.queryArgs.add("mlt.mindf", new String[]{"1"});
        this.queryArgs.add("mlt.mintf", new String[]{"1"});
        this.queryArgs.setQuery("handle:" + dso.getHandle());
        this.queryArgs.setRows(Integer.valueOf(1));
        this.queryResults = this.getSearchService().search(this.queryArgs);
    }

    @Override
    public String getView() {
        return "item";
    }

    @Override
    public void recycle() {
        this.queryArgs = null;
        this.queryResults = null;
        super.recycle();
    }
}

