/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrDocument;
import org.dspace.app.xmlui.aspect.discovery.AbstractFiltersTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.xml.sax.SAXException;

public class SiteRecentSubmissions
extends AbstractFiltersTransformer {
    private static final Logger log = Logger.getLogger(SiteRecentSubmissions.class);
    private static final Message T_head_recent_submissions = SiteRecentSubmissions.message((String)"xmlui.ArtifactBrowser.SiteViewer.head_recent_submissions");

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        try {
            this.performSearch(null);
        }
        catch (SearchServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        Division home = body.addDivision("site-home", "primary repository");
        Division lastSubmittedDiv = home.addDivision("site-recent-submission", "secondary recent-submission");
        lastSubmittedDiv.setHead(T_head_recent_submissions);
        ReferenceSet lastSubmitted = lastSubmittedDiv.addReferenceSet("site-last-submitted", "summaryList", null, "recent-submissions");
        if (this.queryResults != null) {
            for (SolrDocument doc : this.queryResults.getResults()) {
                DSpaceObject obj = SearchUtils.findDSpaceObject((Context)this.context, (SolrDocument)doc);
                if (obj == null) continue;
                lastSubmitted.addReference((Object)obj);
            }
        }
    }

    @Override
    public String getView() {
        return "site";
    }

    @Override
    public void performSearch(DSpaceObject object) throws SearchServiceException, UIException {
        if (this.queryResults != null) {
            return;
        }
        this.queryArgs = this.prepareDefaultFilters(this.getView(), new String[0]);
        this.queryArgs.setQuery("search.resourcetype:2");
        this.queryArgs.setRows(Integer.valueOf(SearchUtils.getConfig().getInt("solr.recent-submissions.size", 5)));
        String sortField = SearchUtils.getConfig().getString("recent.submissions.sort-option");
        if (sortField != null) {
            this.queryArgs.setSortField(sortField, SolrQuery.ORDER.desc);
        }
        SearchService service = this.getSearchService();
        this.queryResults = service.search(this.queryArgs);
    }
}

