/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.handle.HandleManager;
import org.xml.sax.SAXException;

public abstract class AbstractSearch
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(AbstractSearch.class);
    private static final Message T_head1_community = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head1_community");
    private static final Message T_head1_collection = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head1_collection");
    private static final Message T_head1_none = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head1_none");
    private static final Message T_head2 = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head2");
    private static final Message T_no_results = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.no_results");
    private static final Message T_all_of_dspace = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.all_of_dspace");
    private static final Message T_sort_by_relevance = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.sort_by.relevance");
    private static final Message T_sort_by = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.sort_by");
    private static final Message T_order = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.order");
    private static final Message T_order_asc = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.order.asc");
    private static final Message T_order_desc = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.order.desc");
    private static final Message T_rpp = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.rpp");
    private static final Message T_sort_head = AbstractSearch.message((String)"xmlui.Discovery.SimpleSearch.sort_head");
    private static final Message T_sort_button = AbstractSearch.message((String)"xmlui.Discovery.SimpleSearch.sort_apply");
    protected DiscoverResult queryResults;
    protected DiscoverQuery queryArgs;
    private static final int[] RESULTS_PER_PAGE_PROGRESSION = new int[]{5, 10, 20, 40, 60, 80, 100};
    private SourceValidity validity;

    public Serializable getKey() {
        try {
            String key = "";
            key = key + "-" + this.getParameterPage();
            key = key + "-" + this.getParameterRpp();
            key = key + "-" + this.getParameterSortBy();
            key = key + "-" + this.getParameterOrder();
            key = key + "-" + this.getParameterEtAl();
            DSpaceObject scope = this.getScope();
            if (scope != null) {
                key = key + "-" + scope.getHandle();
            }
            key = key + "-" + this.getQuery();
            return Long.valueOf(HashUtil.hash((String)key));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceValidity validity = new DSpaceValidity();
                DSpaceObject scope = this.getScope();
                validity.add(scope);
                this.performSearch(scope);
                List results = this.queryResults.getDspaceObjects();
                if (results != null) {
                    validity.add("total:" + this.queryResults.getTotalSearchResults());
                    validity.add("start:" + this.queryResults.getStart());
                    validity.add("size:" + results.size());
                    for (DSpaceObject dso : results) {
                        validity.add(dso);
                    }
                }
                Map facetResults = this.queryResults.getFacetResults();
                for (String facetField : facetResults.keySet()) {
                    List facetValues = (List)facetResults.get(facetField);
                    for (DiscoverResult.FacetResult facetResult : facetValues) {
                        validity.add(facetResult.getAsFilterQuery() + facetResult.getCount());
                    }
                }
                this.validity = validity.complete();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                this.validity = null;
            }
            this.logSearch();
        }
        return this.validity;
    }

    public abstract void addBody(Body var1) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException;

    protected void buildSearchResultsDivision(Division search) throws IOException, SQLException, WingException, SearchServiceException {
        try {
            if (this.queryResults == null) {
                DSpaceObject scope = this.getScope();
                this.performSearch(scope);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.queryResults = null;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.queryResults = null;
        }
        Division results = search.addDivision("search-results", "primary");
        DSpaceObject searchScope = this.getScope();
        if (searchScope instanceof Community) {
            Community community = (Community)searchScope;
            String communityName = community.getMetadata("name");
            results.setHead(T_head1_community.parameterize(new Object[]{communityName}));
        } else if (searchScope instanceof Collection) {
            Collection collection = (Collection)searchScope;
            String collectionName = collection.getMetadata("name");
            results.setHead(T_head1_collection.parameterize(new Object[]{collectionName}));
        } else {
            results.setHead(T_head1_none);
        }
        if (this.queryResults != null && 0 < this.queryResults.getDspaceObjects().size()) {
            int itemsTotal = (int)this.queryResults.getTotalSearchResults();
            int firstItemIndex = this.queryResults.getStart() + 1;
            int lastItemIndex = this.queryResults.getStart() + this.queryResults.getDspaceObjects().size();
            int currentPage = this.queryResults.getStart() / this.queryResults.getMaxResults() + 1;
            int pagesTotal = (int)((this.queryResults.getTotalSearchResults() - 1L) / (long)this.queryResults.getMaxResults()) + 1;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("page", "{pageNum}");
            String pageURLMask = this.generateURL(parameters);
            String[] fqs = this.getParameterFilterQueries();
            if (fqs != null) {
                StringBuilder maskBuilder = new StringBuilder(pageURLMask);
                for (String fq : fqs) {
                    maskBuilder.append("&fq=").append(fq);
                }
                pageURLMask = maskBuilder.toString();
            }
            results.setMaskedPagination(itemsTotal, firstItemIndex, lastItemIndex, currentPage, pagesTotal, pageURLMask);
            ReferenceSet referenceSet = null;
            for (DSpaceObject resultDso : this.queryResults.getDspaceObjects()) {
                if (!(resultDso instanceof Community) && !(resultDso instanceof Collection)) continue;
                if (referenceSet == null) {
                    referenceSet = results.addReferenceSet("search-results-repository", "summaryList", null, "repository-search-results");
                    referenceSet.setHead(T_head2);
                }
                if (resultDso == null) continue;
                referenceSet.addReference((Object)resultDso);
            }
            referenceSet = results.addReferenceSet("search-results-repository", "summaryList", null, "repository-search-results");
            for (DSpaceObject resultDso : this.queryResults.getDspaceObjects()) {
                if (!(resultDso instanceof org.dspace.content.Item)) continue;
                referenceSet.addReference((Object)resultDso);
            }
        } else {
            results.addPara(T_no_results);
        }
    }

    protected void buildScopeList(Select scope) throws SQLException, WingException {
        block4: {
            Community[] communities;
            DSpaceObject scopeDSO;
            block5: {
                block3: {
                    scopeDSO = this.getScope();
                    if (scopeDSO != null) break block3;
                    scope.addOption("/", T_all_of_dspace);
                    scope.setOptionSelected("/");
                    for (Community community : Community.findAllTop((Context)this.context)) {
                        scope.addOption(community.getHandle(), community.getMetadata("name"));
                    }
                    break block4;
                }
                if (!(scopeDSO instanceof Community)) break block5;
                Community community = (Community)scopeDSO;
                scope.addOption("/", T_all_of_dspace);
                scope.addOption(community.getHandle(), community.getMetadata("name"));
                scope.setOptionSelected(community.getHandle());
                for (Collection collection : community.getCollections()) {
                    scope.addOption(collection.getHandle(), collection.getMetadata("name"));
                }
                break block4;
            }
            if (!(scopeDSO instanceof Collection)) break block4;
            Collection collection = (Collection)scopeDSO;
            scope.addOption("/", T_all_of_dspace);
            scope.addOption(collection.getHandle(), collection.getMetadata("name"));
            scope.setOptionSelected(collection.getHandle());
            for (Community community : communities = collection.getCommunities()[0].getAllParents()) {
                scope.addOption(community.getHandle(), community.getMetadata("name"));
            }
        }
    }

    public void performSearch(DSpaceObject scope) throws UIException, SearchServiceException {
        String sortOrder;
        if (this.queryResults != null) {
            return;
        }
        String query = this.getQuery();
        int page = this.getParameterPage();
        ArrayList<String> filterQueries = new ArrayList<String>();
        String[] fqs = this.getFilterQueries();
        if (fqs != null) {
            filterQueries.addAll(Arrays.asList(fqs));
        }
        this.queryArgs = new DiscoverQuery();
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)scope);
        List defaultFilterQueries = discoveryConfiguration.getDefaultFilterQueries();
        this.queryArgs.addFilterQueries(defaultFilterQueries.toArray(new String[defaultFilterQueries.size()]));
        if (filterQueries.size() > 0) {
            this.queryArgs.addFilterQueries(filterQueries.toArray(new String[filterQueries.size()]));
        }
        this.queryArgs.setMaxResults(this.getParameterRpp());
        String sortBy = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("sort_by");
        DiscoverySortConfiguration searchSortConfiguration = discoveryConfiguration.getSearchSortConfiguration();
        if (sortBy == null) {
            sortBy = "score";
            if (searchSortConfiguration != null) {
                for (DiscoverySortFieldConfiguration sortFieldConfiguration : searchSortConfiguration.getSortFields()) {
                    if (!sortFieldConfiguration.equals((Object)searchSortConfiguration.getDefaultSort())) continue;
                    sortBy = SearchUtils.getSearchService().toSortFieldIndex(sortFieldConfiguration.getMetadataField(), sortFieldConfiguration.getType());
                }
            }
        }
        if ((sortOrder = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("order")) == null && searchSortConfiguration != null) {
            sortOrder = searchSortConfiguration.getDefaultSortOrder().toString();
        }
        if (sortOrder == null || sortOrder.equalsIgnoreCase("DESC")) {
            this.queryArgs.setSortField(sortBy, DiscoverQuery.SORT_ORDER.desc);
        } else {
            this.queryArgs.setSortField(sortBy, DiscoverQuery.SORT_ORDER.asc);
        }
        String groupBy = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("group_by");
        if (groupBy != null && !groupBy.equalsIgnoreCase("none")) {
            this.queryArgs.addProperty("collapse.field", groupBy);
            this.queryArgs.addProperty("collapse.threshold", "1");
            this.queryArgs.addProperty("collapse.includeCollapsedDocs.fl", "handle");
            this.queryArgs.addProperty("collapse.facet", "before");
            this.queryArgs.setSortField("dc.type", DiscoverQuery.SORT_ORDER.asc);
        }
        this.queryArgs.setQuery(query != null && !query.trim().equals("") ? query : null);
        if (page > 1) {
            this.queryArgs.setStart((page - 1) * this.queryArgs.getMaxResults());
        } else {
            this.queryArgs.setStart(0);
        }
        this.queryResults = SearchUtils.getSearchService().search(this.context, scope, this.queryArgs);
    }

    protected String[] getParameterFilterQueries() {
        try {
            return ObjectModelHelper.getRequest((Map)this.objectModel).getParameterValues("fq");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String[] getFilterQueries() {
        try {
            return ObjectModelHelper.getRequest((Map)this.objectModel).getParameterValues("fq");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String[] getFacetsList() {
        try {
            return ObjectModelHelper.getRequest((Map)this.objectModel).getParameterValues("fl");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected int getParameterPage() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("page"));
        }
        catch (Exception e) {
            return 1;
        }
    }

    protected int getParameterRpp() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("rpp"));
        }
        catch (Exception e) {
            return 10;
        }
    }

    protected String getParameterSortBy() {
        String s = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("sort_by");
        return s != null ? s : null;
    }

    protected String getParameterGroup() {
        String s = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("group_by");
        return s != null ? s : "none";
    }

    protected String getParameterOrder() {
        return ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("order");
    }

    protected String getParameterScope() {
        return ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("scope");
    }

    protected int getParameterEtAl() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("etal"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected boolean variableScope() throws SQLException {
        return HandleUtil.obtainHandle((Map)this.objectModel) == null;
    }

    protected abstract String getQuery() throws UIException;

    protected abstract String generateURL(Map<String, String> var1) throws UIException;

    public void recycle() {
        this.queryArgs = null;
        this.queryResults = null;
        this.validity = null;
        super.recycle();
    }

    protected void buildSearchControls(Division div) throws WingException, SQLException {
        org.dspace.app.xmlui.wing.element.List controlsList = div.addList("search-controls", "form");
        controlsList.setHead(T_sort_head);
        Item controlsItem = controlsList.addItem();
        controlsItem.addContent(T_rpp);
        Select rppSelect = controlsItem.addSelect("rpp");
        for (int i : RESULTS_PER_PAGE_PROGRESSION) {
            rppSelect.addOption(i == this.getParameterRpp(), i, Integer.toString(i));
        }
        controlsItem.addContent(T_sort_by);
        Select sortSelect = controlsItem.addSelect("sort_by");
        sortSelect.addOption(false, "score", T_sort_by_relevance);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)dso);
        DiscoverySortConfiguration searchSortConfiguration = discoveryConfiguration.getSearchSortConfiguration();
        if (searchSortConfiguration != null) {
            for (DiscoverySortFieldConfiguration sortFieldConfiguration : searchSortConfiguration.getSortFields()) {
                String currentSort;
                String sortField = SearchUtils.getSearchService().toSortFieldIndex(sortFieldConfiguration.getMetadataField(), sortFieldConfiguration.getType());
                sortSelect.addOption(sortField.equals(currentSort = this.getParameterSortBy()) || sortFieldConfiguration.equals((Object)searchSortConfiguration.getDefaultSort()), sortField, AbstractSearch.message((String)("xmlui.ArtifactBrowser.AbstractSearch.sort_by." + sortField)));
            }
        }
        controlsItem.addContent(T_order);
        Select orderSelect = controlsItem.addSelect("order");
        String parameterOrder = this.getParameterOrder();
        if (parameterOrder == null && searchSortConfiguration != null) {
            parameterOrder = searchSortConfiguration.getDefaultSortOrder().toString();
        }
        orderSelect.addOption("ASC".equalsIgnoreCase(parameterOrder), "ASC", T_order_asc);
        orderSelect.addOption("DESC".equalsIgnoreCase(parameterOrder), "DESC", T_order_desc);
        controlsItem.addButton("submit_sort").setValue(T_sort_button);
    }

    protected DSpaceObject getScope() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String scopeString = request.getParameter("scope");
        DSpaceObject dso = scopeString == null || "".equals(scopeString) ? HandleUtil.obtainHandle((Map)this.objectModel) : HandleManager.resolveToObject((Context)this.context, (String)scopeString);
        return dso;
    }

    protected void logSearch() {
        int countCommunities = 0;
        int countCollections = 0;
        int countItems = 0;
        String logInfo = "";
        try {
            DSpaceObject dsoScope = this.getScope();
            if (dsoScope instanceof Collection) {
                logInfo = "collection_id=" + dsoScope.getID() + ",";
            } else if (dsoScope instanceof Community) {
                logInfo = "community_id=" + dsoScope.getID() + ",";
            }
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        log.info((Object)LogManager.getHeader((Context)this.context, (String)"search", (String)(logInfo + "query=\"" + (this.queryArgs == null ? "" : this.queryArgs.getQuery()) + "\",results=(" + countCommunities + "," + countCollections + "," + countItems + ")")));
    }
}

