/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.SidebarFacetConfiguration;
import org.dspace.handle.HandleManager;
import org.dspace.kernel.ServiceManager;
import org.dspace.utils.DSpace;
import org.xml.sax.SAXException;

public class SidebarFacetsTransformer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(SidebarFacetsTransformer.class);
    protected DiscoverResult queryResults;
    protected DiscoverQuery queryArgs;
    protected SourceValidity validity;
    private static final Message T_FILTER_HEAD = SidebarFacetsTransformer.message((String)"xmlui.discovery.AbstractFiltersTransformer.filters.head");
    private static final Message T_VIEW_MORE = SidebarFacetsTransformer.message((String)"xmlui.discovery.AbstractFiltersTransformer.filters.view-more");

    protected SearchService getSearchService() {
        DSpace dspace = new DSpace();
        ServiceManager manager = dspace.getServiceManager();
        return (SearchService)manager.getServiceByName(SearchService.class.getName(), SearchService.class);
    }

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso != null) {
                return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
            }
            return "0";
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                DSpaceValidity val = new DSpaceValidity();
                this.performSearch();
                if (dso != null) {
                    val.add(dso);
                }
                val.add("numFound:" + this.queryResults.getDspaceObjects().size());
                for (DSpaceObject resultDso : this.queryResults.getDspaceObjects()) {
                    val.add(resultDso);
                }
                for (String facetField : this.queryResults.getFacetResults().keySet()) {
                    val.add(facetField);
                    List facetValues = (List)this.queryResults.getFacetResults().get(facetField);
                    for (DiscoverResult.FacetResult facetValue : facetValues) {
                        val.add(facetValue.getAsFilterQuery() + facetValue.getCount());
                    }
                }
                this.validity = val.complete();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.validity;
    }

    public void performSearch() throws SearchServiceException, UIException, SQLException {
        DSpaceObject dso = this.getScope();
        this.queryArgs = this.getQueryArgs(this.context, dso, this.getAllFilterQueries());
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String query = request.getParameter("query");
        if (query != null && !"".equals(query)) {
            this.queryArgs.setQuery(query);
        }
        this.queryArgs.setMaxResults(0);
        this.queryResults = this.getSearchService().search(this.context, dso, this.queryArgs);
    }

    public void addOptions(Options options) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        try {
            this.performSearch();
        }
        catch (Exception e) {
            log.error((Object)"Error while searching for sidebar facets", (Throwable)e);
            return;
        }
        if (this.queryResults != null) {
            DiscoveryConfiguration discoveryConfiguration;
            List facets;
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            ArrayList<String> fqs = new ArrayList<String>();
            if (request.getParameterValues("fq") != null) {
                for (int i = 0; i < request.getParameterValues("fq").length; ++i) {
                    String fq = request.getParameterValues("fq")[i];
                    fqs.add(this.getSearchService().toFilterQuery(this.context, fq).getFilterQuery());
                }
            }
            if ((facets = (discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)dso)).getSidebarFacets()) != null && 0 < facets.size()) {
                org.dspace.app.xmlui.wing.element.List browse = options.addList("discovery");
                browse.setHead(T_FILTER_HEAD);
                for (SidebarFacetConfiguration field : facets) {
                    List facetValues = this.queryResults.getFacetResult(field.getIndexFieldName());
                    if (facetValues.size() == 0 && field.getType().equals("date")) {
                        facetValues = this.queryResults.getFacetResult(field.getIndexFieldName() + ".year");
                    }
                    int shownFacets = field.getFacetLimit() + 1;
                    if (facetValues == null || 0 >= facetValues.size()) continue;
                    Iterator iter = facetValues.iterator();
                    org.dspace.app.xmlui.wing.element.List filterValsList = browse.addList(field.getIndexFieldName());
                    filterValsList.setHead(SidebarFacetsTransformer.message((String)("xmlui.ArtifactBrowser.AdvancedSearch.type_" + field.getIndexFieldName())));
                    for (int i = 0; i < shownFacets && iter.hasNext(); ++i) {
                        DiscoverResult.FacetResult value = (DiscoverResult.FacetResult)iter.next();
                        if (i < shownFacets - 1) {
                            String displayedValue = value.getDisplayedValue();
                            String filterQuery = value.getAsFilterQuery();
                            if (fqs.contains(filterQuery)) {
                                filterValsList.addItem(Math.random() + "", "selected").addContent(displayedValue + " (" + value.getCount() + ")");
                            } else {
                                String paramsQuery = this.retrieveParameters(request);
                                filterValsList.addItem().addXref(this.contextPath + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/discover?" + paramsQuery + "fq=" + filterQuery, displayedValue + " (" + value.getCount() + ")");
                            }
                        }
                        if (i != shownFacets - 1 || field.getType().equals("date")) continue;
                        this.addViewMoreUrl(filterValsList, dso, request, field.getIndexFieldName());
                    }
                }
            }
        }
    }

    private String retrieveParameters(Request request) {
        StringBuffer result = new StringBuffer();
        Enumeration keys = request.getParameterNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String[] vals;
                String key = (String)keys.nextElement();
                if (key == null || "page".equals(key) || key.startsWith("submit")) continue;
                for (String paramValue : vals = request.getParameterValues(key)) {
                    result.append(key).append("=").append(paramValue);
                    result.append("&");
                }
            }
        }
        return result.toString();
    }

    private void addViewMoreUrl(org.dspace.app.xmlui.wing.element.List facet, DSpaceObject dso, Request request, String fieldName) throws WingException {
        String parameters = this.retrieveParameters(request);
        facet.addItem().addXref(this.contextPath + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/search-filter?" + parameters + "field" + "=" + fieldName, T_VIEW_MORE);
    }

    public DiscoverQuery getQueryArgs(Context context, DSpaceObject scope, String ... filterQueries) {
        DiscoverQuery queryArgs = new DiscoverQuery();
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)scope);
        List facets = discoveryConfiguration.getSidebarFacets();
        log.info((Object)("facets for scope, " + scope + ": " + (facets != null ? Integer.valueOf(facets.size()) : null)));
        if (facets != null) {
            queryArgs.setFacetMinCount(1);
        }
        queryArgs.addFilterQueries(discoveryConfiguration.getDefaultFilterQueries().toArray(new String[discoveryConfiguration.getDefaultFilterQueries().size()]));
        queryArgs.addFilterQueries(filterQueries);
        if (facets != null) {
            for (SidebarFacetConfiguration facet : facets) {
                if (facet.getType().equals("date")) {
                    String dateFacet = facet.getIndexFieldName() + ".year";
                    try {
                        int oldestYear = -1;
                        int newestYear = -1;
                        for (String filterQuery : filterQueries) {
                            if (!filterQuery.startsWith(dateFacet + ":")) continue;
                            Pattern pattern = Pattern.compile("\\[(.*? TO .*?)\\]");
                            Matcher matcher = pattern.matcher(filterQuery);
                            boolean hasPattern = matcher.find();
                            if (hasPattern) {
                                filterQuery = matcher.group(0);
                                int tempOldYear = Integer.parseInt(filterQuery.split(" TO ")[0].replace("[", "").trim());
                                int tempNewYear = Integer.parseInt(filterQuery.split(" TO ")[1].replace("]", "").trim());
                                if (tempNewYear >= newestYear && oldestYear >= tempOldYear && newestYear != -1) continue;
                                oldestYear = tempOldYear;
                                newestYear = tempNewYear;
                                continue;
                            }
                            if (filterQuery.indexOf(" OR ") != -1) {
                                filterQuery = filterQuery.split(" OR ")[0];
                            }
                            newestYear = oldestYear = Integer.parseInt(filterQuery.split(":")[1].trim());
                            break;
                        }
                        if (oldestYear == -1 && newestYear == -1) {
                            List searchDocuments;
                            List searchDocuments2;
                            DiscoverQuery yearRangeQuery = new DiscoverQuery();
                            yearRangeQuery.setMaxResults(1);
                            yearRangeQuery.addFieldPresentQueries(new String[]{dateFacet});
                            yearRangeQuery.setSortField(dateFacet + "_sort", DiscoverQuery.SORT_ORDER.asc);
                            yearRangeQuery.addFilterQueries(filterQueries);
                            yearRangeQuery.addSearchField(dateFacet);
                            DiscoverResult lastYearResult = this.getSearchService().search(context, scope, yearRangeQuery);
                            if (0 < lastYearResult.getDspaceObjects().size() && 0 < (searchDocuments2 = lastYearResult.getSearchDocument((DSpaceObject)lastYearResult.getDspaceObjects().get(0))).size() && 0 < ((DiscoverResult.SearchDocument)searchDocuments2.get(0)).getSearchFieldValues(dateFacet).size()) {
                                oldestYear = Integer.parseInt((String)((DiscoverResult.SearchDocument)searchDocuments2.get(0)).getSearchFieldValues(dateFacet).get(0));
                            }
                            yearRangeQuery.setSortField(dateFacet + "_sort", DiscoverQuery.SORT_ORDER.desc);
                            DiscoverResult firstYearResult = this.getSearchService().search(context, scope, yearRangeQuery);
                            if (0 < firstYearResult.getDspaceObjects().size() && 0 < (searchDocuments = firstYearResult.getSearchDocument((DSpaceObject)firstYearResult.getDspaceObjects().get(0))).size() && 0 < ((DiscoverResult.SearchDocument)searchDocuments.get(0)).getSearchFieldValues(dateFacet).size()) {
                                newestYear = Integer.parseInt((String)((DiscoverResult.SearchDocument)searchDocuments.get(0)).getSearchFieldValues(dateFacet).get(0));
                            }
                            if (newestYear == -1 || oldestYear == -1) continue;
                        }
                        int gap = 1;
                        int yearDifference = newestYear - oldestYear;
                        if (yearDifference != 0) {
                            while (10.0 < (double)yearDifference / (double)gap) {
                                gap *= 10;
                            }
                        }
                        int topYear = (int)(Math.ceil((float)newestYear / (float)gap) * (double)gap);
                        if (gap == 1) {
                            queryArgs.addFacetField(new DiscoverFacetField(facet.getIndexFieldName(), facet.getType(), 10, facet.getSortOrder()));
                            continue;
                        }
                        ArrayList<String> facetQueries = new ArrayList<String>();
                        for (int year = topYear; year > oldestYear && facetQueries.size() < 11; year -= gap) {
                            int bottomYear = year - gap;
                            if (bottomYear < oldestYear) {
                                bottomYear = oldestYear;
                            }
                            int currentTop = year;
                            currentTop = year == topYear ? newestYear : --currentTop;
                            facetQueries.add(dateFacet + ":[" + bottomYear + " TO " + currentTop + "]");
                        }
                        for (String facetQuery : facetQueries) {
                            queryArgs.addFacetQuery(facetQuery);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)LogManager.getHeader((Context)context, (String)"Error in discovery while setting up date facet range", (String)("date facet: " + dateFacet)), (Throwable)e);
                        continue;
                    }
                }
                int facetLimit = facet.getFacetLimit();
                queryArgs.addFacetField(new DiscoverFacetField(facet.getIndexFieldName(), "text", ++facetLimit, facet.getSortOrder()));
            }
        }
        return queryArgs;
    }

    protected String[] getAllFilterQueries() {
        try {
            ArrayList<String> allFilterQueries = new ArrayList<String>();
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            ArrayList<String> fqs = new ArrayList<String>();
            if (request.getParameterValues("fq") != null) {
                fqs.addAll(Arrays.asList(request.getParameterValues("fq")));
            }
            String type = request.getParameter("filtertype");
            String value = request.getParameter("filter");
            if (value != null && !value.equals("")) {
                allFilterQueries.add(this.getSearchService().toFilterQuery(this.context, type.equals("*") ? "" : type, value).getFilterQuery());
            }
            for (String fq : fqs) {
                allFilterQueries.add(this.getSearchService().toFilterQuery(this.context, fq).getFilterQuery());
            }
            return allFilterQueries.toArray(new String[allFilterQueries.size()]);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            return null;
        }
    }

    private DSpaceObject getScope() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String scopeString = request.getParameter("scope");
        DSpaceObject dso = scopeString == null || "".equals(scopeString) ? HandleUtil.obtainHandle((Map)this.objectModel) : HandleManager.resolveToObject((Context)this.context, (String)scopeString);
        return dso;
    }

    public void recycle() {
        this.queryResults = null;
        this.queryArgs = null;
        this.validity = null;
        super.recycle();
    }
}

