/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.aspect.discovery.BrowseFacet;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.RequestUtils;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.handle.HandleManager;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.xml.sax.SAXException;

public class SearchFacetFilter
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(BrowseFacet.class);
    private static final Message T_dspace_home = SearchFacetFilter.message((String)"xmlui.general.dspace_home");
    private static final Message T_starts_with = SearchFacetFilter.message((String)"xmlui.Discovery.AbstractSearch.startswith");
    private static final Message T_starts_with_help = SearchFacetFilter.message((String)"xmlui.Discovery.AbstractSearch.startswith.help");
    protected DiscoverResult queryResults;
    protected SourceValidity validity;
    protected DiscoverQuery queryArgs;
    private int DEFAULT_PAGE_SIZE = 10;
    private ConfigurationService config = null;
    private SearchService searchService = null;
    private static final Message T_go = SearchFacetFilter.message((String)"xmlui.general.go");

    public SearchFacetFilter() {
        DSpace dspace = new DSpace();
        this.config = dspace.getConfigurationService();
        this.searchService = (SearchService)dspace.getServiceManager().getServiceByName(SearchService.class.getName(), SearchService.class);
    }

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceValidity validity = new DSpaceValidity();
                DSpaceObject dso = this.getScope();
                if (dso != null) {
                    validity.add(dso);
                }
                DiscoverResult response = this.getQueryResponse(dso);
                validity.add("numFound:" + response.getDspaceObjects().size());
                for (DSpaceObject resultDso : this.queryResults.getDspaceObjects()) {
                    validity.add(resultDso);
                }
                for (String facetField : this.queryResults.getFacetResults().keySet()) {
                    validity.add(facetField);
                    List facetValues = (List)this.queryResults.getFacetResults().get(facetField);
                    for (DiscoverResult.FacetResult facetValue : facetValues) {
                        validity.add(facetValue.getAsFilterQuery() + facetValue.getCount());
                    }
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    protected DiscoverResult getQueryResponse(DSpaceObject scope) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (this.queryResults != null) {
            return this.queryResults;
        }
        this.queryArgs = new DiscoverQuery();
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)scope);
        List defaultFilterQueries = discoveryConfiguration.getDefaultFilterQueries();
        this.queryArgs.addFilterQueries(defaultFilterQueries.toArray(new String[defaultFilterQueries.size()]));
        this.queryArgs.setQuery(request.getParameter("query") != null && !"".equals(request.getParameter("query").trim()) ? request.getParameter("query") : null);
        this.queryArgs.setDSpaceObjectFilter(2);
        this.queryArgs.setMaxResults(0);
        this.queryArgs.addFilterQueries(this.getDiscoveryFilterQueries());
        this.queryArgs.setFacetMinCount(1);
        int offset = RequestUtils.getIntParameter((Request)request, (String)"offset");
        if (offset == -1) {
            offset = 0;
        }
        this.queryArgs.setFacetOffset(offset);
        String facetField = request.getParameter("field");
        DiscoverFacetField discoverFacetField = request.getParameter("starts_with") != null ? new DiscoverFacetField(facetField, "text", this.DEFAULT_PAGE_SIZE + 1, DiscoveryConfigurationParameters.SORT.VALUE, request.getParameter("starts_with").toLowerCase()) : new DiscoverFacetField(facetField, "text", this.DEFAULT_PAGE_SIZE + 1, DiscoveryConfigurationParameters.SORT.VALUE);
        this.queryArgs.addFacetField(discoverFacetField);
        try {
            this.queryResults = this.searchService.search(this.context, scope, this.queryArgs);
        }
        catch (SearchServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.queryResults;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String facetField = request.getParameter("field");
        pageMeta.addMetadata("title").addContent(SearchFacetFilter.message((String)("xmlui.Discovery.AbstractSearch.type_" + facetField)));
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso instanceof Collection || dso instanceof Community) {
            HandleUtil.buildHandleTrail((DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath);
        }
        pageMeta.addTrail().addContent(SearchFacetFilter.message((String)("xmlui.Discovery.AbstractSearch.type_" + facetField)));
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        SearchFilterParam browseParams = new SearchFilterParam(request);
        Division div = body.addDivision("browse-by-" + request.getParameter("field"), "primary");
        this.addBrowseJumpNavigation(div, browseParams, request);
        this.queryResults = this.getQueryResponse(dso);
        if (this.queryResults != null) {
            LinkedHashMap facetFields = this.queryResults.getFacetResults();
            if (facetFields == null) {
                facetFields = new LinkedHashMap();
            }
            if (facetFields.size() > 0) {
                String facetField = facetFields.keySet().toArray(new String[facetFields.size()])[0];
                List values = (List)facetFields.get(facetField);
                Division results = body.addDivision("browse-by-" + facetField + "-results", "primary");
                results.setHead(SearchFacetFilter.message((String)("xmlui.Discovery.AbstractSearch.type_" + browseParams.getFacetField())));
                if (values != null && 0 < values.size()) {
                    int end;
                    int offSet = this.queryArgs.getFacetOffset();
                    if (offSet == -1) {
                        offSet = 0;
                    }
                    String nextPageUrl = null;
                    if (values.size() == this.DEFAULT_PAGE_SIZE + 1) {
                        nextPageUrl = this.getNextPageURL(browseParams, request);
                    }
                    int shownItemsMax = offSet + (this.DEFAULT_PAGE_SIZE < values.size() ? values.size() - 1 : values.size());
                    results.setSimplePagination(-1, offSet + 1, shownItemsMax, this.getPreviousPageURL(browseParams, request), nextPageUrl);
                    Table singleTable = results.addTable("browse-by-" + facetField + "-results", this.queryResults.getDspaceObjects().size() + 1, 1);
                    ArrayList<String> filterQueries = new ArrayList();
                    if (request.getParameterValues("fq") != null) {
                        filterQueries = Arrays.asList(request.getParameterValues("fq"));
                    }
                    if (this.DEFAULT_PAGE_SIZE < (end = values.size())) {
                        end = this.DEFAULT_PAGE_SIZE;
                    }
                    for (int i = 0; i < end; ++i) {
                        DiscoverResult.FacetResult value = (DiscoverResult.FacetResult)values.get(i);
                        this.renderFacetField(browseParams, dso, facetField, singleTable, filterQueries, value);
                    }
                } else {
                    results.addPara(SearchFacetFilter.message((String)"xmlui.discovery.SearchFacetFilter.no-results"));
                }
            }
        }
    }

    private void addBrowseJumpNavigation(Division div, SearchFilterParam browseParams, Request request) throws WingException, SQLException {
        String[] filterQueries;
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        String action = dso != null ? this.contextPath + "/handle/" + dso.getHandle() + "/search-filter" : this.contextPath + "/search-filter";
        Division jump = div.addInteractiveDivision("filter-navigation", action, "post", "secondary navigation");
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(browseParams.getCommonBrowseParams());
        for (Map.Entry param : params.entrySet()) {
            jump.addHidden((String)param.getKey()).setValue((String)param.getValue());
        }
        for (String filterQuery : filterQueries = this.getParameterFilterQueries()) {
            jump.addHidden("fq").setValue(filterQuery);
        }
        if (!browseParams.getFacetField().endsWith(".year")) {
            org.dspace.app.xmlui.wing.element.List jumpList = jump.addList("jump-list", "simple", "alphabet");
            String basicUrl = SearchFacetFilter.generateURL((String)"search-filter", params);
            basicUrl = this.addFilterQueriesToUrl(basicUrl);
            for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                String linkUrl = basicUrl + "&" + "starts_with" + "=" + Character.toString(c).toLowerCase();
                jumpList.addItemXref(linkUrl, Character.toString(c));
            }
            Para jumpForm = jump.addPara();
            jumpForm.addContent(T_starts_with);
            jumpForm.addText("starts_with").setHelp(T_starts_with_help);
            jumpForm.addButton("submit").setValue(T_go);
        }
    }

    private void renderFacetField(SearchFilterParam browseParams, DSpaceObject dso, String facetField, Table singleTable, List<String> filterQueries, DiscoverResult.FacetResult value) throws SQLException, WingException, UnsupportedEncodingException {
        String displayedValue = value.getDisplayedValue();
        String filterQuery = value.getAsFilterQuery();
        Cell cell = singleTable.addRow().addCell();
        if (filterQueries.contains(filterQuery)) {
            cell.addContent(displayedValue + " (" + value.getCount() + ")");
        } else {
            HashMap<String, String> urlParams = new HashMap<String, String>();
            urlParams.putAll(browseParams.getCommonBrowseParams());
            String url = SearchFacetFilter.generateURL((String)(this.contextPath + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/discover"), urlParams);
            url = this.addFilterQueriesToUrl(url);
            url = url + "&fq=" + URLEncoder.encode(filterQuery, "UTF-8");
            cell.addXref(url, displayedValue + " (" + value.getCount() + ")");
        }
    }

    private String getNextPageURL(SearchFilterParam browseParams, Request request) {
        int offSet = Util.getIntParameter((HttpServletRequest)request, (String)"offset");
        if (offSet == -1) {
            offSet = 0;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(browseParams.getCommonBrowseParams());
        parameters.putAll(browseParams.getControlParameters());
        parameters.put("offset", String.valueOf(offSet + this.DEFAULT_PAGE_SIZE));
        String url = SearchFacetFilter.generateURL((String)"search-filter", parameters);
        url = this.addFilterQueriesToUrl(url);
        return url;
    }

    private String getPreviousPageURL(SearchFilterParam browseParams, Request request) {
        if (0 == this.queryArgs.getFacetOffset() && Util.getIntParameter((HttpServletRequest)request, (String)"offset") == -1) {
            return null;
        }
        int offset = Util.getIntParameter((HttpServletRequest)request, (String)"offset");
        if (offset == -1 || offset == 0) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(browseParams.getCommonBrowseParams());
        parameters.putAll(browseParams.getControlParameters());
        parameters.put("offset", String.valueOf(offset - this.DEFAULT_PAGE_SIZE));
        String url = SearchFacetFilter.generateURL((String)"search-filter", parameters);
        url = this.addFilterQueriesToUrl(url);
        return url;
    }

    public void recycle() {
        this.queryResults = null;
        this.validity = null;
        super.recycle();
    }

    public String addFilterQueriesToUrl(String url) {
        String[] fqs = this.getParameterFilterQueries();
        if (fqs != null) {
            StringBuilder urlBuilder = new StringBuilder(url);
            for (String fq : fqs) {
                urlBuilder.append("&fq=").append(fq);
            }
            return urlBuilder.toString();
        }
        return url;
    }

    protected String[] getParameterFilterQueries() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ArrayList<String> fqs = new ArrayList<String>();
        if (request.getParameterValues("fq") != null) {
            fqs.addAll(Arrays.asList(request.getParameterValues("fq")));
        }
        if (request.getParameter("filter") != null && !"".equals(request.getParameter("filter"))) {
            fqs.add((request.getParameter("filtertype").equals("*") ? "" : request.getParameter("filtertype") + ":") + request.getParameter("filter"));
        }
        return fqs.toArray(new String[fqs.size()]);
    }

    protected String[] getDiscoveryFilterQueries() {
        try {
            ArrayList<String> allFilterQueries = new ArrayList<String>();
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            ArrayList<String> fqs = new ArrayList<String>();
            if (request.getParameterValues("fq") != null) {
                fqs.addAll(Arrays.asList(request.getParameterValues("fq")));
            }
            String type = request.getParameter("filtertype");
            String value = request.getParameter("filter");
            if (value != null && !value.equals("")) {
                allFilterQueries.add(this.searchService.toFilterQuery(this.context, type.equals("*") ? "" : type, value).getFilterQuery());
            }
            for (String fq : fqs) {
                allFilterQueries.add(this.searchService.toFilterQuery(this.context, fq).getFilterQuery());
            }
            return allFilterQueries.toArray(new String[allFilterQueries.size()]);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            return null;
        }
    }

    private DSpaceObject getScope() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String scopeString = request.getParameter("scope");
        DSpaceObject dso = scopeString == null || "".equals(scopeString) ? HandleUtil.obtainHandle((Map)this.objectModel) : HandleManager.resolveToObject((Context)this.context, (String)scopeString);
        return dso;
    }

    private static class SearchFilterParam {
        private Request request;
        public static final String QUERY = "query";
        public static final String FACET_FIELD = "field";
        public static final String OFFSET = "offset";
        public static final String STARTS_WITH = "starts_with";

        private SearchFilterParam(Request request) {
            this.request = request;
        }

        public String getFacetField() {
            return this.request.getParameter(FACET_FIELD);
        }

        public Map<String, String> getCommonBrowseParams() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(FACET_FIELD, this.request.getParameter(FACET_FIELD));
            if (this.request.getParameter(QUERY) != null) {
                result.put(QUERY, this.request.getParameter(QUERY));
            }
            if (this.request.getParameter("scope") != null) {
                result.put("scope", this.request.getParameter("scope"));
            }
            return result;
        }

        public Map<String, String> getControlParameters() {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put(OFFSET, this.request.getParameter(OFFSET));
            if (this.request.getParameter(STARTS_WITH) != null) {
                paramMap.put(STARTS_WITH, this.request.getParameter(STARTS_WITH));
            }
            return paramMap;
        }
    }
}

