/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.service;

import java.util.UUID;
import org.dspace.app.iiif.service.utils.IIIFUtils;
import org.dspace.app.iiif.service.utils.ImageProfileUtil;
import org.dspace.app.iiif.service.utils.ThumbProfileUtil;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractResourceService {
    protected String IIIF_ENDPOINT;
    protected String IMAGE_SERVICE;
    protected String SEARCH_URL;
    protected String CLIENT_URL;
    protected String IIIF_LOGO_IMAGE;
    protected String BITSTREAM_PATH_PREFIX;
    protected int DEFAULT_CANVAS_WIDTH;
    protected int DEFAULT_CANVAS_HEIGHT;
    protected static String DOCUMENT_VIEWING_HINT;
    protected static final String THUMBNAIL_PATH = "/full/90,/0/default.jpg";
    protected static final String IMAGE_PATH = "/full/full/0/default.jpg";
    protected static final Integer DEFAULT_CANVAS_WIDTH_FALLBACK;
    protected static final Integer DEFAULT_CANVAS_HEIGHT_FALLBACK;
    @Autowired
    IIIFUtils utils;
    @Autowired
    ThumbProfileUtil thumbUtil;
    @Autowired
    ImageProfileUtil imageUtil;

    protected void setConfiguration(ConfigurationService configurationService) {
        this.IIIF_ENDPOINT = configurationService.getProperty("dspace.server.url") + "/iiif/";
        this.IMAGE_SERVICE = configurationService.getProperty("iiif.image.server");
        this.SEARCH_URL = configurationService.getProperty("iiif.search.url");
        this.BITSTREAM_PATH_PREFIX = configurationService.getProperty("dspace.server.url") + "/api/core/bitstreams";
        DOCUMENT_VIEWING_HINT = configurationService.getProperty("iiif.document.viewing.hint");
        this.CLIENT_URL = configurationService.getProperty("dspace.ui.url");
        this.IIIF_LOGO_IMAGE = configurationService.getProperty("iiif.logo.image");
        this.DEFAULT_CANVAS_WIDTH = configurationService.getIntProperty("iiif.canvas.default-width", DEFAULT_CANVAS_WIDTH_FALLBACK.intValue());
        this.DEFAULT_CANVAS_HEIGHT = configurationService.getIntProperty("iiif.canvas.default-height", DEFAULT_CANVAS_HEIGHT_FALLBACK.intValue());
    }

    protected String getManifestId(UUID uuid) {
        return this.IIIF_ENDPOINT + uuid + "/manifest";
    }

    static {
        DEFAULT_CANVAS_WIDTH_FALLBACK = 1200;
        DEFAULT_CANVAS_HEIGHT_FALLBACK = 1600;
    }
}

