/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.dspace.app.iiif.model.generator.AnnotationGenerator;
import org.dspace.app.iiif.model.generator.CanvasGenerator;
import org.dspace.app.iiif.model.generator.ContentAsTextGenerator;
import org.dspace.app.iiif.model.generator.ManifestGenerator;
import org.dspace.app.iiif.model.generator.SearchResultGenerator;
import org.dspace.app.iiif.service.SearchAnnotationService;
import org.dspace.app.iiif.service.utils.IIIFUtils;
import org.dspace.discovery.SolrSearchCore;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
public class WordHighlightSolrSearch
implements SearchAnnotationService {
    private static final Logger log = LogManager.getLogger(WordHighlightSolrSearch.class);
    private String endpoint;
    private String manifestId;
    @Autowired
    IIIFUtils utils;
    @Autowired
    ContentAsTextGenerator contentAsText;
    @Autowired
    SearchResultGenerator searchResult;
    @Autowired
    SolrSearchCore solrSearchCore;
    @Autowired
    ManifestGenerator manifestGenerator;

    @Override
    public boolean useSearchPlugin(String className) {
        return className.contentEquals(WordHighlightSolrSearch.class.getCanonicalName());
    }

    @Override
    public void initializeQuerySettings(String endpoint, String manifestId) {
        this.endpoint = endpoint;
        this.manifestId = manifestId;
    }

    @Override
    public String getSearchResponse(UUID uuid, String query) {
        String json = "";
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        String solrService = configurationService.getProperty("iiif.search.url");
        boolean validationEnabled = configurationService.getBooleanProperty("discovery.solr.url.validation.enabled");
        UrlValidator urlValidator = new UrlValidator(8L);
        if (urlValidator.isValid(solrService) || validationEnabled) {
            HttpSolrClient solrServer = new HttpSolrClient.Builder(solrService).build();
            solrServer.setUseMultiPartPost(true);
            SolrQuery solrQuery = this.getSolrQuery(this.adjustQuery(query), this.manifestId);
            QueryRequest req = new QueryRequest((SolrParams)solrQuery);
            req.setResponseParser((ResponseParser)new NoOpResponseParser("json"));
            try {
                NamedList resp = solrServer.request((SolrRequest)req);
                json = (String)resp.get("response");
            }
            catch (IOException | SolrServerException e) {
                throw new RuntimeException("Unable to retrieve search response.", e);
            }
        } else {
            log.error("Error while initializing solr, invalid url: " + solrService);
        }
        return this.getAnnotationList(uuid, json, query);
    }

    private String adjustQuery(String query) {
        if (query.split(" ").length > 1) {
            return "(" + query + ")";
        }
        return query;
    }

    private SolrQuery getSolrQuery(String query, String manifestId) {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.set("q", new String[]{"ocr_text:" + query + " AND manifest_url:\"" + manifestId + "\""});
        solrQuery.set("wt", new String[]{"json"});
        solrQuery.set("hl", new String[]{"true"});
        solrQuery.set("hl.ocr.fl", new String[]{"ocr_text"});
        solrQuery.set("hl.ocr.contextBlock", new String[]{"line"});
        solrQuery.set("hl.ocr.contextSize", new String[]{"2"});
        solrQuery.set("hl.snippets", new String[]{"10"});
        solrQuery.set("hl.ocr.trackPages", new String[]{"off"});
        solrQuery.set("hl.ocr.limitBlock", new String[]{"page"});
        solrQuery.set("hl.ocr.absoluteHighlights", new String[]{"true"});
        return solrQuery;
    }

    private String getAnnotationList(UUID uuid, String json, String query) {
        this.searchResult.setIdentifier(this.manifestId + "/search?q=" + URLEncoder.encode(query, StandardCharsets.UTF_8));
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        JsonObject body = (JsonObject)gson.fromJson(json, JsonObject.class);
        if (body == null) {
            log.warn("Unable to process json response.");
            return this.utils.asJson(this.searchResult.generateResource());
        }
        JsonObject highs = body.getAsJsonObject("ocrHighlighting");
        for (Map.Entry ocrIds : highs.entrySet()) {
            JsonObject ocrObj = ((JsonElement)ocrIds.getValue()).getAsJsonObject().getAsJsonObject("ocr_text");
            if (ocrObj == null) continue;
            for (JsonElement snippetArray : ocrObj.getAsJsonObject().get("snippets").getAsJsonArray()) {
                String pageId = this.getCanvasId(snippetArray.getAsJsonObject().get("pages"));
                for (JsonElement highlights : snippetArray.getAsJsonObject().getAsJsonArray("highlights")) {
                    for (JsonElement highlight : highlights.getAsJsonArray()) {
                        this.searchResult.addResource(this.getAnnotation(highlight, pageId, uuid));
                    }
                }
            }
        }
        return this.utils.asJson(this.searchResult.generateResource());
    }

    private AnnotationGenerator getAnnotation(JsonElement highlight, String pageId, UUID uuid) {
        JsonObject hcoords = highlight.getAsJsonObject();
        String text = hcoords.get("text").getAsString();
        int ulx = hcoords.get("ulx").getAsInt();
        int uly = hcoords.get("uly").getAsInt();
        int lrx = hcoords.get("lrx").getAsInt();
        int lry = hcoords.get("lry").getAsInt();
        String w = Integer.toString(lrx - ulx);
        String h = Integer.toString(lry - uly);
        String params = ulx + "," + uly + "," + w + "," + h;
        return this.createSearchResultAnnotation(params, text, pageId, uuid);
    }

    private String getCanvasId(JsonElement element) {
        JsonArray pages = element.getAsJsonArray();
        JsonObject page = pages.get(0).getAsJsonObject();
        String[] identArr = page.get("id").getAsString().split("\\.");
        return "c" + identArr[1];
    }

    private AnnotationGenerator createSearchResultAnnotation(String params, String text, String pageId, UUID uuid) {
        String annotationIdentifier = this.endpoint + uuid + "/annot/" + pageId + "-" + params;
        String canvasIdentifier = this.endpoint + uuid + "/canvas/" + pageId + "#xywh=" + params;
        this.contentAsText.setText(text);
        CanvasGenerator canvas = new CanvasGenerator(canvasIdentifier);
        AnnotationGenerator annotationGenerator = new AnnotationGenerator(annotationIdentifier, AnnotationGenerator.PAINTING).setOnCanvas(canvas).setResource(this.contentAsText).setWithin(this.getWithinManifest());
        return annotationGenerator;
    }

    private List<ManifestGenerator> getWithinManifest() {
        ArrayList<ManifestGenerator> withinList = new ArrayList<ManifestGenerator>();
        this.manifestGenerator.setIdentifier(this.manifestId);
        withinList.add(this.manifestGenerator);
        return withinList;
    }
}

