/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.model.generator;

import de.digitalcollections.iiif.model.OtherContent;
import de.digitalcollections.iiif.model.PropertyValue;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import javax.validation.constraints.NotNull;
import org.dspace.app.iiif.model.generator.IIIFResource;

public class ExternalLinksGenerator
implements IIIFResource {
    private final String identifier;
    private String format;
    private String label;
    private String type;

    public ExternalLinksGenerator(@NotNull String identifier) {
        if (identifier.isEmpty()) {
            throw new RuntimeException("Mandatory external links identifier cannot be an empty string");
        }
        this.identifier = identifier;
    }

    public ExternalLinksGenerator setFormat(String format) {
        this.format = format;
        return this;
    }

    public ExternalLinksGenerator setLabel(String label) {
        this.label = label;
        return this;
    }

    public ExternalLinksGenerator setType(String type) {
        this.type = type;
        return this;
    }

    public Resource<OtherContent> generateResource() {
        if (this.identifier == null) {
            throw new RuntimeException("External links annotation requires an identifier");
        }
        OtherContent otherContent = this.format != null ? new OtherContent(this.identifier, this.format) : new OtherContent(this.identifier);
        if (this.label != null) {
            otherContent.setLabel(new PropertyValue(this.label, new String[0]));
        }
        if (this.type != null) {
            otherContent.setType(this.type);
        }
        return otherContent;
    }
}

