/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.service;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.iiif.model.generator.CanvasGenerator;
import org.dspace.app.iiif.model.generator.ContentSearchGenerator;
import org.dspace.app.iiif.model.generator.ExternalLinksGenerator;
import org.dspace.app.iiif.model.generator.ImageContentGenerator;
import org.dspace.app.iiif.model.generator.ManifestGenerator;
import org.dspace.app.iiif.model.generator.RangeGenerator;
import org.dspace.app.iiif.service.AbstractResourceService;
import org.dspace.app.iiif.service.CanvasService;
import org.dspace.app.iiif.service.ImageContentService;
import org.dspace.app.iiif.service.RangeService;
import org.dspace.app.iiif.service.RelatedService;
import org.dspace.app.iiif.service.SeeAlsoService;
import org.dspace.app.iiif.service.SequenceService;
import org.dspace.app.iiif.service.utils.IIIFUtils;
import org.dspace.app.util.service.MetadataExposureService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Component
public class ManifestService
extends AbstractResourceService {
    private static final Logger log = LogManager.getLogger(ManifestService.class);
    @Autowired
    protected ItemService itemService;
    @Autowired
    CanvasService canvasService;
    @Autowired
    RangeService rangeService;
    @Autowired
    SequenceService sequenceService;
    @Autowired
    RelatedService relatedService;
    @Autowired
    SeeAlsoService seeAlsoService;
    @Autowired
    ImageContentService imageContentService;
    @Autowired
    IIIFUtils utils;
    @Autowired
    ContentSearchGenerator contentSearchGenerator;
    @Autowired
    ManifestGenerator manifestGenerator;
    @Autowired
    MetadataExposureService metadataExposureService;
    protected String[] METADATA_FIELDS;
    boolean guessCanvasDimension;

    public ManifestService(ConfigurationService configurationService) {
        this.setConfiguration(configurationService);
        this.METADATA_FIELDS = configurationService.getArrayProperty("iiif.metadata.item");
    }

    public String getManifest(Item item, Context context) {
        String wid = this.configurationService.getProperty("iiif.canvas.default-width");
        String hgt = this.configurationService.getProperty("iiif.canvas.default-height");
        this.guessCanvasDimension = wid == null && hgt == null;
        this.populateManifest(item, context);
        return this.utils.asJson(this.manifestGenerator.generateResource());
    }

    private void populateManifest(Item item, Context context) {
        String manifestId = this.getManifestId(item.getID());
        this.manifestGenerator.setIdentifier(manifestId);
        this.manifestGenerator.setLabel(item.getName());
        this.setLogoContainer();
        this.addRelated(item);
        this.addSearchService(item);
        this.addMetadata(context, item);
        this.addViewingHint(item);
        this.addThumbnail(item, context);
        this.addCanvasAndRange(context, item, manifestId);
        this.manifestGenerator.addSequence(this.sequenceService.getSequence(item));
        this.addRendering(item, context);
        this.addSeeAlso(item);
    }

    private void addCanvasAndRange(Context context, Item item, String manifestId) {
        this.rangeService.setRootRange(manifestId);
        List<Bundle> bundles = this.utils.getIIIFBundles(item);
        if (this.guessCanvasDimension) {
            this.canvasService.guessCanvasDimensions(context, bundles);
        }
        for (Bundle bnd : bundles) {
            String bundleToCPrefix = null;
            if (bundles.size() > 1) {
                bundleToCPrefix = this.utils.getBundleIIIFToC(bnd);
            }
            for (Bitstream bitstream : this.utils.getIIIFBitstreams(context, bnd)) {
                CanvasGenerator canvas = this.sequenceService.addCanvas(context, item, bnd, bitstream);
                this.rangeService.updateRanges(bitstream, bundleToCPrefix, canvas);
            }
        }
        Map<String, RangeGenerator> tocRanges = this.rangeService.getTocRanges();
        if (tocRanges != null && tocRanges.size() > 0) {
            RangeGenerator rootRange = this.rangeService.getRootRange();
            this.manifestGenerator.addRange(rootRange);
            for (RangeGenerator range : tocRanges.values()) {
                this.manifestGenerator.addRange(range);
            }
        }
    }

    private void addMetadata(Context context, Item item) {
        String licenseUriValue;
        for (String field : this.METADATA_FIELDS) {
            String[] eq = field.split("\\.");
            String schema = eq[0];
            String element = eq[1];
            String qualifier = null;
            if (eq.length > 2) {
                qualifier = eq[2];
            }
            List metadata = item.getItemService().getMetadata((DSpaceObject)item, schema, element, qualifier, "*");
            ArrayList<String> values = new ArrayList<String>();
            for (MetadataValue meta : metadata) {
                try {
                    if (this.metadataExposureService.isHidden(context, meta.getMetadataField().getMetadataSchema().getName(), meta.getMetadataField().getElement(), meta.getMetadataField().getQualifier())) {
                        continue;
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                values.add(meta.getValue());
            }
            if (values.size() <= 0) continue;
            if (values.size() > 1) {
                this.manifestGenerator.addMetadata(field, (String)values.get(0), values.subList(1, values.size()).toArray(new String[values.size() - 1]));
                continue;
            }
            this.manifestGenerator.addMetadata(field, (String)values.get(0), new String[0]);
        }
        String descrValue = item.getItemService().getMetadataFirstValue((DSpaceObject)item, "dc", "description", null, "*");
        if (StringUtils.isNotBlank((CharSequence)descrValue)) {
            this.manifestGenerator.addDescription(descrValue);
        }
        if (StringUtils.isNotBlank((CharSequence)(licenseUriValue = item.getItemService().getMetadataFirstValue((DSpaceObject)item, "dc", "rights", "uri", "*")))) {
            this.manifestGenerator.addLicense(licenseUriValue);
        }
    }

    private void addRelated(Item item) {
        this.manifestGenerator.addRelated(this.relatedService.getRelated(item));
    }

    private void addViewingHint(Item item) {
        this.manifestGenerator.addViewingHint(this.utils.getIIIFViewingHint(item, DOCUMENT_VIEWING_HINT));
    }

    private void addSeeAlso(Item item) {
        this.manifestGenerator.addSeeAlso(this.seeAlsoService.getSeeAlso(item));
    }

    private void addSearchService(Item item) {
        if (this.utils.isSearchable(item)) {
            this.contentSearchGenerator.setIdentifier(this.IIIF_ENDPOINT + item.getID() + "/manifest/search");
            this.manifestGenerator.addService(this.contentSearchGenerator);
        }
    }

    private void addThumbnail(Item item, Context context) {
        List<Bitstream> bitstreams = this.utils.getIIIFBitstreams(context, item);
        if (bitstreams != null && bitstreams.size() > 0) {
            String mimeType = this.utils.getBitstreamMimeType(bitstreams.get(0), context);
            ImageContentGenerator image = this.imageContentService.getImageContent(bitstreams.get(0).getID(), mimeType, this.thumbUtil.getThumbnailProfile(), "/full/90,/0/default.jpg");
            this.manifestGenerator.addThumbnail(image);
        }
    }

    private void setLogoContainer() {
        if (this.IIIF_LOGO_IMAGE != null) {
            ImageContentGenerator logo = new ImageContentGenerator(this.IIIF_LOGO_IMAGE);
            this.manifestGenerator.addLogo(logo);
        }
    }

    private void addRendering(Item item, Context context) {
        List<Bundle> bundles = this.utils.getIIIFBundles(item);
        for (Bundle bundle : bundles) {
            List bitstreams = bundle.getBitstreams();
            for (Bitstream bitstream : bitstreams) {
                String mimeType = null;
                try {
                    mimeType = bitstream.getFormat(context).getMIMEType();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (mimeType == null || !mimeType.contentEquals("application/pdf")) continue;
                String id = this.BITSTREAM_PATH_PREFIX + "/" + bitstream.getID() + "/content";
                this.manifestGenerator.addRendering(new ExternalLinksGenerator(id).setLabel(this.utils.getIIIFLabel((DSpaceObject)bitstream, bitstream.getName())).setFormat(mimeType));
            }
        }
    }
}

