/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.dspace.app.iiif.model.generator.AnnotationGenerator;
import org.dspace.app.iiif.model.generator.CanvasGenerator;
import org.dspace.app.iiif.model.generator.ContentAsTextGenerator;
import org.dspace.app.iiif.model.generator.ManifestGenerator;
import org.dspace.app.iiif.model.generator.SearchResultGenerator;
import org.dspace.app.iiif.service.SearchAnnotationService;
import org.dspace.app.iiif.service.utils.IIIFUtils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
public class WordHighlightSolrSearch
implements SearchAnnotationService {
    private static final Logger log = LogManager.getLogger(WordHighlightSolrSearch.class);
    private String endpoint;
    private String manifestId;
    @Autowired
    IIIFUtils utils;
    @Autowired
    ContentAsTextGenerator contentAsText;
    @Autowired
    SearchResultGenerator searchResult;
    @Autowired
    ManifestGenerator manifestGenerator;

    @Override
    public boolean useSearchPlugin(String className) {
        return className.contentEquals(WordHighlightSolrSearch.class.getCanonicalName());
    }

    @Override
    public void initializeQuerySettings(String endpoint, String manifestId) {
        this.endpoint = endpoint;
        this.manifestId = manifestId;
    }

    @Override
    public String getSearchResponse(UUID uuid, String query) {
        String json = "";
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        String solrService = configurationService.getProperty("iiif.search.url");
        boolean validationEnabled = configurationService.getBooleanProperty("discovery.solr.url.validation.enabled");
        UrlValidator urlValidator = new UrlValidator(8L);
        if (urlValidator.isValid(solrService) || validationEnabled) {
            HttpSolrClient solrServer = new HttpSolrClient.Builder(solrService).build();
            solrServer.setUseMultiPartPost(true);
            SolrQuery solrQuery = this.getSolrQuery(this.adjustQuery(query), this.manifestId);
            QueryRequest req = new QueryRequest((SolrParams)solrQuery);
            req.setResponseParser((ResponseParser)new NoOpResponseParser("json"));
            try {
                NamedList resp = solrServer.request((SolrRequest)req);
                json = (String)resp.get("response");
            }
            catch (IOException | SolrServerException e) {
                throw new RuntimeException("Unable to retrieve search response.", e);
            }
        } else {
            log.error("Error while initializing solr, invalid url: " + solrService);
        }
        return this.getAnnotationList(uuid, json, query);
    }

    private String adjustQuery(String query) {
        if (query.split(" ").length > 1) {
            return "(" + query + ")";
        }
        return query;
    }

    private SolrQuery getSolrQuery(String query, String manifestId) {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.set("q", new String[]{"ocr_text:" + query + " AND manifest_url:\"" + manifestId + "\""});
        solrQuery.set("wt", new String[]{"json"});
        solrQuery.set("hl", new String[]{"true"});
        solrQuery.set("hl.ocr.fl", new String[]{"ocr_text"});
        solrQuery.set("hl.ocr.contextBlock", new String[]{"line"});
        solrQuery.set("hl.ocr.contextSize", new String[]{"2"});
        solrQuery.set("hl.snippets", new String[]{"8192"});
        solrQuery.set("hl.ocr.maxPassages", new String[]{"8192"});
        solrQuery.set("hl.ocr.trackPages", new String[]{"on"});
        solrQuery.set("hl.ocr.limitBlock", new String[]{"page"});
        solrQuery.set("hl.ocr.absoluteHighlights", new String[]{"true"});
        return solrQuery;
    }

    private String getAnnotationList(UUID uuid, String json, String query) {
        this.searchResult.setIdentifier(this.manifestId + "/search?q=" + URLEncoder.encode(query, StandardCharsets.UTF_8));
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
        }
        if (body == null) {
            return this.utils.asJson(this.searchResult.generateResource());
        }
        JsonNode highs = body.get("ocrHighlighting");
        if (highs != null) {
            for (JsonNode highEntry : highs) {
                JsonNode ocrNode = highEntry.get("ocr_text");
                if (ocrNode == null) continue;
                for (JsonNode snippet : ocrNode.get("snippets")) {
                    String pageId;
                    if (snippet == null || (pageId = this.getCanvasId(snippet.get("pages"))) == null) continue;
                    for (JsonNode highlights : snippet.get("highlights")) {
                        if (highlights == null) continue;
                        for (int i = 0; i < highlights.size(); ++i) {
                            AnnotationGenerator anno = this.getAnnotation(highlights.get(i), pageId, uuid);
                            if (anno == null) continue;
                            this.searchResult.addResource(anno);
                        }
                    }
                }
            }
        }
        return this.utils.asJson(this.searchResult.generateResource());
    }

    private AnnotationGenerator getAnnotation(JsonNode highlight, String pageId, UUID uuid) {
        String h;
        String text = highlight.get("text") != null ? highlight.get("text").asText() : null;
        int ulx = highlight.get("ulx") != null ? highlight.get("ulx").asInt() : -1;
        int uly = highlight.get("uly") != null ? highlight.get("uly").asInt() : -1;
        int lrx = highlight.get("lrx") != null ? highlight.get("lrx").asInt() : -1;
        int lry = highlight.get("lry") != null ? highlight.get("lry").asInt() : -1;
        String w = lrx >= 0 && ulx >= 0 ? Integer.toString(lrx - ulx) : null;
        String string = h = lry >= 0 && uly >= 0 ? Integer.toString(lry - uly) : null;
        if (text != null && w != null && h != null) {
            String params = ulx + "," + uly + "," + w + "," + h;
            return this.createSearchResultAnnotation(params, text, pageId, uuid);
        }
        return null;
    }

    private String getCanvasId(JsonNode pagesNode) {
        JsonNode pageId;
        JsonNode page;
        if (pagesNode != null && (page = pagesNode.get(0)) != null && (pageId = page.get("id")) != null) {
            String[] identArr = pageId.asText().split("\\.");
            return "c" + identArr[1];
        }
        return null;
    }

    private AnnotationGenerator createSearchResultAnnotation(String params, String text, String pageId, UUID uuid) {
        String annotationIdentifier = this.endpoint + uuid + "/annot/" + pageId + "-" + params;
        String canvasIdentifier = this.endpoint + uuid + "/canvas/" + pageId + "#xywh=" + params;
        this.contentAsText.setText(text);
        CanvasGenerator canvas = new CanvasGenerator(canvasIdentifier);
        AnnotationGenerator annotationGenerator = new AnnotationGenerator(annotationIdentifier, AnnotationGenerator.PAINTING).setOnCanvas(canvas).setResource(this.contentAsText).setWithin(this.getWithinManifest());
        return annotationGenerator;
    }

    private List<ManifestGenerator> getWithinManifest() {
        ArrayList<ManifestGenerator> withinList = new ArrayList<ManifestGenerator>();
        this.manifestGenerator.setIdentifier(this.manifestId);
        withinList.add(this.manifestGenerator);
        return withinList;
    }
}

