/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.dspace.database.DSpaceDataSource;
import org.dspace.kernel.DSpaceKernel;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.dspace.services.ConfigurationService;
import org.junit.Assert;
import org.junit.Test;

public class DatabaseTest {
    @Test
    public void testDBNoConfig() {
        DSpaceDataSource dataSource = new DSpaceDataSource(null);
        this.runTest((DataSource)dataSource);
        dataSource.shutdown();
    }

    @Test
    public void testDBWithDefaultConfig() {
        DSpaceConfigurationService configurationService = new DSpaceConfigurationService();
        DSpaceDataSource dataSource = new DSpaceDataSource((ConfigurationService)configurationService);
        this.runTest((DataSource)dataSource);
        dataSource.shutdown();
    }

    @Test
    public void testDBWithDerby() {
        DSpaceConfigurationService configurationService = new DSpaceConfigurationService();
        configurationService.loadConfig("jdbc.database.type", "DERBY");
        configurationService.loadConfig("jdbc.driver.class", "org.apache.derby.jdbc.EmbeddedDriver");
        configurationService.loadConfig("jdbc.connection.url", "jdbc:derby:DSpaceDerby");
        configurationService.loadConfig("jdbc.username", "user1");
        configurationService.loadConfig("jdbc.password", "user1");
        configurationService.loadConfig("jdbc.dataSource.pooling", "false");
        DSpaceDataSource dataSource = new DSpaceDataSource((ConfigurationService)configurationService);
        this.runTest((DataSource)dataSource);
        dataSource.shutdown();
    }

    @Test
    public void testDBWithDerbyAndPooling() {
        DSpaceConfigurationService configurationService = new DSpaceConfigurationService();
        configurationService.loadConfig("jdbc.database.type", "DERBY");
        configurationService.loadConfig("jdbc.driver.class", "org.apache.derby.jdbc.EmbeddedDriver");
        configurationService.loadConfig("jdbc.connection.url", "jdbc:derby:DSpaceDerby");
        configurationService.loadConfig("jdbc.username", "user1");
        configurationService.loadConfig("jdbc.password", "user1");
        configurationService.loadConfig("jdbc.dataSource.pooling", "true");
        DSpaceDataSource dataSource = new DSpaceDataSource((ConfigurationService)configurationService);
        this.runTest((DataSource)dataSource);
        dataSource.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDBWithKernel() {
        DSpaceKernelImpl kernelImpl = DSpaceKernelInit.getKernel(null);
        Assert.assertNotNull((Object)kernelImpl);
        kernelImpl.start();
        try {
            Assert.assertTrue((boolean)kernelImpl.isRunning());
            DSpaceKernel kernel = kernelImpl.getManagedBean();
            Assert.assertNotNull((Object)kernel);
            DSpaceDataSource dataSource = (DSpaceDataSource)kernel.getServiceManager().getServiceByName(null, DSpaceDataSource.class);
            Assert.assertNotNull((Object)dataSource);
            this.runTest((DataSource)dataSource);
            dataSource.shutdown();
        }
        finally {
            if (kernelImpl != null) {
                try {
                    kernelImpl.stop();
                }
                catch (Exception exception) {}
                kernelImpl.destroy();
            }
        }
    }

    protected void runTest(DataSource dataSource) {
        try {
            Connection connection = dataSource.getConnection();
            connection.setAutoCommit(false);
            try {
                Statement createTable = connection.createStatement();
                try {
                    createTable.execute("create table TEST (name varchar(255), email varchar(255), PRIMARY KEY (name))");
                }
                catch (Exception e) {
                    throw new RuntimeException("Test failed: " + e.getMessage(), e);
                }
                finally {
                    createTable.close();
                }
                PreparedStatement insertRow = connection.prepareStatement("insert into TEST (name, email) values (?, ?)");
                try {
                    insertRow.setString(1, "aaronz");
                    insertRow.setString(2, "aaron@caret.cam.ac.uk");
                    insertRow.execute();
                }
                catch (Exception e) {
                    throw new RuntimeException("Test failed: " + e.getMessage(), e);
                }
                finally {
                    insertRow.close();
                }
                Statement select = connection.createStatement();
                try {
                    ResultSet rs = select.executeQuery("select * from TEST");
                    try {
                        int count = 0;
                        while (rs.next()) {
                            String name = rs.getString(1);
                            String email = rs.getString(2);
                            Assert.assertNotNull((Object)name);
                            Assert.assertNotNull((Object)email);
                            Assert.assertEquals((Object)"aaronz", (Object)name);
                            Assert.assertEquals((Object)"aaron@caret.cam.ac.uk", (Object)email);
                            ++count;
                        }
                        Assert.assertEquals((long)1L, (long)count);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Test failed: " + e.getMessage(), e);
                    }
                    finally {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException("Test failed: " + e.getMessage(), e);
                }
                finally {
                    select.close();
                }
                Statement dropTable = connection.createStatement();
                try {
                    dropTable.execute("drop table TEST");
                }
                catch (SQLException e) {
                    throw new RuntimeException("Test failed: " + e.getMessage(), e);
                }
                finally {
                    dropTable.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Test failed: " + e.getMessage(), e);
            }
            finally {
                try {
                    connection.rollback();
                }
                catch (Exception e) {}
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Test failed: " + e.getMessage(), e);
        }
    }
}

