/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager;

import java.net.URL;
import java.net.URLClassLoader;
import org.dspace.kernel.DSpaceKernel;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DSpaceKernelImplTest {
    DSpaceKernelImpl kernelImpl;

    @Before
    public void init() {
        this.kernelImpl = DSpaceKernelInit.getKernel(null);
    }

    @After
    public void destroy() {
        if (this.kernelImpl != null) {
            this.kernelImpl.destroy();
        }
        this.kernelImpl = null;
    }

    @Test
    public void testKernel() {
        this.kernelImpl.start();
        Assert.assertNotNull((Object)this.kernelImpl);
        DSpaceKernel kernel = this.kernelImpl.getManagedBean();
        Assert.assertNotNull((Object)kernel);
        Assert.assertNotNull((Object)this.kernelImpl.getConfigurationService());
        Assert.assertNotNull((Object)this.kernelImpl.getServiceManager());
        Assert.assertNotNull((Object)kernel.getConfigurationService());
        Assert.assertNotNull((Object)kernel.getServiceManager());
        Assert.assertEquals((Object)kernel.getConfigurationService(), (Object)this.kernelImpl.getConfigurationService());
        Assert.assertEquals((Object)kernel.getServiceManager(), (Object)this.kernelImpl.getServiceManager());
        this.kernelImpl.stop();
    }

    @Test
    public void testMultipleKernels() {
        Assert.assertNotNull((Object)this.kernelImpl);
        this.kernelImpl.start();
        DSpaceKernel kernel = this.kernelImpl.getManagedBean();
        Assert.assertNotNull((Object)kernel);
        Assert.assertNotNull((Object)this.kernelImpl.getConfigurationService());
        Assert.assertNotNull((Object)this.kernelImpl.getServiceManager());
        Assert.assertNotNull((Object)kernel.getConfigurationService());
        Assert.assertNotNull((Object)kernel.getServiceManager());
        Assert.assertEquals((Object)kernel.getConfigurationService(), (Object)this.kernelImpl.getConfigurationService());
        Assert.assertEquals((Object)kernel.getServiceManager(), (Object)this.kernelImpl.getServiceManager());
        DSpaceKernelImpl kernelImpl2 = DSpaceKernelInit.getKernel((String)"AZ-kernel");
        kernelImpl2.start();
        DSpaceKernel kernel2 = kernelImpl2.getManagedBean();
        Assert.assertNotNull((Object)kernel2);
        Assert.assertNotNull((Object)kernelImpl2.getConfigurationService());
        Assert.assertNotNull((Object)kernelImpl2.getServiceManager());
        Assert.assertNotNull((Object)kernel2.getConfigurationService());
        Assert.assertNotNull((Object)kernel2.getServiceManager());
        Assert.assertEquals((Object)kernel2.getConfigurationService(), (Object)kernelImpl2.getConfigurationService());
        Assert.assertEquals((Object)kernel2.getServiceManager(), (Object)kernelImpl2.getServiceManager());
        Assert.assertNotSame((Object)kernel, (Object)kernel2);
        Assert.assertNotSame((Object)kernel.getConfigurationService(), (Object)kernel2.getConfigurationService());
        Assert.assertNotSame((Object)kernel.getServiceManager(), (Object)kernel2.getServiceManager());
        kernelImpl2.stop();
        this.kernelImpl.stop();
    }

    @Test
    public void testClassLoaders() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        URLClassLoader cl1 = new URLClassLoader(new URL[0], current);
        cl1.getParent();
    }
}

