/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.kernel.mixins.InitializedService;
import org.dspace.kernel.mixins.ShutdownService;
import org.dspace.servicemanager.DSpaceServiceManager;
import org.dspace.servicemanager.SampleAnnotationBean;
import org.dspace.servicemanager.ServiceConfig;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.dspace.servicemanager.example.ConcreteExample;
import org.dspace.servicemanager.fakeservices.FakeService1;
import org.dspace.servicemanager.fakeservices.FakeService2;
import org.dspace.servicemanager.spring.SpringAnnotationBean;
import org.dspace.servicemanager.spring.TestSpringServiceManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DSpaceServiceManagerTest {
    DSpaceServiceManager dsm;
    DSpaceConfigurationService configurationService;

    @Before
    public void init() {
        this.configurationService = new DSpaceConfigurationService();
        this.configurationService.loadConfig("testName@" + SampleAnnotationBean.class.getName(), "beckyz");
        this.configurationService.loadConfig("fakeParam@fakeBean", "beckyz");
        this.dsm = new DSpaceServiceManager(this.configurationService, new String[]{TestSpringServiceManager.SPRING_TEST_CONFIG_FILE});
    }

    @After
    public void shutdown() {
        if (this.dsm != null) {
            this.dsm.shutdown();
        }
        this.dsm = null;
        this.configurationService = null;
    }

    @Test
    public void testShutdown() {
        this.dsm.startup();
        this.dsm.shutdown();
    }

    @Test
    public void testStartup() {
        this.configurationService.clear();
        this.dsm.startup();
    }

    @Test
    public void testStartupWithConfig() {
        this.dsm.startup();
    }

    @Test
    public void testRegisterService() {
        this.dsm.startup();
        String name = "myNewService";
        this.dsm.registerService(name, (Object)"AZ");
        String service = (String)this.dsm.getServiceByName(name, String.class);
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"AZ", (Object)service);
        try {
            this.dsm.registerService("fakey", (Object)null);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testRegisterServiceClass() {
        this.dsm.startup();
        int currentSize = this.dsm.getServicesByType(SampleAnnotationBean.class).size();
        SampleAnnotationBean sab = (SampleAnnotationBean)this.dsm.registerServiceClass("newAnnote", SampleAnnotationBean.class);
        Assert.assertNotNull((Object)sab);
        List l = this.dsm.getServicesByType(SampleAnnotationBean.class);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)(currentSize + 1), (long)l.size());
        try {
            this.dsm.registerService("fakey", (Object)null);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testUnregisterService() {
        this.dsm.startup();
        String name = "myNewService";
        this.dsm.registerService(name, (Object)"AZ");
        String service = (String)this.dsm.getServiceByName(name, String.class);
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"AZ", (Object)service);
        this.dsm.unregisterService(name);
    }

    @Test
    public void testGetServiceByName() {
        this.configurationService.clear();
        this.dsm.startup();
        ConcreteExample concrete = (ConcreteExample)this.dsm.getServiceByName(ConcreteExample.class.getName(), ConcreteExample.class);
        Assert.assertNotNull((Object)concrete);
        Assert.assertEquals((Object)"azeckoski", (Object)concrete.getName());
        SampleAnnotationBean sab = (SampleAnnotationBean)this.dsm.getServiceByName(SampleAnnotationBean.class.getName(), SampleAnnotationBean.class);
        Assert.assertNotNull((Object)sab);
        Assert.assertEquals(null, (Object)sab.getSampleValue());
    }

    @Test
    public void testGetServiceByNameConfig() {
        this.dsm.startup();
        ConcreteExample concrete = (ConcreteExample)this.dsm.getServiceByName(ConcreteExample.class.getName(), ConcreteExample.class);
        Assert.assertNotNull((Object)concrete);
        Assert.assertEquals((Object)"azeckoski", (Object)concrete.getName());
        SampleAnnotationBean sab = (SampleAnnotationBean)this.dsm.getServiceByName(SampleAnnotationBean.class.getName(), SampleAnnotationBean.class);
        Assert.assertNotNull((Object)sab);
        Assert.assertEquals((Object)"beckyz", (Object)sab.getSampleValue());
    }

    @Test
    public void testGetServicesByType() {
        this.dsm.startup();
        int currentSize = this.dsm.getServicesByType(ConcreteExample.class).size();
        Assert.assertTrue((currentSize > 0 ? 1 : 0) != 0);
        List l = this.dsm.getServicesByType(ConcreteExample.class);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((Object)"azeckoski", (Object)((ConcreteExample)l.get(0)).getName());
        List l2 = this.dsm.getServicesByType(SampleAnnotationBean.class);
        Assert.assertNotNull((Object)l2);
        Assert.assertTrue((l2.size() >= 1 ? 1 : 0) != 0);
        List l3 = this.dsm.getServicesByType(ServiceConfig.class);
        Assert.assertNotNull((Object)l3);
        Assert.assertEquals((long)0L, (long)l3.size());
    }

    @Test
    public void testGetServicesNames() {
        this.dsm.startup();
        List names = this.dsm.getServicesNames();
        Assert.assertNotNull((Object)names);
        Assert.assertTrue((names.size() >= 3 ? 1 : 0) != 0);
    }

    @Test
    public void testIsServiceExists() {
        this.dsm.startup();
        String name = ConcreteExample.class.getName();
        boolean exists = this.dsm.isServiceExists(name);
        Assert.assertTrue((boolean)exists);
        name = SampleAnnotationBean.class.getName();
        exists = this.dsm.isServiceExists(name);
        Assert.assertTrue((boolean)exists);
        name = SpringAnnotationBean.class.getName();
        exists = this.dsm.isServiceExists(name);
        Assert.assertTrue((boolean)exists);
        exists = this.dsm.isServiceExists("XXXXXXXXXXXXXXX");
        Assert.assertFalse((boolean)exists);
    }

    @Test
    public void testGetServices() {
        this.dsm.startup();
        Map services = this.dsm.getServices();
        Assert.assertNotNull((Object)services);
        Assert.assertTrue((services.size() > 3 ? 1 : 0) != 0);
    }

    @Test
    public void testPushConfig() {
        this.dsm.startup();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("some.test.thing", "A value");
        this.dsm.pushConfig(properties);
    }

    @Test
    public void testInitAndShutdown() {
        this.dsm.startup();
        SampleAnnotationBean sab = (SampleAnnotationBean)this.dsm.getServiceByName(SampleAnnotationBean.class.getName(), SampleAnnotationBean.class);
        Assert.assertNotNull((Object)sab);
        Assert.assertEquals((long)1L, (long)sab.initCounter);
        TestService ts = new TestService();
        Assert.assertEquals((long)0L, (long)ts.value);
        this.dsm.registerService(TestService.class.getName(), (Object)ts);
        Assert.assertEquals((long)1L, (long)ts.value);
        this.dsm.unregisterService(TestService.class.getName());
        Assert.assertEquals((long)2L, (long)ts.value);
    }

    @Test
    public void testRegisterProviderLifecycle() {
        this.dsm.startup();
        String serviceName = "azeckoski.FakeService1";
        FakeService1 service = new FakeService1();
        Assert.assertEquals((long)0L, (long)service.getTriggers());
        this.dsm.registerService(serviceName, (Object)service);
        Assert.assertNotNull((Object)service.getConfigurationService());
        Assert.assertEquals((Object)"init", (Object)service.getSomething());
        Assert.assertEquals((long)1L, (long)service.getTriggers());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("azeckoski.FakeService1.something", "THING");
        this.dsm.pushConfig(properties);
        Assert.assertEquals((Object)"config:THING", (Object)service.getSomething());
        Assert.assertEquals((long)2L, (long)service.getTriggers());
        this.dsm.registerService("fake2", (Object)new FakeService2());
        Assert.assertEquals((Object)"registered:fake2", (Object)service.getSomething());
        Assert.assertEquals((long)3L, (long)service.getTriggers());
        this.dsm.unregisterService("fake2");
        Assert.assertEquals((Object)"unregistered:fake2", (Object)service.getSomething());
        Assert.assertEquals((long)4L, (long)service.getTriggers());
        this.dsm.unregisterService(serviceName);
        Assert.assertEquals((Object)"shutdown", (Object)service.getSomething());
        Assert.assertEquals((long)5L, (long)service.getTriggers());
    }

    public static class TestService
    implements InitializedService,
    ShutdownService {
        public int value = 0;

        public void init() {
            ++this.value;
        }

        public void shutdown() {
            ++this.value;
        }
    }
}

