/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import org.dspace.kernel.mixins.ConfigChangeListener;
import org.dspace.kernel.mixins.InitializedService;
import org.dspace.kernel.mixins.ServiceChangeListener;
import org.dspace.kernel.mixins.ShutdownService;
import org.dspace.servicemanager.ServiceMixinManager;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.dspace.servicemanager.fakeservices.FakeService1;
import org.dspace.servicemanager.fakeservices.FakeService2;
import org.dspace.services.ConfigurationService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServiceMixinManagerTest {
    protected ServiceMixinManager serviceMixinManager;

    @Before
    public void setUp() {
        this.serviceMixinManager = new ServiceMixinManager();
        this.serviceMixinManager.registerService(FakeService2.class.getName(), (Object)new FakeService2());
        this.serviceMixinManager.registerService("fake2", (Object)new FakeService2());
        this.serviceMixinManager.registerService(FakeService1.class.getName(), (Object)new FakeService1((ConfigurationService)new DSpaceConfigurationService()));
    }

    @After
    public void shutDown() {
        this.serviceMixinManager.clear();
    }

    @Test
    public void testGetBiKey() {
        String bikey = ServiceMixinManager.getBiKey((String)"org.azeckoski.Test", Serializable.class);
        Assert.assertNotNull((Object)bikey);
        Assert.assertEquals((Object)"org.azeckoski.Test/java.io.Serializable", (Object)bikey);
        bikey = ServiceMixinManager.getBiKey((String)"org.azeckoski.Test", null);
        Assert.assertNotNull((Object)bikey);
        Assert.assertEquals((Object)"org.azeckoski.Test", (Object)bikey);
        try {
            ServiceMixinManager.getBiKey(null, Serializable.class);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetServiceName() {
        String bikey = "org.azeckoski.Test/java.io.Serializable";
        String serviceName = ServiceMixinManager.getServiceName((String)bikey);
        Assert.assertNotNull((Object)serviceName);
        Assert.assertEquals((Object)"org.azeckoski.Test", (Object)serviceName);
        serviceName = ServiceMixinManager.getServiceName((String)"org.azeckoski.Test");
        Assert.assertNotNull((Object)serviceName);
        Assert.assertEquals((Object)"org.azeckoski.Test", (Object)serviceName);
        try {
            ServiceMixinManager.getServiceName(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetMixinName() {
        String bikey = "org.azeckoski.Test/java.io.Serializable";
        String mixinName = ServiceMixinManager.getMixinName((String)bikey);
        Assert.assertNotNull((Object)mixinName);
        Assert.assertEquals((Object)"java.io.Serializable", (Object)mixinName);
        mixinName = ServiceMixinManager.getMixinName((String)"org.azeckoski.Test");
        Assert.assertNull((Object)mixinName);
        try {
            ServiceMixinManager.getMixinName(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetMixin() {
        String bikey = "org.azeckoski.Test/java.io.Serializable";
        Class mixin = ServiceMixinManager.getMixin((String)bikey);
        Assert.assertNotNull((Object)mixin);
        Assert.assertEquals(Serializable.class, (Object)mixin);
        mixin = ServiceMixinManager.getMixin((String)"org.azeckoski.Test");
        Assert.assertNull((Object)mixin);
        try {
            ServiceMixinManager.getMixin(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testExtractMixins() {
        List mixins = ServiceMixinManager.extractMixins((Object)new FakeService1());
        Assert.assertNotNull((Object)mixins);
        Assert.assertEquals((long)5L, (long)mixins.size());
        Assert.assertTrue((boolean)mixins.contains(ConfigChangeListener.class));
        Assert.assertTrue((boolean)mixins.contains(ServiceChangeListener.class));
        Assert.assertTrue((boolean)mixins.contains(InitializedService.class));
        Assert.assertTrue((boolean)mixins.contains(ShutdownService.class));
        Assert.assertTrue((boolean)mixins.contains(Serializable.class));
        mixins = ServiceMixinManager.extractMixins((Object)new FakeService2());
        Assert.assertNotNull((Object)mixins);
        Assert.assertEquals((long)3L, (long)mixins.size());
        Assert.assertTrue((boolean)mixins.contains(InitializedService.class));
        Assert.assertTrue((boolean)mixins.contains(Comparable.class));
        Assert.assertTrue((boolean)mixins.contains(Serializable.class));
        try {
            ServiceMixinManager.extractMixins(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetServiceByName() {
        Object service = this.serviceMixinManager.getServiceByName(FakeService2.class.getName());
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)(service instanceof FakeService2));
        service = this.serviceMixinManager.getServiceByName("fake2");
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)(service instanceof FakeService2));
        service = this.serviceMixinManager.getServiceByName(FakeService1.class.getName());
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)(service instanceof FakeService1));
        service = this.serviceMixinManager.getServiceByName("XXXXXXXXXXXXXX");
        Assert.assertNull((Object)service);
    }

    @Test
    public void testGetServiceByNameAndMixin() {
        ServiceChangeListener serviceChangeListener = (ServiceChangeListener)this.serviceMixinManager.getServiceByNameAndMixin(FakeService1.class.getName(), ServiceChangeListener.class);
        Assert.assertNotNull((Object)serviceChangeListener);
        FakeService1 service1 = (FakeService1)this.serviceMixinManager.getServiceByNameAndMixin(FakeService1.class.getName(), null);
        Assert.assertNotNull((Object)service1);
        Observer observer = (Observer)this.serviceMixinManager.getServiceByNameAndMixin(FakeService1.class.getName(), Observer.class);
        Assert.assertNull((Object)observer);
    }

    @Test
    public void testGetRegisteredServiceNames() {
        List names = this.serviceMixinManager.getRegisteredServiceNames();
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((long)3L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("fake2"));
        Assert.assertTrue((boolean)names.contains(FakeService1.class.getName()));
        Assert.assertTrue((boolean)names.contains(FakeService2.class.getName()));
    }

    @Test
    public void testGetRegisteredServices() {
        List services = this.serviceMixinManager.getRegisteredServices();
        Assert.assertNotNull((Object)services);
        Assert.assertEquals((long)3L, (long)services.size());
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)3L, (long)this.serviceMixinManager.size());
    }

    @Test
    public void testRegisterService() {
        this.serviceMixinManager.registerService("aaronz", (Object)new FakeService2());
        Assert.assertEquals((long)4L, (long)this.serviceMixinManager.size());
        this.serviceMixinManager.registerService("aaronz", (Object)new FakeService2());
        Assert.assertEquals((long)4L, (long)this.serviceMixinManager.size());
        try {
            this.serviceMixinManager.registerService(null, (Object)new FakeService2());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            this.serviceMixinManager.registerService("aaronz", null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testUnregisterServiceByName() {
        Assert.assertEquals((long)3L, (long)this.serviceMixinManager.size());
        Assert.assertNotNull((Object)this.serviceMixinManager.getServiceByName("fake2"));
        this.serviceMixinManager.unregisterServiceByName("fake2");
        Assert.assertEquals((long)2L, (long)this.serviceMixinManager.size());
        Assert.assertNull((Object)this.serviceMixinManager.getServiceByName("fake2"));
    }

    @Test
    public void testUnregisterServiceMixin() {
        Assert.assertEquals((long)3L, (long)this.serviceMixinManager.size());
        Assert.assertNotNull((Object)this.serviceMixinManager.getServiceByName("fake2"));
        Assert.assertNotNull((Object)this.serviceMixinManager.getServiceByNameAndMixin("fake2", Serializable.class));
        this.serviceMixinManager.unregisterServiceMixin("fake2", Serializable.class);
        Assert.assertEquals((long)3L, (long)this.serviceMixinManager.size());
        Assert.assertNotNull((Object)this.serviceMixinManager.getServiceByName("fake2"));
        Assert.assertNull((Object)this.serviceMixinManager.getServiceByNameAndMixin("fake2", Serializable.class));
    }

    @Test
    public void testGetServiceMixins() {
        List mixins = this.serviceMixinManager.getServiceMixins("fake2");
        Assert.assertNotNull((Object)mixins);
        Assert.assertEquals((long)4L, (long)mixins.size());
        Assert.assertTrue((boolean)mixins.contains(FakeService2.class));
        Assert.assertTrue((boolean)mixins.contains(InitializedService.class));
        Assert.assertTrue((boolean)mixins.contains(Comparable.class));
        Assert.assertTrue((boolean)mixins.contains(Serializable.class));
        mixins = this.serviceMixinManager.getServiceMixins(FakeService1.class.getName());
        Assert.assertNotNull((Object)mixins);
        Assert.assertEquals((long)6L, (long)mixins.size());
        Assert.assertTrue((boolean)mixins.contains(FakeService1.class));
        Assert.assertTrue((boolean)mixins.contains(ConfigChangeListener.class));
        Assert.assertTrue((boolean)mixins.contains(ServiceChangeListener.class));
        Assert.assertTrue((boolean)mixins.contains(InitializedService.class));
        Assert.assertTrue((boolean)mixins.contains(ShutdownService.class));
        Assert.assertTrue((boolean)mixins.contains(Serializable.class));
        mixins = this.serviceMixinManager.getServiceMixins("XXXXXXXX");
        Assert.assertNotNull((Object)mixins);
        Assert.assertEquals((long)0L, (long)mixins.size());
    }

    @Test
    public void testGetRegisteredServiceMixins() {
        Map serviceMixins = this.serviceMixinManager.getRegisteredServiceMixins();
        Assert.assertNotNull((Object)serviceMixins);
        Assert.assertEquals((long)3L, (long)serviceMixins.size());
    }

    @Test
    public void testGetServicesByMixin() {
        List slist = this.serviceMixinManager.getServicesByMixin(Serializable.class);
        Assert.assertNotNull((Object)slist);
        Assert.assertEquals((long)3L, (long)slist.size());
        List olist = this.serviceMixinManager.getServicesByMixin(Observer.class);
        Assert.assertNotNull((Object)olist);
        Assert.assertEquals((long)0L, (long)olist.size());
        List fs2l = this.serviceMixinManager.getServicesByMixin(FakeService2.class);
        Assert.assertNotNull((Object)fs2l);
        Assert.assertEquals((long)2L, (long)fs2l.size());
        List scll = this.serviceMixinManager.getServicesByMixin(ServiceChangeListener.class);
        Assert.assertNotNull((Object)scll);
        Assert.assertEquals((long)1L, (long)scll.size());
    }

    @Test
    public void testGetServiceHoldersByMixin() {
        List slist = this.serviceMixinManager.getServiceHoldersByMixin(Serializable.class);
        Assert.assertNotNull((Object)slist);
        Assert.assertEquals((long)3L, (long)slist.size());
        List olist = this.serviceMixinManager.getServiceHoldersByMixin(Observer.class);
        Assert.assertNotNull((Object)olist);
        Assert.assertEquals((long)0L, (long)olist.size());
        List fs2l = this.serviceMixinManager.getServiceHoldersByMixin(FakeService2.class);
        Assert.assertNotNull((Object)fs2l);
        Assert.assertEquals((long)2L, (long)fs2l.size());
        List scll = this.serviceMixinManager.getServiceHoldersByMixin(ServiceChangeListener.class);
        Assert.assertNotNull((Object)scll);
        Assert.assertEquals((long)1L, (long)scll.size());
        Assert.assertEquals((Object)FakeService1.class.getName(), (Object)((ServiceMixinManager.ServiceHolder)scll.get(0)).getServiceName());
    }
}

