/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.dspace.servicemanager.config.DSpaceConfig;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DSpaceConfigurationServiceTest {
    DSpaceConfigurationService configurationService;

    @Before
    public void init() {
        this.configurationService = new DSpaceConfigurationService();
        ArrayList<DSpaceConfig> l = new ArrayList<DSpaceConfig>();
        l.add(new DSpaceConfig("service.name", "DSpace"));
        l.add(new DSpaceConfig("sample.array", "itemA,itemB,itemC"));
        l.add(new DSpaceConfig("sample.number", "123"));
        l.add(new DSpaceConfig("sample.boolean", "true"));
        l.add(new DSpaceConfig("aaronz", "Aaron Zeckoski"));
        l.add(new DSpaceConfig("current.user", "${aaronz}"));
        l.add(new DSpaceConfig("test.key1", "This is a value"));
        l.add(new DSpaceConfig("test.key2", "This is key1=${test.key1}"));
        this.configurationService.loadConfiguration(l, true);
    }

    @After
    public void tearDown() {
        this.configurationService = null;
    }

    @Test
    public void testReplaceVariables() {
        ArrayList<DSpaceConfig> l = new ArrayList<DSpaceConfig>();
        l.add(new DSpaceConfig("service.name", "DSpace"));
        l.add(new DSpaceConfig("aaronz", "Aaron Zeckoski"));
        l.add(new DSpaceConfig("current.user", "${aaronz}"));
        l.add(new DSpaceConfig("test.key1", "This is a value"));
        l.add(new DSpaceConfig("test.key2", "This is key1=${test.key1}"));
        l.add(new DSpaceConfig("test.key3", "This is key2=${test.key2}"));
        HashMap<String, DSpaceConfig> configMap = new HashMap<String, DSpaceConfig>();
        for (DSpaceConfig config : l) {
            configMap.put(config.getKey(), config);
        }
        this.configurationService.replaceVariables(configMap);
        Assert.assertEquals((long)6L, (long)configMap.size());
        Assert.assertEquals((Object)"DSpace", (Object)((DSpaceConfig)configMap.get("service.name")).getValue());
        Assert.assertEquals((Object)"Aaron Zeckoski", (Object)((DSpaceConfig)configMap.get("aaronz")).getValue());
        Assert.assertEquals((Object)"Aaron Zeckoski", (Object)((DSpaceConfig)configMap.get("current.user")).getValue());
        Assert.assertEquals((Object)"This is a value", (Object)((DSpaceConfig)configMap.get("test.key1")).getValue());
        Assert.assertEquals((Object)"This is key1=This is a value", (Object)((DSpaceConfig)configMap.get("test.key2")).getValue());
        Assert.assertEquals((Object)"This is key2=This is key1=This is a value", (Object)((DSpaceConfig)configMap.get("test.key3")).getValue());
    }

    @Test
    public void testGetAllProperties() {
        Map props = this.configurationService.getAllProperties();
        Assert.assertNotNull((Object)props);
        Assert.assertEquals((long)8L, (long)props.size());
        Assert.assertNotNull(props.get("service.name"));
        Assert.assertEquals((Object)"DSpace", props.get("service.name"));
    }

    @Test
    public void testGetProperties() {
        Properties props = this.configurationService.getProperties();
        Assert.assertNotNull((Object)props);
        Assert.assertEquals((long)8L, (long)props.size());
        Assert.assertNotNull((Object)props.get("service.name"));
        Assert.assertEquals((Object)"DSpace", (Object)props.get("service.name"));
    }

    @Test
    public void testGetProperty() {
        String prop = this.configurationService.getProperty("service.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"DSpace", (Object)prop);
        prop = this.configurationService.getProperty("XXXXX");
        Assert.assertNull((Object)prop);
    }

    @Test
    public void testGetPropertyAsTypeStringClassOfT() {
        String prop = (String)this.configurationService.getPropertyAsType("service.name", String.class);
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"DSpace", (Object)prop);
        String[] array = (String[])this.configurationService.getPropertyAsType("sample.array", String[].class);
        Assert.assertNotNull((Object)array);
        Assert.assertEquals((Object)"itemA", (Object)array[0]);
        Assert.assertEquals((Object)"itemB", (Object)array[1]);
        Assert.assertEquals((Object)"itemC", (Object)array[2]);
        Integer number = (Integer)this.configurationService.getPropertyAsType("sample.number", Integer.class);
        Assert.assertNotNull((Object)number);
        Assert.assertEquals((Object)new Integer(123), (Object)number);
        Boolean bool = (Boolean)this.configurationService.getPropertyAsType("sample.boolean", Boolean.class);
        Assert.assertNotNull((Object)bool);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)bool);
        Assert.assertEquals((long)123L, (long)((Integer)this.configurationService.getPropertyAsType("sample.number", Integer.TYPE)).intValue());
        Assert.assertEquals((Object)true, (Object)((Boolean)this.configurationService.getPropertyAsType("sample.boolean", Boolean.TYPE)));
        prop = (String)this.configurationService.getPropertyAsType("XXXXX", String.class);
        Assert.assertNull((Object)prop);
    }

    @Test
    public void testGetPropertyAsTypeStringT() {
        String prop = (String)this.configurationService.getPropertyAsType("service.name", (Object)"DeeSpace");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"DSpace", (Object)prop);
        String[] array = (String[])this.configurationService.getPropertyAsType("sample.array", (Object)new String[]{"A", "B"});
        Assert.assertNotNull((Object)array);
        Assert.assertEquals((Object)"itemA", (Object)array[0]);
        Assert.assertEquals((Object)"itemB", (Object)array[1]);
        Assert.assertEquals((Object)"itemC", (Object)array[2]);
        Integer number = (Integer)this.configurationService.getPropertyAsType("sample.number", (Object)new Integer(12345));
        Assert.assertNotNull((Object)number);
        Assert.assertEquals((Object)new Integer(123), (Object)number);
        Boolean bool = (Boolean)this.configurationService.getPropertyAsType("sample.boolean", (Object)Boolean.FALSE);
        Assert.assertNotNull((Object)bool);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)bool);
        boolean b = (Boolean)this.configurationService.getPropertyAsType("sample.boolean", (Object)false);
        Assert.assertTrue((boolean)b);
        prop = (String)this.configurationService.getPropertyAsType("XXXXX", (Object)"XXX");
        Assert.assertEquals((Object)"XXX", (Object)prop);
    }

    @Test
    public void testGetPropertyAsTypeStringTBoolean() {
        String prop = this.configurationService.getProperty("service.fake.thing");
        Assert.assertNull((Object)prop);
        prop = (String)this.configurationService.getPropertyAsType("service.fake.thing", (Object)"Fakey", false);
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"Fakey", (Object)prop);
        prop = this.configurationService.getProperty("service.fake.thing");
        Assert.assertNull((Object)prop);
        prop = (String)this.configurationService.getPropertyAsType("service.fake.thing", (Object)"Fakey", true);
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"Fakey", (Object)prop);
        prop = this.configurationService.getProperty("service.fake.thing");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"Fakey", (Object)prop);
    }

    @Test
    public void testSetProperty() {
        String prop = this.configurationService.getProperty("newOne");
        Assert.assertNull((Object)prop);
        boolean changed = this.configurationService.setProperty("newOne", (Object)"1111111");
        Assert.assertTrue((boolean)changed);
        prop = this.configurationService.getProperty("newOne");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"1111111", (Object)prop);
        prop = this.configurationService.getProperty("newBool");
        Assert.assertNull((Object)prop);
        changed = this.configurationService.setProperty("newBool", (Object)true);
        Assert.assertTrue((boolean)changed);
        prop = this.configurationService.getProperty("newBool");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"true", (Object)prop);
        changed = this.configurationService.setProperty("newBool", (Object)true);
        Assert.assertFalse((boolean)changed);
        changed = this.configurationService.setProperty("newBool", null);
        Assert.assertTrue((boolean)changed);
        prop = this.configurationService.getProperty("newBool");
        Assert.assertNull((Object)prop);
    }

    @Test
    public void testGetConfiguration() {
        Assert.assertNotNull((Object)this.configurationService.getConfiguration());
        Assert.assertEquals((long)8L, (long)this.configurationService.getConfiguration().size());
    }

    @Test
    public void testLoadConfig() {
        Assert.assertEquals((long)8L, (long)this.configurationService.getConfiguration().size());
        this.configurationService.loadConfig("newA", "A");
        Assert.assertEquals((long)9L, (long)this.configurationService.getConfiguration().size());
        Assert.assertEquals((Object)"A", (Object)this.configurationService.getProperty("newA"));
        this.configurationService.loadConfig("newB", "service is ${service.name}");
        Assert.assertEquals((long)10L, (long)this.configurationService.getConfiguration().size());
        Assert.assertEquals((Object)"service is DSpace", (Object)this.configurationService.getProperty("newB"));
        this.configurationService.loadConfig("newA", "aaronz");
        Assert.assertEquals((long)10L, (long)this.configurationService.getConfiguration().size());
        Assert.assertEquals((Object)"aaronz", (Object)this.configurationService.getProperty("newA"));
    }

    @Test
    public void testClear() {
        this.configurationService.clear();
        Assert.assertEquals((long)0L, (long)this.configurationService.getAllProperties().size());
    }

    @Test
    public void testGetPropertiesFromSystem() {
        DSpaceConfigurationService dscs = new DSpaceConfigurationService();
        int size = dscs.getConfiguration().size();
        System.setProperty("dspace.az.system.config", "Hello");
        System.setProperty("not.dspace", "Adios");
        dscs = new DSpaceConfigurationService();
        Assert.assertEquals((long)(size + 1), (long)dscs.getConfiguration().size());
        Assert.assertEquals((Object)"Hello", (Object)dscs.getProperty("az.system.config"));
    }
}

