/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.servlet;

import java.io.IOException;
import java.util.EventListener;
import org.dspace.kernel.DSpaceKernelManager;
import org.dspace.servicemanager.servlet.DSpaceKernelServletContextListener;
import org.dspace.servicemanager.servlet.SampleServlet;
import org.dspace.utils.servlet.DSpaceWebappServletFilter;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.jetty.testing.HttpTester;
import org.mortbay.jetty.testing.ServletTester;

public class DSpaceKernelServletContextListenerTest {
    @Test
    public void testSampleRequest() {
        try {
            new DSpaceKernelManager().getKernel();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalStateException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        ServletTester tester = new ServletTester();
        tester.setContextPath("/");
        tester.getContext().addEventListener((EventListener)new DSpaceKernelServletContextListener());
        tester.addFilter(DSpaceWebappServletFilter.class, "/*", 1);
        tester.addServlet(SampleServlet.class, "/dspace");
        try {
            tester.start();
        }
        catch (Exception e) {
            Assert.fail((String)("Could not start the jetty server: " + e.getMessage()));
        }
        Assert.assertNotNull((Object)new DSpaceKernelManager().getKernel());
        String jettyRequest = "GET /dspace HTTP/1.1\r\nHost: tester\r\n\r\n";
        try {
            String content = tester.getResponses(jettyRequest);
            Assert.assertNotNull((Object)content);
            Assert.assertTrue((boolean)content.contains("DSpaceTest"));
            Assert.assertFalse((boolean)content.contains("session=null"));
            Assert.assertFalse((boolean)content.contains("request=null"));
        }
        catch (Exception e) {
            Assert.fail((String)("Could not fire request: " + e.getMessage()));
        }
        Assert.assertNotNull((Object)new DSpaceKernelManager().getKernel());
        HttpTester request = new HttpTester();
        HttpTester response = new HttpTester();
        request.setMethod("GET");
        request.setHeader("Host", "tester");
        request.setVersion("HTTP/1.0");
        request.setURI("/dspace");
        try {
            response.parse(tester.getResponses(request.generate()));
        }
        catch (IOException e1) {
            Assert.fail((String)("Could not parse response: " + e1.getMessage()));
        }
        catch (Exception e1) {
            Assert.fail((String)("Could not parse response: " + e1.getMessage()));
        }
        Assert.assertTrue((response.getMethod() == null ? 1 : 0) != 0);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String content = response.getContent();
        Assert.assertNotNull((Object)content);
        Assert.assertTrue((boolean)content.contains("DSpaceTest"));
        Assert.assertFalse((boolean)content.contains("session=null"));
        Assert.assertFalse((boolean)content.contains("request=null"));
        Assert.assertNotNull((Object)new DSpaceKernelManager().getKernel());
        try {
            tester.stop();
        }
        catch (Exception e) {
            Assert.fail((String)("Could not stop the jetty server: " + e.getMessage()));
        }
        try {
            new DSpaceKernelManager().getKernel();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalStateException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testSampleRequestDouble() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.testSampleRequest();
    }
}

