/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.kernel.DSpaceKernel;
import org.dspace.kernel.DSpaceKernelManager;
import org.dspace.kernel.ServiceManager;
import org.dspace.services.RequestService;
import org.dspace.services.SessionService;

public class SampleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient SessionService sessionService;
    private transient RequestService requestService;
    protected static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    protected static final String XHTML_HEADER = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n  <title>DSpace title</title>\n</head>\n<body>\n";
    protected static final String XHTML_FOOTER = "\n</body>\n</html>\n";

    public void init() throws ServletException {
        super.init();
        try {
            DSpaceKernel kernel = new DSpaceKernelManager().getKernel();
            if (kernel == null) {
                throw new IllegalStateException("Could not get the DSpace Kernel");
            }
            if (!kernel.isRunning()) {
                throw new IllegalStateException("DSpace Kernel is not running, cannot startup the DirectServlet");
            }
            ServiceManager serviceManager = kernel.getServiceManager();
            this.sessionService = (SessionService)serviceManager.getServiceByName(SessionService.class.getName(), SessionService.class);
            if (this.sessionService == null) {
                throw new IllegalStateException("Could not get the DSpace SessionService");
            }
            this.requestService = (RequestService)serviceManager.getServiceByName(RequestService.class.getName(), RequestService.class);
            if (this.requestService == null) {
                throw new IllegalStateException("Could not get the DSpace RequestService");
            }
            System.out.println("Servlet initialized");
        }
        catch (Exception e) {
            throw new IllegalStateException("FAILURE during init of direct servlet: " + e.getMessage(), e);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html");
        res.setCharacterEncoding("UTF-8");
        PrintWriter writer = res.getWriter();
        writer.print(XML_HEADER);
        writer.print(XHTML_HEADER);
        writer.print("DSpaceTest:session=" + this.sessionService.getCurrentSessionId() + ":request=" + this.requestService.getCurrentRequestId());
        writer.print(XHTML_FOOTER);
        res.setStatus(200);
        System.out.println("Serviced request:  DSpace");
    }
}

