/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.spring;

import java.util.List;
import org.dspace.servicemanager.MockServiceManagerSystem;
import org.dspace.servicemanager.SampleAnnotationBean;
import org.dspace.servicemanager.ServiceConfig;
import org.dspace.servicemanager.ServiceManagerSystem;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.dspace.servicemanager.example.ConcreteExample;
import org.dspace.servicemanager.spring.SpringAnnotationBean;
import org.dspace.servicemanager.spring.SpringServiceManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSpringServiceManager {
    public static String SPRING_TEST_CONFIG_FILE = "spring/spring-test-services.xml";
    SpringServiceManager ssm;
    DSpaceConfigurationService configurationService;

    @Before
    public void init() {
        this.configurationService = new DSpaceConfigurationService();
        this.configurationService.loadConfig("testName@" + SampleAnnotationBean.class.getName(), "beckyz");
        this.configurationService.loadConfig("fakeParam@fakeBean", "beckyz");
        this.ssm = new SpringServiceManager((ServiceManagerSystem)new MockServiceManagerSystem((ServiceManagerSystem)this.ssm), this.configurationService, true, true, new String[]{SPRING_TEST_CONFIG_FILE});
    }

    @After
    public void shutdown() {
        if (this.ssm != null) {
            this.ssm.shutdown();
        }
        this.ssm = null;
    }

    @Test
    public void testStartup() {
        this.configurationService.clear();
        this.ssm.startup();
    }

    @Test
    public void testStartupWithConfig() {
        this.ssm.startup();
    }

    @Test
    public void testShutdown() {
        this.ssm.startup();
        this.ssm.shutdown();
    }

    @Test
    public void testGetServiceByName() {
        this.configurationService.clear();
        this.ssm.startup();
        ConcreteExample concrete = (ConcreteExample)this.ssm.getServiceByName(ConcreteExample.class.getName(), ConcreteExample.class);
        Assert.assertNotNull((Object)concrete);
        Assert.assertEquals((Object)"azeckoski", (Object)concrete.getName());
        SampleAnnotationBean sab = (SampleAnnotationBean)this.ssm.getServiceByName(SampleAnnotationBean.class.getName(), SampleAnnotationBean.class);
        Assert.assertNotNull((Object)sab);
        Assert.assertEquals(null, (Object)sab.getSampleValue());
    }

    @Test
    public void testGetServiceByNameConfig() {
        this.ssm.startup();
        ConcreteExample concrete = (ConcreteExample)this.ssm.getServiceByName(ConcreteExample.class.getName(), ConcreteExample.class);
        Assert.assertNotNull((Object)concrete);
        Assert.assertEquals((Object)"azeckoski", (Object)concrete.getName());
        SampleAnnotationBean sab = (SampleAnnotationBean)this.ssm.getServiceByName(SampleAnnotationBean.class.getName(), SampleAnnotationBean.class);
        Assert.assertNotNull((Object)sab);
        Assert.assertEquals((Object)"beckyz", (Object)sab.getSampleValue());
        SpringAnnotationBean spr = (SpringAnnotationBean)this.ssm.getServiceByName(SpringAnnotationBean.class.getName(), SpringAnnotationBean.class);
        Assert.assertNotNull((Object)spr);
        Assert.assertEquals((Object)"azeckoski", (Object)spr.getConcreteName());
        Assert.assertEquals((Object)"aaronz", (Object)spr.getExampleName());
        Assert.assertEquals(null, (Object)spr.getSampleValue());
    }

    @Test
    public void testGetServicesByType() {
        this.ssm.startup();
        List l = this.ssm.getServicesByType(ConcreteExample.class);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((Object)"azeckoski", (Object)((ConcreteExample)l.get(0)).getName());
        List l2 = this.ssm.getServicesByType(SampleAnnotationBean.class);
        Assert.assertNotNull((Object)l2);
        Assert.assertEquals((long)1L, (long)l2.size());
        List l3 = this.ssm.getServicesByType(ServiceConfig.class);
        Assert.assertNotNull((Object)l3);
        Assert.assertEquals((long)0L, (long)l3.size());
    }

    @Test
    public void testRegisterServiceClass() {
        this.ssm.startup();
        SampleAnnotationBean sab = (SampleAnnotationBean)this.ssm.registerServiceClass("newAnnote", SampleAnnotationBean.class);
        Assert.assertNotNull((Object)sab);
        List l = this.ssm.getServicesByType(SampleAnnotationBean.class);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)2L, (long)l.size());
        try {
            this.ssm.registerService("fakey", (Object)null);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testRegisterService() {
        this.ssm.startup();
        String name = "myNewService";
        this.ssm.registerService(name, (Object)"AZ");
        String service = (String)this.ssm.getServiceByName(name, String.class);
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"AZ", (Object)service);
        try {
            this.ssm.registerService("fakey", (Object)null);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testUnregisterService() {
        this.ssm.startup();
        String name = "myNewService";
        this.ssm.registerService(name, (Object)"AZ");
        String service = (String)this.ssm.getServiceByName(name, String.class);
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"AZ", (Object)service);
        this.ssm.unregisterService(name);
    }

    @Test
    public void testGetServicesNames() {
        this.ssm.startup();
        List names = this.ssm.getServicesNames();
        Assert.assertNotNull((Object)names);
        Assert.assertTrue((names.size() >= 3 ? 1 : 0) != 0);
    }

    @Test
    public void testIsServiceExists() {
        this.ssm.startup();
        String name = ConcreteExample.class.getName();
        boolean exists = this.ssm.isServiceExists(name);
        Assert.assertTrue((boolean)exists);
        exists = this.ssm.isServiceExists("XXXXXXXXXXXXXXX");
        Assert.assertFalse((boolean)exists);
    }
}

