/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.caching;

import java.util.List;
import org.dspace.services.caching.CachingServiceImpl;
import org.dspace.services.caching.model.EhcacheCache;
import org.dspace.services.caching.model.MapCache;
import org.dspace.services.model.Cache;
import org.dspace.services.model.CacheConfig;
import org.dspace.test.DSpaceAbstractKernelTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachingServiceTest
extends DSpaceAbstractKernelTest {
    private CachingServiceImpl cachingService;

    @Before
    public void init() {
        this.cachingService = CachingServiceTest.getService(CachingServiceImpl.class);
        Assert.assertNotNull((Object)this.cachingService);
    }

    @After
    public void tearDown() {
        this.cachingService = null;
    }

    @Test
    public void testReloadConfig() {
        this.cachingService.reloadConfig();
    }

    @Test
    public void testNotifyForConfigNames() {
        Assert.assertNotNull((Object)this.cachingService.notifyForConfigNames());
    }

    @Test
    public void testInstantiateEhCache() {
        EhcacheCache cache = this.cachingService.instantiateEhCache("aaronz-eh", null);
        Assert.assertNotNull((Object)cache);
        Assert.assertEquals((Object)"aaronz-eh", (Object)cache.getName());
        Assert.assertNotNull((Object)cache.getCache());
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertNotNull((Object)cache.getConfig());
        Assert.assertEquals((Object)cache.getConfig().getCacheScope(), (Object)CacheConfig.CacheScope.INSTANCE);
        EhcacheCache cache2 = this.cachingService.instantiateEhCache("aaronz-eh", null);
        Assert.assertNotNull((Object)cache2);
        Assert.assertEquals((Object)cache2, (Object)cache);
    }

    @Test
    public void testInstantiateMapCache() {
        MapCache cache = this.cachingService.instantiateMapCache("aaronz-map", null);
        Assert.assertNotNull((Object)cache);
        Assert.assertEquals((Object)"aaronz-map", (Object)cache.getName());
        Assert.assertNotNull((Object)cache.getCache());
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertNotNull((Object)cache.getConfig());
        Assert.assertEquals((Object)cache.getConfig().getCacheScope(), (Object)CacheConfig.CacheScope.REQUEST);
        MapCache cache2 = this.cachingService.instantiateMapCache("aaronz-map", null);
        Assert.assertNotNull((Object)cache2);
        Assert.assertEquals((Object)cache2, (Object)cache);
    }

    @Test
    public void testGetCache() {
        Cache cache = this.cachingService.getCache("org.dspace.caching.MemOnly", null);
        Assert.assertNotNull((Object)cache);
        Assert.assertEquals((Object)"org.dspace.caching.MemOnly", (Object)cache.getName());
        Cache sampleCache = this.cachingService.getCache("org.sakaiproject.caching.test.SampleCache", null);
        Assert.assertNotNull((Object)sampleCache);
        Assert.assertEquals((Object)"org.sakaiproject.caching.test.SampleCache", (Object)sampleCache.getName());
        Cache c1 = this.cachingService.getCache("org.dspace.aztest", null);
        Assert.assertNotNull((Object)c1);
        Assert.assertEquals((Object)"org.dspace.aztest", (Object)c1.getName());
        Assert.assertEquals((Object)CacheConfig.CacheScope.INSTANCE, (Object)c1.getConfig().getCacheScope());
        Assert.assertTrue((boolean)(c1 instanceof EhcacheCache));
        Cache rc1 = this.cachingService.getCache("org.dspace.request.cache1", new CacheConfig(CacheConfig.CacheScope.REQUEST));
        Assert.assertNotNull((Object)rc1);
        Assert.assertEquals((Object)"org.dspace.request.cache1", (Object)rc1.getName());
        Assert.assertEquals((Object)CacheConfig.CacheScope.REQUEST, (Object)rc1.getConfig().getCacheScope());
        Assert.assertTrue((boolean)(rc1 instanceof MapCache));
        Cache c2 = this.cachingService.getCache("org.dspace.aztest", null);
        Assert.assertNotNull((Object)c2);
        Assert.assertEquals((Object)c1, (Object)c2);
    }

    @Test
    public void testGetCaches() {
        List caches = this.cachingService.getCaches();
        Assert.assertNotNull((Object)caches);
        int curSize = caches.size();
        Assert.assertTrue((curSize > 0 ? 1 : 0) != 0);
        Cache memCache = this.cachingService.getCache("org.dspace.caching.MemOnly", null);
        Assert.assertNotNull((Object)memCache);
        Assert.assertTrue((boolean)caches.contains(memCache));
        Cache c1 = this.cachingService.getCache("org.dspace.aztest.new", null);
        Assert.assertNotNull((Object)c1);
        caches = this.cachingService.getCaches();
        Assert.assertNotNull((Object)caches);
        Assert.assertEquals((long)(curSize + 1), (long)caches.size());
        Assert.assertTrue((boolean)caches.contains(c1));
    }

    @Test
    public void testGetStatus() {
        String status = this.cachingService.getStatus(null);
        Assert.assertNotNull((Object)status);
        status = this.cachingService.getStatus("XXXXXXXXX");
        Assert.assertNotNull((Object)status);
    }

    @Test
    public void testResetCaches() {
        this.cachingService.resetCaches();
        Cache c1 = this.cachingService.getCache("org.dspace.aztest.new", null);
        Assert.assertNotNull((Object)c1);
        c1.put("AZ", (Object)"aaron.zeckoski");
        c1.put("BZ", (Object)"becky.zeckoski");
        Assert.assertEquals((Object)"aaron.zeckoski", (Object)c1.get("AZ"));
        Assert.assertEquals(null, (Object)c1.get("CZ"));
        Assert.assertEquals((long)2L, (long)c1.size());
        this.cachingService.resetCaches();
        Assert.assertEquals(null, (Object)c1.get("AZ"));
        Assert.assertEquals((long)0L, (long)c1.size());
    }

    @Test
    public void testDestroyCache() {
        Cache cache = this.cachingService.getCache("org.dspace.caching.MemOnly", null);
        Assert.assertNotNull((Object)cache);
        this.cachingService.destroyCache(cache.getName());
        Cache c2 = this.cachingService.getCache("org.dspace.caching.MemOnly", null);
        Assert.assertNotNull((Object)c2);
        Assert.assertNotSame((Object)cache, (Object)c2);
        this.cachingService.destroyCache("XXXXXXXXXXXX");
        Cache ca = this.cachingService.getCache("org.dspace.aztest", null);
        Assert.assertNotNull((Object)ca);
        this.cachingService.destroyCache(ca.getName());
        Cache cb = this.cachingService.getCache("org.dspace.aztest", null);
        Assert.assertNotNull((Object)cb);
        Assert.assertNotSame((Object)ca, (Object)cb);
    }
}

