/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.caching;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.dspace.services.caching.CachingServiceImpl;
import org.dspace.services.caching.model.EhcacheCache;
import org.dspace.services.model.Cache;
import org.dspace.services.model.CacheConfig;
import org.dspace.test.DSpaceAbstractKernelTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class EhcacheCacheTest
extends DSpaceAbstractKernelTest {
    static String cacheName = "org.dspace.aaronz.test.Cache";
    static CacheManager cacheManager;
    static Cache cache;

    @BeforeClass
    public static void initClass() {
        CachingServiceImpl cachingService = EhcacheCacheTest.getService(CachingServiceImpl.class);
        cacheManager = cachingService.getCacheManager();
        cache = cachingService.getCache(cacheName, new CacheConfig(CacheConfig.CacheScope.INSTANCE));
    }

    @Before
    public void init() {
        cache.clear();
    }

    @Test
    public void testGetCache() {
        Assert.assertTrue((boolean)(cache instanceof EhcacheCache));
        Assert.assertNotNull((Object)((EhcacheCache)cache).getCache());
    }

    @Test
    public void testEhcacheCache() {
        cacheManager.addCache("org.dspace.ehcache");
        Ehcache ehcache = cacheManager.getEhcache("org.dspace.ehcache");
        Assert.assertNotNull((Object)ehcache);
        EhcacheCache cache = new EhcacheCache(ehcache, new CacheConfig(CacheConfig.CacheScope.INSTANCE));
        Assert.assertEquals((Object)"org.dspace.ehcache", (Object)cache.getName());
    }

    @Test
    public void testGetConfig() {
        CacheConfig cacheConfig = cache.getConfig();
        Assert.assertNotNull((Object)cacheConfig);
    }

    @Test
    public void testGetName() {
        String name = cache.getName();
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((Object)cacheName, (Object)name);
    }

    @Test
    public void testClear() {
        cache.put("XX", (Object)"XXXX");
        Assert.assertTrue((cache.size() > 0 ? 1 : 0) != 0);
        cache.clear();
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    @Test
    public void testExists() {
        Assert.assertFalse((boolean)cache.exists("XXX"));
        cache.put("XXX", (Object)123);
        Assert.assertTrue((boolean)cache.exists("XXX"));
    }

    @Test
    public void testGet() {
        cache.put("XXX", (Object)123);
        Integer i = (Integer)cache.get("XXX");
        Assert.assertNotNull((Object)i);
        Assert.assertEquals((Object)new Integer(123), (Object)i);
        Object o = cache.get("YYYYYYYY");
        Assert.assertNull((Object)o);
        try {
            cache.get(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testLook() {
        cache.put("XXX", (Object)"AZ");
        String thing = (String)cache.look("XXX");
        Assert.assertNotNull((Object)thing);
        Assert.assertEquals((Object)"AZ", (Object)thing);
    }

    @Test
    public void testPut() {
        Assert.assertEquals((long)0L, (long)cache.size());
        cache.put("XXX", (Object)123);
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.put("YYY", null);
        Assert.assertEquals((long)2L, (long)cache.size());
        cache.put("XXX", (Object)"ABC");
        Assert.assertEquals((long)2L, (long)cache.size());
        cache.put("XXX", null);
        Assert.assertEquals((long)2L, (long)cache.size());
        Object o = cache.get("XXX");
        Assert.assertNull((Object)o);
        try {
            cache.put(null, (Object)"XXX");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testRemove() {
        cache.put("XXX", (Object)123);
        cache.put("YYY", null);
        Assert.assertEquals((long)2L, (long)cache.size());
        cache.remove("XXX");
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.remove("XXX");
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.remove("ZZZ");
        Assert.assertEquals((long)1L, (long)cache.size());
        try {
            cache.remove(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)cache.size());
        cache.put("A", (Object)"AASSDDFF");
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.put("B", (Object)"AASSDDFF");
        cache.put("C", (Object)"AASSDDFF");
        Assert.assertEquals((long)3L, (long)cache.size());
    }

    static {
        cache = null;
    }
}

