/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.events;

import org.dspace.services.RequestService;
import org.dspace.services.events.EventListenerBothFilters;
import org.dspace.services.events.EventListenerNameFilter;
import org.dspace.services.events.EventListenerNoFilter;
import org.dspace.services.events.SystemEventService;
import org.dspace.services.model.Event;
import org.dspace.services.model.EventListener;
import org.dspace.test.DSpaceAbstractKernelTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EventServiceTest
extends DSpaceAbstractKernelTest {
    private SystemEventService eventService;
    private RequestService requestService;
    private EventListenerNoFilter listenerNoFilter;
    private EventListenerNameFilter listenerNameFilter;
    private EventListenerBothFilters listenerBothFilters;

    @Before
    public void init() {
        this.eventService = EventServiceTest.getService(SystemEventService.class);
        this.requestService = EventServiceTest.getService(RequestService.class);
        this.listenerNoFilter = new EventListenerNoFilter();
        this.listenerNameFilter = new EventListenerNameFilter();
        this.listenerBothFilters = new EventListenerBothFilters();
        this.eventService.registerEventListener((EventListener)this.listenerNoFilter);
        this.eventService.registerEventListener((EventListener)this.listenerNameFilter);
        this.eventService.registerEventListener((EventListener)this.listenerBothFilters);
    }

    @After
    public void tearDown() {
        this.eventService = null;
        this.requestService = null;
        this.listenerNoFilter = null;
        this.listenerNameFilter = null;
        this.listenerBothFilters = null;
    }

    @Test
    public void testFireEvent() {
        Event event1 = new Event("test.event.read", "test-resource-1", "11111", false);
        Event event2 = new Event("test.event.jump", null, "11111", false);
        Event event3 = new Event("some.event.write", "test-resource-2", "11111", true);
        Event event4 = new Event("some.event.add", "fake-resource-555", "11111", true);
        Event event5 = new Event("test.event.read", "test-resource-2", "11111", false);
        Event event6 = new Event("test.event.read", "fake-resource-555", "11111", false);
        Event event7 = new Event("aaron.event.read", "az-123456", "11111", false);
        this.eventService.fireEvent(event1);
        this.eventService.fireEvent(event2);
        this.eventService.fireEvent(event3);
        this.eventService.fireEvent(event4);
        this.eventService.fireEvent(event5);
        this.eventService.fireEvent(event6);
        this.eventService.fireEvent(event7);
        Assert.assertEquals((long)7L, (long)this.listenerNoFilter.getReceivedEvents().size());
        Assert.assertEquals((long)5L, (long)this.listenerNameFilter.getReceivedEvents().size());
        Assert.assertEquals((long)3L, (long)this.listenerBothFilters.getReceivedEvents().size());
        Assert.assertEquals((Object)event1, (Object)this.listenerNoFilter.getReceivedEvents().get(0));
        Assert.assertEquals((Object)event2, (Object)this.listenerNoFilter.getReceivedEvents().get(1));
        Assert.assertEquals((Object)event3, (Object)this.listenerNoFilter.getReceivedEvents().get(2));
        Assert.assertEquals((Object)event4, (Object)this.listenerNoFilter.getReceivedEvents().get(3));
        Assert.assertEquals((Object)event5, (Object)this.listenerNoFilter.getReceivedEvents().get(4));
        Assert.assertEquals((Object)event6, (Object)this.listenerNoFilter.getReceivedEvents().get(5));
        Assert.assertEquals((Object)event7, (Object)this.listenerNoFilter.getReceivedEvents().get(6));
        Assert.assertEquals((Object)event1, (Object)this.listenerNameFilter.getReceivedEvents().get(0));
        Assert.assertEquals((Object)event2, (Object)this.listenerNameFilter.getReceivedEvents().get(1));
        Assert.assertEquals((Object)event5, (Object)this.listenerNameFilter.getReceivedEvents().get(2));
        Assert.assertEquals((Object)event6, (Object)this.listenerNameFilter.getReceivedEvents().get(3));
        Assert.assertEquals((Object)event7, (Object)this.listenerNameFilter.getReceivedEvents().get(4));
        Assert.assertEquals((Object)event1, (Object)this.listenerBothFilters.getReceivedEvents().get(0));
        Assert.assertEquals((Object)event2, (Object)this.listenerBothFilters.getReceivedEvents().get(1));
        Assert.assertEquals((Object)event5, (Object)this.listenerBothFilters.getReceivedEvents().get(2));
    }

    @Test
    public void testQueueEvent() {
        Event event1 = new Event("test.event.read", "test-resource-1", "11111", false);
        Event event2 = new Event("test.event.jump", null, "11111", false);
        Event event3 = new Event("some.event.write", "test-resource-2", "11111", true);
        Event event4 = new Event("some.event.add", "fake-resource-555", "11111", true);
        Assert.assertEquals((long)0L, (long)this.listenerNoFilter.getReceivedEvents().size());
        this.eventService.queueEvent(event1);
        Assert.assertEquals((long)1L, (long)this.listenerNoFilter.getReceivedEvents().size());
        this.requestService.startRequest();
        this.eventService.queueEvent(event2);
        this.eventService.queueEvent(event3);
        Assert.assertEquals((long)1L, (long)this.listenerNoFilter.getReceivedEvents().size());
        this.requestService.endRequest((Exception)new RuntimeException("die request!"));
        Assert.assertEquals((long)1L, (long)this.listenerNoFilter.getReceivedEvents().size());
        this.requestService.startRequest();
        this.eventService.queueEvent(event2);
        this.eventService.queueEvent(event3);
        this.eventService.queueEvent(event4);
        this.requestService.endRequest(null);
        Assert.assertEquals((long)4L, (long)this.listenerNoFilter.getReceivedEvents().size());
        Assert.assertEquals((Object)event1, (Object)this.listenerNoFilter.getReceivedEvents().get(0));
        Assert.assertEquals((Object)event2, (Object)this.listenerNoFilter.getReceivedEvents().get(1));
        Assert.assertEquals((Object)event3, (Object)this.listenerNoFilter.getReceivedEvents().get(2));
        Assert.assertEquals((Object)event4, (Object)this.listenerNoFilter.getReceivedEvents().get(3));
    }

    @Test
    public void testRegisterEventListener() {
        this.eventService.registerEventListener((EventListener)this.listenerNoFilter);
        this.eventService.registerEventListener((EventListener)this.listenerNameFilter);
        this.eventService.registerEventListener((EventListener)this.listenerBothFilters);
        try {
            this.eventService.registerEventListener(null);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }
}

