/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.metadata;

import org.dspace.services.MetadataFieldService;
import org.dspace.services.MetadataSchemaService;
import org.dspace.services.SessionService;
import org.dspace.services.metadata.MemoryMetadataFieldService;
import org.dspace.services.metadata.MemoryMetadataSchemaService;
import org.dspace.services.model.MetadataField;
import org.dspace.services.model.MetadataSchema;
import org.dspace.test.DSpaceAbstractTest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MemoryMetadataFieldServiceTest
extends DSpaceAbstractTest {
    public static final String TEST_PERM = "test.permission";
    public static final String TEST_REF = "/test/reference";
    public static MetadataSchemaService metadataSchemaService;
    public static MetadataFieldService metadataFieldService;
    public static SessionService sessionService;
    public static MetadataSchema dc;
    public static MetadataSchema terms;

    @BeforeClass
    public static void beforeTests() {
        MemoryMetadataFieldServiceTest._initializeKernel();
        MemoryMetadataFieldServiceTest._initializeRequestService();
        sessionService = MemoryMetadataFieldServiceTest.getService(SessionService.class);
        metadataSchemaService = new MemoryMetadataSchemaService();
        Assert.assertNotNull((Object)metadataSchemaService);
        metadataFieldService = new MemoryMetadataFieldService(metadataSchemaService);
        Assert.assertNotNull((Object)metadataFieldService);
        MemoryMetadataFieldServiceTest.getRequestService().startRequest();
        MemoryMetadataFieldServiceTest._preloadData(metadataSchemaService, metadataFieldService);
        MemoryMetadataFieldServiceTest.getRequestService().endRequest(null);
    }

    @Before
    public void before() {
        this._startRequest();
        Assert.assertNotNull((Object)sessionService);
        Assert.assertNotNull((Object)metadataSchemaService);
    }

    @After
    public void after() {
        this._endRequest();
    }

    @AfterClass
    public static void afterTests() {
        sessionService = null;
        metadataSchemaService = null;
        MemoryMetadataFieldServiceTest._destroyRequestService();
        MemoryMetadataFieldServiceTest._destroyKernel();
    }

    public static void _preloadData(MetadataSchemaService metadataSchemaService, MetadataFieldService metadataFieldService) {
        dc = new MetadataSchema("http://purl.org/dc/elements/1.1/", "dc");
        metadataSchemaService.create(dc);
        metadataFieldService.create(new MetadataField(dc.getPrefix(), "title", "Dublin Core Title"));
        metadataFieldService.create(new MetadataField(dc.getPrefix(), "description", "Dublin Core Description"));
        metadataFieldService.create(new MetadataField(dc.getPrefix(), "creator", "Dublin Core Creator"));
        terms = new MetadataSchema("http://purl.org/dc/terms/", "terms");
        metadataSchemaService.create(terms);
        metadataFieldService.create(new MetadataField(terms.getPrefix(), "title", "Dublin Core Title"));
        metadataFieldService.create(new MetadataField(terms.getPrefix(), "description", "Dublin Core Description"));
        metadataFieldService.create(new MetadataField(terms.getPrefix(), "creator", "Dublin Core Creator"));
    }

    @Test
    public void testFindAllInSchema() {
        MetadataSchema schema = null;
        schema = metadataSchemaService.findByPrefix(dc.getPrefix());
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((Object)dc, (Object)schema);
        MetadataField[] fields = metadataFieldService.findAllInSchema(schema.getPrefix());
        Assert.assertEquals((long)3L, (long)fields.length);
        MetadataField[] allfields = metadataFieldService.findAll();
        Assert.assertEquals((long)6L, (long)allfields.length);
    }

    static {
        dc = null;
        terms = null;
    }
}

