/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.metadata;

import org.dspace.services.MetadataSchemaService;
import org.dspace.services.SessionService;
import org.dspace.services.metadata.MemoryMetadataSchemaService;
import org.dspace.services.model.MetadataSchema;
import org.dspace.test.DSpaceAbstractTest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MemoryMetadataSchemaServiceTest
extends DSpaceAbstractTest {
    public static final String TEST_PERM = "test.permission";
    public static final String TEST_REF = "/test/reference";
    public static MetadataSchemaService metadataSchemaService;
    public static SessionService sessionService;
    public static MetadataSchema dc;
    public static MetadataSchema terms;

    @BeforeClass
    public static void beforeTests() {
        MemoryMetadataSchemaServiceTest._initializeKernel();
        MemoryMetadataSchemaServiceTest._initializeRequestService();
        sessionService = MemoryMetadataSchemaServiceTest.getService(SessionService.class);
        metadataSchemaService = new MemoryMetadataSchemaService();
        Assert.assertNotNull((Object)metadataSchemaService);
        MemoryMetadataSchemaServiceTest.getRequestService().startRequest();
        MemoryMetadataSchemaServiceTest._preloadData(metadataSchemaService);
        MemoryMetadataSchemaServiceTest.getRequestService().endRequest(null);
    }

    @Before
    public void before() {
        this._startRequest();
        Assert.assertNotNull((Object)sessionService);
        Assert.assertNotNull((Object)metadataSchemaService);
    }

    @After
    public void after() {
        this._endRequest();
    }

    @AfterClass
    public static void afterTests() {
        sessionService = null;
        metadataSchemaService = null;
        MemoryMetadataSchemaServiceTest._destroyRequestService();
        MemoryMetadataSchemaServiceTest._destroyKernel();
    }

    public static void _preloadData(MetadataSchemaService metadataSchemaService) {
        dc = new MetadataSchema("http://purl.org/dc/elements/1.1/", "dc");
        metadataSchemaService.create(dc);
        terms = new MetadataSchema("http://purl.org/dc/terms/", "terms");
        metadataSchemaService.create(terms);
    }

    @Test
    public void testGetSchemaByPrefix() {
        MetadataSchema schema = null;
        schema = metadataSchemaService.findByPrefix(dc.getPrefix());
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((Object)dc, (Object)schema);
        schema = metadataSchemaService.findByPrefix("foo");
        Assert.assertNull((Object)schema);
        try {
            metadataSchemaService.findByPrefix(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetSchemaByNamespace() {
        MetadataSchema schema = null;
        schema = metadataSchemaService.findByNamespace(dc.getNamespace());
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((Object)dc, (Object)schema);
        schema = metadataSchemaService.findByNamespace("foo");
        Assert.assertNull((Object)schema);
        try {
            metadataSchemaService.findByNamespace(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    static {
        dc = null;
        terms = null;
    }
}

