/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.session;

import java.util.List;
import org.dspace.services.CachingService;
import org.dspace.services.model.Cache;
import org.dspace.services.model.CacheConfig;
import org.dspace.services.model.RequestInterceptor;
import org.dspace.services.model.Session;
import org.dspace.services.session.MockRequestInterceptor;
import org.dspace.services.sessions.SessionRequestServiceImpl;
import org.dspace.test.DSpaceAbstractKernelTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionRequestServiceImplTest
extends DSpaceAbstractKernelTest {
    private SessionRequestServiceImpl sessionRequestService;
    private CachingService cachingService;

    @Before
    public void before() {
        this.sessionRequestService = SessionRequestServiceImplTest.getService(SessionRequestServiceImpl.class);
        this.cachingService = SessionRequestServiceImplTest.getService(CachingService.class);
    }

    @After
    public void after() {
        this.sessionRequestService.clear();
        this.cachingService.resetCaches();
        this.sessionRequestService = null;
        this.cachingService = null;
    }

    @Test
    public void testStartRequest() {
        String requestId = this.sessionRequestService.startRequest();
        Assert.assertNotNull((Object)requestId);
        String cacheRID = (String)this.getRequestCache().get("requestId");
        Assert.assertNotNull((Object)cacheRID);
        Assert.assertEquals((Object)cacheRID, (Object)requestId);
        this.sessionRequestService.endRequest(null);
    }

    @Test
    public void testEndRequest() {
        String requestId = this.sessionRequestService.startRequest();
        Assert.assertNotNull((Object)requestId);
        this.sessionRequestService.endRequest(null);
        String cacheRID = (String)this.getRequestCache().get("requestId");
        Assert.assertNull((Object)cacheRID);
    }

    @Test
    public void testRegisterRequestListener() {
        MockRequestInterceptor mri = new MockRequestInterceptor();
        this.sessionRequestService.registerRequestInterceptor((RequestInterceptor)mri);
        Assert.assertEquals((Object)"", (Object)mri.state);
        Assert.assertEquals((long)0L, (long)mri.hits);
        String requestId = this.sessionRequestService.startRequest();
        Assert.assertEquals((long)1L, (long)mri.hits);
        Assert.assertTrue((boolean)mri.state.startsWith("start"));
        Assert.assertTrue((boolean)mri.state.contains(requestId));
        this.sessionRequestService.endRequest(null);
        Assert.assertEquals((long)2L, (long)mri.hits);
        Assert.assertTrue((boolean)mri.state.startsWith("end"));
        Assert.assertTrue((boolean)mri.state.contains("success"));
        Assert.assertTrue((boolean)mri.state.contains(requestId));
        requestId = this.sessionRequestService.startRequest();
        Assert.assertEquals((long)3L, (long)mri.hits);
        Assert.assertTrue((boolean)mri.state.startsWith("start"));
        Assert.assertTrue((boolean)mri.state.contains(requestId));
        this.sessionRequestService.endRequest((Exception)new RuntimeException("Oh Noes!"));
        Assert.assertEquals((long)4L, (long)mri.hits);
        Assert.assertTrue((boolean)mri.state.startsWith("end"));
        Assert.assertTrue((boolean)mri.state.contains("fail"));
        Assert.assertTrue((boolean)mri.state.contains(requestId));
        try {
            this.sessionRequestService.registerRequestInterceptor(null);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testMakeSession() {
        Session session = this.sessionRequestService.makeSession("AZ-session");
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"AZ-session", (Object)session.getId());
    }

    @Test
    public void testGetSession() {
        Session s = this.sessionRequestService.getSession("aaronz");
        Assert.assertNull((Object)s);
        Session newOne = this.sessionRequestService.makeSession("aaronz");
        s = this.sessionRequestService.getSession("aaronz");
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((Object)newOne, (Object)s);
    }

    @Test
    public void testGetAllActiveSessions() {
        List l = this.sessionRequestService.getAllActiveSessions();
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)0L, (long)l.size());
        Session newOne = this.sessionRequestService.makeSession("aaronz");
        Session newTwo = this.sessionRequestService.makeSession("beckyz");
        l = this.sessionRequestService.getAllActiveSessions();
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)2L, (long)l.size());
        newOne.invalidate();
        l = this.sessionRequestService.getAllActiveSessions();
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)1L, (long)l.size());
        newTwo.clear();
        l = this.sessionRequestService.getAllActiveSessions();
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)1L, (long)l.size());
        newTwo.invalidate();
        l = this.sessionRequestService.getAllActiveSessions();
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)0L, (long)l.size());
    }

    @Test
    public void testBindSession() {
        Session session = null;
        try {
            this.sessionRequestService.bindSession("AZ1", "/user/aaronz", "aaronz");
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        this.sessionRequestService.makeSession("AZ1");
        session = this.sessionRequestService.bindSession("AZ1", "/user/aaronz", "aaronz");
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"AZ1", (Object)session.getId());
        Assert.assertEquals((Object)"/user/aaronz", (Object)session.getUserId());
        session = this.sessionRequestService.bindSession("AZ1", null, null);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"AZ1", (Object)session.getId());
        Assert.assertEquals(null, (Object)session.getUserId());
    }

    @Test
    public void testStartSession() {
        Session session = this.sessionRequestService.startSession("aaronz");
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"aaronz", (Object)session.getId());
        session.invalidate();
        Session s2 = this.sessionRequestService.startSession(null);
        Assert.assertNotNull((Object)s2);
        Assert.assertNotNull((Object)s2.getId());
        s2.invalidate();
    }

    @Test
    public void testGetCurrentSession() {
        Session current = this.sessionRequestService.getCurrentSession();
        Assert.assertNull((Object)current);
        Session session = this.sessionRequestService.startSession("aaronz");
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"aaronz", (Object)session.getId());
        current = this.sessionRequestService.getCurrentSession();
        Assert.assertNotNull((Object)current);
        Assert.assertEquals((Object)"aaronz", (Object)current.getId());
        Assert.assertEquals((Object)current, (Object)session);
    }

    @Test
    public void testGetCurrentSessionId() {
        String current = this.sessionRequestService.getCurrentSessionId();
        Assert.assertNull((Object)current);
        Session session = this.sessionRequestService.startSession("aaronz");
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"aaronz", (Object)session.getId());
        current = this.sessionRequestService.getCurrentSessionId();
        Assert.assertNotNull((Object)current);
        Assert.assertEquals((Object)"aaronz", (Object)current);
        Assert.assertEquals((Object)current, (Object)session.getId());
    }

    @Test
    public void testGetCurrentUserId() {
        String current = this.sessionRequestService.getCurrentUserId();
        Assert.assertNull((Object)current);
        Session session = this.sessionRequestService.startSession("aaronz");
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"aaronz", (Object)session.getId());
        Assert.assertEquals(null, (Object)session.getUserId());
        current = this.sessionRequestService.getCurrentUserId();
        Assert.assertNull((Object)current);
        this.sessionRequestService.bindSession(session.getId(), "/user/aaronz", "aaronz");
        current = this.sessionRequestService.getCurrentUserId();
        Assert.assertNotNull((Object)current);
        Assert.assertEquals((Object)"/user/aaronz", (Object)current);
    }

    @Test
    public void testGetCurrentRequestId() {
        String requestId = this.sessionRequestService.getCurrentRequestId();
        Assert.assertNull((Object)requestId);
        String rid = this.sessionRequestService.startRequest();
        requestId = this.sessionRequestService.getCurrentRequestId();
        Assert.assertNotNull((Object)requestId);
        Assert.assertEquals((Object)rid, (Object)requestId);
        this.sessionRequestService.endRequest(null);
        requestId = this.sessionRequestService.getCurrentRequestId();
        Assert.assertNull((Object)requestId);
    }

    private Cache getRequestCache() {
        Cache cache = this.cachingService.getCache("dsRequestCache", new CacheConfig(CacheConfig.CacheScope.REQUEST));
        return cache;
    }
}

