/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.user;

import org.dspace.services.model.User;
import org.dspace.services.user.MemoryUserAuthnProvider;
import org.dspace.services.user.MemoryUserAuthzProvider;
import org.dspace.services.user.MemoryUserLookupProvider;
import org.dspace.services.user.ProvidedUserService;
import org.dspace.services.user.UserManagingService;
import org.dspace.test.AbstractUserServiceTest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CachedUserServiceTest
extends AbstractUserServiceTest {
    @BeforeClass
    public static void beforeTests() {
        String pName1 = "dspace.activator.class.user_lookup_mem";
        System.setProperty(pName1, MemoryUserLookupProvider.class.getName());
        String pName2 = "dspace.activator.class.user_authn_mem";
        System.setProperty(pName2, MemoryUserAuthnProvider.class.getName());
        String pName3 = "dspace.activator.class.user_authz_mem";
        System.setProperty(pName3, MemoryUserAuthzProvider.class.getName());
        CachedUserServiceTest._beforeUserTests();
        System.clearProperty(pName1);
        System.clearProperty(pName2);
        System.clearProperty(pName3);
        userService = (UserManagingService)CachedUserServiceTest.getService(ProvidedUserService.class);
        CachedUserServiceTest.getRequestService().startRequest();
        CachedUserServiceTest._preloadData(userService);
        CachedUserServiceTest.getRequestService().endRequest(null);
    }

    @Before
    public void before() {
        this._beforeUserTest();
        Assert.assertNotNull((Object)sessionService);
        Assert.assertNotNull((Object)userService);
    }

    @After
    public void after() {
        this._afterUserTest();
    }

    @AfterClass
    public static void afterTests() {
        CachedUserServiceTest._afterUserTests();
    }

    @Test
    public void cacheSaturationTest() {
        User user = userService.getUserById(aaronz.getId());
        Assert.assertNotNull((Object)user);
        long start = System.currentTimeMillis();
        User u = null;
        for (int i = 0; i < 25000; ++i) {
            u = userService.getUserById(aaronz.getId());
            Assert.assertNotNull((Object)u);
            Assert.assertEquals((Object)user, (Object)u);
        }
        long total = System.currentTimeMillis() - start;
        Assert.assertTrue((String)("test took too long (over 1s) in ms: " + total), (total < 1000L ? 1 : 0) != 0);
    }
}

